/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.CustomItemGroup;
import io.github.lightman314.lightmanscurrency.Reference;
import io.github.lightman314.lightmanscurrency.common.capability.SpawnTrackerCapability;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalItemTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.traderSearching.ItemTraderSearchFilter;
import io.github.lightman314.lightmanscurrency.common.universal_traders.traderSearching.TraderSearchFilter;
import io.github.lightman314.lightmanscurrency.core.LootManager;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.datagen.RecipeGen;
import io.github.lightman314.lightmanscurrency.discord.DiscordListenerRegistration;
import io.github.lightman314.lightmanscurrency.gamerule.ModGameRules;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.time.MessageSyncClientTime;
import io.github.lightman314.lightmanscurrency.proxy.ClientProxy;
import io.github.lightman314.lightmanscurrency.proxy.CommonProxy;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeRule;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerBlacklist;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerDiscounts;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerTradeLimit;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerWhitelist;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TimedSale;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeLimit;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lightmanscurrency")
public class LightmansCurrency {
    public static final String MODID = "lightmanscurrency";
    public static final CommonProxy PROXY = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CustomItemGroup COIN_GROUP = new CustomItemGroup("lightmanscurrency.coins", () -> ModBlocks.COINPILE_GOLD);
    public static final CustomItemGroup MACHINE_GROUP = new CustomItemGroup("lightmanscurrency.machines", () -> ModBlocks.MACHINE_ATM);
    public static final CustomItemGroup TRADING_GROUP = new CustomItemGroup("lightmanscurrency.trading", () -> ModBlocks.DISPLAY_CASE);
    private static boolean discordIntegrationLoaded = false;

    public static boolean isDiscordIntegrationLoaded() {
        return discordIntegrationLoaded;
    }

    public LightmansCurrency() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doCommonStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onDataSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.serverSpec);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)PROXY);
        discordIntegrationLoaded = ModList.get().isLoaded("lightmansdiscord");
        if (discordIntegrationLoaded) {
            MinecraftForge.EVENT_BUS.register(DiscordListenerRegistration.class);
        }
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        LightmansCurrencyPacketHandler.init();
        WalletCapability.register();
        SpawnTrackerCapability.register();
        TradingOffice.RegisterDataType(UniversalItemTraderData.TYPE, (Supplier<? extends UniversalTraderData>)((Supplier)() -> new UniversalItemTraderData()));
        ModGameRules.registerRules();
        TradeRule.RegisterDeserializer(PlayerWhitelist.TYPE, (Supplier<TradeRule>)((Supplier)() -> new PlayerWhitelist()));
        TradeRule.RegisterDeserializer(PlayerBlacklist.TYPE, (Supplier<TradeRule>)((Supplier)() -> new PlayerBlacklist()));
        TradeRule.RegisterDeserializer(PlayerTradeLimit.TYPE, (Supplier<TradeRule>)((Supplier)() -> new PlayerTradeLimit()));
        TradeRule.RegisterDeserializer(PlayerTradeLimit.OLD_TYPE, (Supplier<TradeRule>)((Supplier)() -> new PlayerTradeLimit()), true);
        TradeRule.RegisterDeserializer(PlayerDiscounts.TYPE, (Supplier<TradeRule>)((Supplier)() -> new PlayerDiscounts()));
        TradeRule.RegisterDeserializer(TimedSale.TYPE, (Supplier<TradeRule>)((Supplier)() -> new TimedSale()));
        TradeRule.RegisterDeserializer(TradeLimit.TYPE, (Supplier<TradeRule>)((Supplier)() -> new TradeLimit()));
        TradeRule.RegisterDeserializer(TradeLimit.OLD_TYPE, (Supplier<TradeRule>)((Supplier)() -> new TradeLimit()), true);
        TraderSearchFilter.addFilter(new ItemTraderSearchFilter());
        COIN_GROUP.initSortingList(Lists.newArrayList((Object[])new IItemProvider[]{ModItems.COIN_COPPER, ModItems.COIN_IRON, ModItems.COIN_GOLD, ModItems.COIN_EMERALD, ModItems.COIN_DIAMOND, ModItems.COIN_NETHERITE, ModBlocks.COINPILE_COPPER.item, ModBlocks.COINPILE_IRON.item, ModBlocks.COINPILE_GOLD.item, ModBlocks.COINPILE_EMERALD.item, ModBlocks.COINPILE_DIAMOND.item, ModBlocks.COINPILE_NETHERITE.item, ModBlocks.COINBLOCK_COPPER.item, ModBlocks.COINBLOCK_IRON.item, ModBlocks.COINBLOCK_GOLD.item, ModBlocks.COINBLOCK_EMERALD.item, ModBlocks.COINBLOCK_DIAMOND.item, ModBlocks.COINBLOCK_NETHERITE.item, ModItems.TRADING_CORE, ModItems.TICKET, ModItems.TICKET_MASTER, ModItems.WALLET_COPPER, ModItems.WALLET_IRON, ModItems.WALLET_GOLD, ModItems.WALLET_EMERALD, ModItems.WALLET_DIAMOND, ModItems.WALLET_NETHERITE}));
        MACHINE_GROUP.initSortingList(Lists.newArrayList((Object[])new IItemProvider[]{ModBlocks.MACHINE_ATM.item, ModItems.PORTABLE_ATM, ModBlocks.MACHINE_MINT.item, ModBlocks.CASH_REGISTER.item, ModBlocks.TERMINAL.item, ModItems.PORTABLE_TERMINAL, ModBlocks.PAYGATE.item, ModBlocks.TICKET_MACHINE.item}));
        TRADING_GROUP.initSortingList(Lists.newArrayList((Object[])new IItemProvider[]{ModBlocks.SHELF.getItem(Reference.WoodType.OAK), ModBlocks.SHELF.getItem(Reference.WoodType.BIRCH), ModBlocks.SHELF.getItem(Reference.WoodType.SPRUCE), ModBlocks.SHELF.getItem(Reference.WoodType.JUNGLE), ModBlocks.SHELF.getItem(Reference.WoodType.ACACIA), ModBlocks.SHELF.getItem(Reference.WoodType.DARK_OAK), ModBlocks.SHELF.getItem(Reference.WoodType.CRIMSON), ModBlocks.SHELF.getItem(Reference.WoodType.WARPED), ModBlocks.DISPLAY_CASE.item, ModBlocks.ARMOR_DISPLAY.item, ModBlocks.CARD_DISPLAY.getItem(Reference.WoodType.OAK), ModBlocks.CARD_DISPLAY.getItem(Reference.WoodType.BIRCH), ModBlocks.CARD_DISPLAY.getItem(Reference.WoodType.SPRUCE), ModBlocks.CARD_DISPLAY.getItem(Reference.WoodType.JUNGLE), ModBlocks.CARD_DISPLAY.getItem(Reference.WoodType.ACACIA), ModBlocks.CARD_DISPLAY.getItem(Reference.WoodType.DARK_OAK), ModBlocks.CARD_DISPLAY.getItem(Reference.WoodType.CRIMSON), ModBlocks.CARD_DISPLAY.getItem(Reference.WoodType.WARPED), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.WHITE), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.ORANGE), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.MAGENTA), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.LIGHTBLUE), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.YELLOW), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.LIME), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.PINK), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.GRAY), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.LIGHTGRAY), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.CYAN), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.PURPLE), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.BLUE), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.BROWN), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.GREEN), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.RED), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.BLACK), ModBlocks.FREEZER.item, ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.WHITE), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.ORANGE), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.MAGENTA), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.LIGHTBLUE), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.YELLOW), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.LIME), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.PINK), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.GRAY), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.LIGHTGRAY), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.CYAN), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.PURPLE), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.BLUE), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.BROWN), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.GREEN), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.RED), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.BLACK), ModBlocks.TICKET_KIOSK.item, ModBlocks.ITEM_TRADER_SERVER_SMALL.item, ModBlocks.ITEM_TRADER_SERVER_MEDIUM.item, ModBlocks.ITEM_TRADER_SERVER_LARGE.item, ModBlocks.ITEM_TRADER_SERVER_EXTRA_LARGE.item}));
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        PROXY.setupClient();
    }

    private void onConfigLoad(ModConfig.Loading event) {
        if (event.getConfig().getModId().equals(MODID) && event.getConfig().getSpec() == Config.commonSpec) {
            LootManager.validateEntityDropList();
        }
    }

    private void onDataSetup(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        dataGenerator.func_200390_a((IDataProvider)new RecipeGen(dataGenerator));
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PacketDistributor.PacketTarget target = LightmansCurrencyPacketHandler.getTarget(event.getPlayer());
        LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageSyncClientTime());
        LightmansCurrencyPacketHandler.instance.send(target, (Object)TradingOffice.getAdminSyncMessage());
    }

    public static ItemStack getWalletStack(PlayerEntity player) {
        AtomicReference<ItemStack> wallet = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
        WalletCapability.getWalletHandler((Entity)player).ifPresent(walletHandler -> wallet.set(walletHandler.getWallet()));
        if (!WalletItem.validWalletStack(wallet.get())) {
            LightmansCurrency.LogError(player.func_200200_C_().getString() + "'s equipped wallet is not a valid WalletItem.");
            LightmansCurrency.LogError("Equipped wallet is of type " + wallet.get().func_77973_b().getClass().getName());
            return ItemStack.field_190927_a;
        }
        return wallet.get();
    }

    public static void LogDebug(String message) {
        LOGGER.debug(message);
    }

    public static void LogInfo(String message) {
        if (Config.COMMON != null && (Integer)Config.COMMON.debugLevel.get() > 0) {
            LOGGER.debug("INFO: " + message);
        } else {
            LOGGER.info(message);
        }
    }

    public static void LogWarning(String message) {
        if (Config.COMMON != null && (Integer)Config.COMMON.debugLevel.get() > 1) {
            LOGGER.debug("WARN: " + message);
        } else {
            LOGGER.warn(message);
        }
    }

    public static void LogError(String message) {
        if (Config.COMMON != null && (Integer)Config.COMMON.debugLevel.get() > 2) {
            LOGGER.debug("ERROR: " + message);
        } else {
            LOGGER.error(message);
        }
    }

    public static void LogError(String message, Object ... messages) {
        if (Config.COMMON != null && (Integer)Config.COMMON.debugLevel.get() > 2) {
            LOGGER.debug("ERROR: " + message, messages);
        } else {
            LOGGER.error(message, messages);
        }
    }
}

