/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api;

import io.github.lightman314.lightmanscurrency.api.TextLogger;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class BankAccountLogger
extends TextLogger {
    public BankAccountLogger() {
        super("BankAccountHistory");
    }

    public void AddLog(ITrader trader, CoinValue amount, boolean isDeposit) {
        this.AddLog((ITextComponent)new TranslationTextComponent("log.bank", new Object[]{this.getTraderText(trader), this.getDepositText(isDeposit), BankAccountLogger.getCostText(amount)}));
    }

    public void AddLog(PlayerEntity player, CoinValue amount, boolean isDeposit) {
        this.AddLog((ITextComponent)new TranslationTextComponent("log.bank", new Object[]{this.getPlayerText(player), this.getDepositText(isDeposit), BankAccountLogger.getCostText(amount)}));
    }

    public void AddLog(PlayerEntity player, CoinValue amount, ITextComponent destination, boolean wasReceived) {
        this.AddLog((ITextComponent)new TranslationTextComponent("log.bank.transfer", new Object[]{this.getPlayerText(player), BankAccountLogger.getCostText(amount), this.getToFromText(wasReceived), destination}));
    }

    protected final ITextComponent getToFromText(boolean wasReceived) {
        return new TranslationTextComponent("log.bank.transfer." + (wasReceived ? "from" : "to"));
    }

    protected final ITextComponent getDepositText(boolean isDeposit) {
        return new TranslationTextComponent("log.bank." + (isDeposit ? "deposit" : "withdraw"));
    }

    protected final ITextComponent getTraderText(ITrader trader) {
        return new TranslationTextComponent(trader.getName().getString()).func_240699_a_(TextFormatting.YELLOW);
    }

    protected final ITextComponent getPlayerText(PlayerEntity player) {
        return new TranslationTextComponent(player.func_145748_c_().getString()).func_240699_a_(TextFormatting.GREEN);
    }
}

