/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api;

import io.github.lightman314.lightmanscurrency.api.TextLogger;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ItemShopLogger
extends TextLogger {
    public ItemShopLogger() {
        super("ItemShopHistory");
    }

    public void AddLog(PlayerEntity player, ItemTradeData trade, @Nonnull CoinValue pricePaid, boolean isCreative) {
        this.AddLog(PlayerReference.of(player), trade, pricePaid, isCreative);
    }

    public void AddLog(PlayerReference player, ItemTradeData trade, @Nonnull CoinValue pricePaid, boolean isCreative) {
        TranslationTextComponent creativeText = isCreative ? new TranslationTextComponent("log.shoplog.creative") : new StringTextComponent("");
        StringTextComponent playerName = new StringTextComponent("\u00a7a" + player.lastKnownName());
        TranslationTextComponent boughtText = new TranslationTextComponent("log.shoplog." + trade.getTradeType().name().toLowerCase());
        IFormattableTextComponent itemName = new StringTextComponent("").func_230529_a_(trade.getSellItem().func_200301_q()).func_240699_a_(trade.getSellItem().func_77953_t().field_77937_e);
        if (trade.getSellItem().func_82837_s()) {
            itemName.func_240699_a_(TextFormatting.ITALIC);
        }
        TranslationTextComponent itemText = new TranslationTextComponent("log.shoplog.item.itemformat", new Object[]{trade.getSellItem().func_190916_E(), itemName});
        ITextComponent cost = ItemShopLogger.getCostText(pricePaid);
        if (trade.isBarter()) {
            cost = itemText;
            IFormattableTextComponent barterItemName = new StringTextComponent("").func_230529_a_(trade.getBarterItem().func_200301_q()).func_240699_a_(trade.getSellItem().func_77953_t().field_77937_e);
            if (trade.getBarterItem().func_82837_s()) {
                itemName.func_240699_a_(TextFormatting.ITALIC);
            }
            itemText = new TranslationTextComponent("log.shoplog.item.itemformat", new Object[]{trade.getBarterItem().func_190916_E(), barterItemName});
        }
        this.AddLog((ITextComponent)new TranslationTextComponent("log.shoplog.item.format", new Object[]{creativeText, playerName, boughtText, itemText, cost}));
    }
}

