/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api;

import io.github.lightman314.lightmanscurrency.api.TextLogger;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class SettingsLogger
extends TextLogger {
    public SettingsLogger() {
        super("SettingsHistory");
    }

    public static final ITextComponent getEnableDisableText(boolean enabled, TextFormatting enableFormat, TextFormatting disableFormat) {
        return new TranslationTextComponent("log.settings." + (enabled ? "enabled" : "disabled")).func_240699_a_(enabled ? enableFormat : disableFormat);
    }

    public static final ITextComponent getToFromText(boolean enabled, TextFormatting ... format) {
        return new TranslationTextComponent("log.settings." + (enabled ? "to" : "from")).func_240701_a_(format);
    }

    public static final ITextComponent getAddRemoveText(boolean added, TextFormatting addFormat, TextFormatting removeFormat) {
        return new TranslationTextComponent("log.settings." + (added ? "add" : "remove")).func_240699_a_(added ? addFormat : removeFormat);
    }

    public static final ITextComponent getPlayerName(PlayerEntity player) {
        return new StringTextComponent(player.func_200200_C_().getString()).func_240699_a_(TextFormatting.GREEN);
    }

    public static final ITextComponent getTeamName(Team team) {
        if (team != null) {
            return new StringTextComponent(team.getName()).func_240699_a_(TextFormatting.GREEN);
        }
        return new StringTextComponent("NULL");
    }

    public static final ITextComponent getPlayerName(PlayerReference player) {
        return new StringTextComponent(player.lastKnownName()).func_240699_a_(TextFormatting.GREEN);
    }

    public static final ITextComponent format(Object value, TextFormatting ... format) {
        return new StringTextComponent(value.toString()).func_240701_a_(format);
    }

    public void LogNameChange(PlayerEntity player, String oldName, String newName) {
        if (player == null) {
            return;
        }
        if (oldName.isEmpty()) {
            this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.changename.set", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(newName, TextFormatting.GOLD)}));
        } else if (newName.isEmpty()) {
            this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.changename.reset", new Object[]{SettingsLogger.getPlayerName(player)}));
        } else {
            this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.changename", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(oldName, TextFormatting.GOLD), SettingsLogger.format(newName, TextFormatting.GOLD)}));
        }
    }

    public void LogOwnerChange(PlayerEntity player, PlayerReference oldOwner, PlayerReference newOwner) {
        if (player == null) {
            return;
        }
        if (oldOwner.is((Entity)player)) {
            this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.newowner.passed", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getPlayerName(newOwner)}));
        } else if (newOwner.is((Entity)player)) {
            this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.newowner.taken", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getPlayerName(oldOwner)}));
        } else {
            this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.newowner.transferred", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getPlayerName(oldOwner), SettingsLogger.getPlayerName(newOwner)}));
        }
    }

    public void LogTeamChange(PlayerEntity player, PlayerReference owner, Team oldTeam, Team newTeam) {
        if (player == null || owner == null) {
            return;
        }
        if (oldTeam == null) {
            if (owner.is((Entity)player)) {
                this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.newowner.passed", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getTeamName(newTeam)}));
            } else {
                this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.newowner.transferred", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getPlayerName(owner), SettingsLogger.getTeamName(newTeam)}));
            }
        } else if (newTeam == null) {
            if (owner.is((Entity)player)) {
                this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.newowner.taken", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getTeamName(oldTeam)}));
            } else {
                this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.newowner.transferred", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getTeamName(oldTeam), SettingsLogger.getPlayerName(owner)}));
            }
        } else {
            this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.newowner.transferred", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getTeamName(oldTeam), SettingsLogger.getTeamName(newTeam)}));
        }
    }

    public void LogCreativeToggle(PlayerEntity player, boolean isNowCreative) {
        this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.creativemode", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getEnableDisableText(isNowCreative, TextFormatting.GREEN, TextFormatting.RED)}));
    }

    public void LogAddRemoveTrade(PlayerEntity player, boolean added, int newCount) {
        this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.addremovetrade", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getAddRemoveText(added, TextFormatting.GOLD, TextFormatting.GOLD), SettingsLogger.format(newCount, TextFormatting.GOLD)}));
    }

    public void LogAllyChange(PlayerEntity player, PlayerReference ally, boolean added) {
        this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.addremoveally", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getAddRemoveText(added, TextFormatting.GOLD, TextFormatting.GOLD), SettingsLogger.getPlayerName(ally), SettingsLogger.getToFromText(added, new TextFormatting[0])}));
    }

    public void LogAllyPermissionChange(PlayerEntity player, String permission, Object oldValue, Object newValue) {
        this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.permission.ally", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(permission, TextFormatting.GOLD), SettingsLogger.format(oldValue, TextFormatting.GOLD), SettingsLogger.format(newValue, TextFormatting.GOLD)}));
    }

    public void LogAllyPermissionChange(PlayerEntity player, String permission, Object newValue) {
        this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.permission.ally.simple", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(permission, TextFormatting.GOLD), SettingsLogger.format(newValue, TextFormatting.GOLD)}));
    }

    public void LogSettingsChange(PlayerEntity player, String setting, Object oldValue, Object newValue) {
        this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.change", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(setting, TextFormatting.GOLD), SettingsLogger.format(oldValue, TextFormatting.GOLD), SettingsLogger.format(newValue, TextFormatting.GOLD)}));
    }

    public void LogSettingsChange(PlayerEntity player, String setting, Object newValue) {
        this.AddLog((ITextComponent)new TranslationTextComponent("log.settings.change.simple", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(setting, TextFormatting.GOLD), SettingsLogger.format(newValue, TextFormatting.GOLD)}));
    }

    public void LogText(ITextComponent text) {
        this.AddLog(text);
    }
}

