/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api;

import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class TextLogger {
    public final List<ITextComponent> logText = new ArrayList<ITextComponent>();
    protected final String tag;

    protected TextLogger(String tagName) {
        this.tag = tagName;
    }

    public final void clear() {
        this.logText.clear();
    }

    protected final void AddLog(ITextComponent text) {
        if (text != null) {
            this.logText.add(text);
            this.fitToSizeLimit();
        }
    }

    public void write(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.logText.size(); ++i) {
            ITextComponent text = this.logText.get(i);
            CompoundNBT thisCompound = new CompoundNBT();
            thisCompound.func_74778_a("value", ITextComponent.Serializer.func_150696_a((ITextComponent)text));
            list.add((Object)thisCompound);
        }
        compound.func_218657_a(this.tag, (INBT)list);
    }

    public void read(CompoundNBT compound) {
        if (compound.func_150297_b(this.tag, 9)) {
            ListNBT list = compound.func_150295_c(this.tag, 10);
            this.logText.clear();
            for (int i = 0; i < list.size(); ++i) {
                String jsonText = list.func_150305_b(i).func_74779_i("value");
                IFormattableTextComponent text = ITextComponent.Serializer.func_240643_a_((String)jsonText);
                if (text == null) continue;
                this.logText.add((ITextComponent)text);
            }
            this.fitToSizeLimit();
        }
    }

    public final void fitToSizeLimit() {
        while (this.logText.size() > (Integer)Config.SERVER.logLimit.get() && this.logText.size() > 0) {
            this.logText.remove(0);
        }
    }

    public static ITextComponent getCostText(CoinValue cost) {
        return new StringTextComponent(cost.getString()).func_240699_a_(TextFormatting.YELLOW);
    }
}

