/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks;

import io.github.lightman314.lightmanscurrency.blocks.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.blocks.RotatableItemBlock;
import io.github.lightman314.lightmanscurrency.tileentity.ArmorDisplayTraderTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.ItemInterfaceTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.ItemTraderTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.TraderTileEntity;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArmorDisplayBlock
extends RotatableItemBlock
implements IItemTraderBlock {
    public static final int TRADECOUNT = 4;
    private static final VoxelShape SHAPE_BOTTOM = ArmorDisplayBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    private static final VoxelShape SHAPE_TOP = ArmorDisplayBlock.func_208617_a((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final BooleanProperty ISBOTTOM = BlockStateProperties.field_222513_b;

    public ArmorDisplayBlock(AbstractBlock.Properties properties) {
        super(properties, null);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext contect) {
        if (((Boolean)state.func_177229_b((Property)ISBOTTOM)).booleanValue()) {
            return SHAPE_BOTTOM;
        }
        return SHAPE_TOP;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ISBOTTOM});
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true));
    }

    public boolean func_196260_a(BlockState state, IWorldReader reader, BlockPos pos) {
        return reader.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TraderTileEntity tileEntity = (TraderTileEntity)this.getTileEntity(state, (IWorld)worldIn, pos);
        if (tileEntity != null) {
            if (!tileEntity.canBreak(player)) {
                return;
            }
            tileEntity.dumpContents(worldIn, pos);
        }
        if (tileEntity instanceof ArmorDisplayTraderTileEntity) {
            ((ArmorDisplayTraderTileEntity)tileEntity).destroyArmorStand();
        }
        if (((Boolean)state.func_177229_b((Property)ISBOTTOM)).booleanValue()) {
            BlockState upState = worldIn.func_180495_p(pos.func_177984_a());
            if (upState.func_177230_c() instanceof ArmorDisplayBlock) {
                worldIn.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 35);
                worldIn.func_217378_a(player, 2001, pos.func_177984_a(), Block.func_196246_j((BlockState)upState));
            }
        } else {
            BlockState downState = worldIn.func_180495_p(pos.func_177977_b());
            if (downState.func_177230_c() instanceof ArmorDisplayBlock) {
                worldIn.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 35);
                worldIn.func_217378_a(player, 2001, pos.func_177984_a(), Block.func_196246_j((BlockState)downState));
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        ItemTraderTileEntity tileEntity;
        worldIn.func_175656_a(pos.func_177984_a(), (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)ISBOTTOM, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)));
        if (!worldIn.func_201670_d() && (tileEntity = (ItemTraderTileEntity)worldIn.func_175625_s(pos)) != null) {
            tileEntity.initOwner(PlayerReference.of((Entity)player));
            if (stack.func_82837_s()) {
                tileEntity.getCoreSettings().setCustomName(null, stack.func_200301_q().getString());
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        TileEntity tileEntity;
        if (!world.func_201670_d() && (tileEntity = this.getTileEntity(state, (IWorld)world, pos)) instanceof ItemTraderTileEntity) {
            ItemTraderTileEntity trader = (ItemTraderTileEntity)tileEntity;
            trader.getCoreSettings().updateNames(playerEntity);
            TileEntityUtil.sendUpdatePacket(tileEntity);
            trader.openTradeMenu((PlayerEntity)((ServerPlayerEntity)playerEntity));
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public ItemInterfaceTileEntity.IItemHandlerTileEntity getItemHandlerEntity(BlockState state, World world, BlockPos pos) {
        TileEntity trader = this.getTileEntity(state, (IWorld)world, pos);
        if (trader instanceof ItemInterfaceTileEntity.IItemHandlerTileEntity) {
            return (ItemInterfaceTileEntity.IItemHandlerTileEntity)trader;
        }
        return null;
    }

    @Override
    public TileEntity getTileEntity(BlockState state, IWorld world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((Property)ISBOTTOM)).booleanValue()) {
            return world.func_175625_s(pos);
        }
        return world.func_175625_s(pos.func_177977_b());
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (((Boolean)state.func_177229_b((Property)ISBOTTOM)).booleanValue()) {
            return new ArmorDisplayTraderTileEntity();
        }
        return new ItemInterfaceTileEntity();
    }

    @Override
    public List<Vector3f> GetStackRenderPos(int tradeSlot, BlockState state, boolean isBlock) {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Quaternion> GetStackRenderRot(int tradeSlot, BlockState state, boolean isBlock) {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vector3f GetStackRenderScale(int tradeSlot, BlockState state, boolean isBlock) {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int maxRenderIndex() {
        return 0;
    }
}

