/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks;

import io.github.lightman314.lightmanscurrency.blocks.RotatableBlock;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.tileentity.CoinJarTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CoinJarBlock
extends RotatableBlock {
    public CoinJarBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public CoinJarBlock(AbstractBlock.Properties properties, VoxelShape shape) {
        super(properties, shape);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CoinJarTileEntity();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof CoinJarTileEntity) {
            CoinJarTileEntity jarEntity = (CoinJarTileEntity)tileEntity;
            jarEntity.readItemTag(stack);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        if (!world.func_201670_d()) {
            CoinJarTileEntity jarEntity;
            ItemStack coinStack = CoinJarBlock.getPlayersHeldCoin(playerEntity);
            if (coinStack.func_190926_b()) {
                return ActionResultType.SUCCESS;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof CoinJarTileEntity && (jarEntity = (CoinJarTileEntity)tileEntity).addCoin(coinStack)) {
                coinStack.func_190918_g(1);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private static ItemStack getPlayersHeldCoin(PlayerEntity player) {
        if (MoneyUtil.isCoin(player.field_71071_by.func_70448_g(), false)) {
            return player.field_71071_by.func_70448_g();
        }
        if (MoneyUtil.isCoin((ItemStack)player.field_71071_by.field_184439_c.get(0), false)) {
            return (ItemStack)player.field_71071_by.field_184439_c.get(0);
        }
        return ItemStack.field_190927_a;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof CoinJarTileEntity) {
            CoinJarTileEntity jarEntity = (CoinJarTileEntity)tileEntity;
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.field_71071_by.func_70448_g()) > 0) {
                ItemStack dropStack = new ItemStack((IItemProvider)Item.func_150898_a((Block)this), 1);
                if (jarEntity.getStorage().size() > 0) {
                    jarEntity.writeItemTag(dropStack);
                }
                Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)dropStack);
            } else {
                jarEntity.getStorage().forEach(coin -> Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)coin));
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }
}

