/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks;

import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.blocks.RotatableBlock;
import io.github.lightman314.lightmanscurrency.containers.MintContainer;
import io.github.lightman314.lightmanscurrency.tileentity.CoinMintTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class CoinMintBlock
extends RotatableBlock {
    private static final TranslationTextComponent TITLE = new TranslationTextComponent("gui.lightmanscurrency.coinmint.title");

    public CoinMintBlock(AbstractBlock.Properties properties) {
        super(properties, CoinMintBlock.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CoinMintTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        TileEntity tileEntity;
        if (!world.field_72995_K && ((tileEntity = world.func_175625_s(pos)) instanceof CoinMintTileEntity && ((Boolean)Config.SERVER.allowCoinMinting.get()).booleanValue() || ((Boolean)Config.SERVER.allowCoinMelting.get()).booleanValue())) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new CoinMintMenuProvider((CoinMintTileEntity)tileEntity), (BlockPos)pos);
            return ActionResultType.SUCCESS;
        }
        if (((Boolean)Config.SERVER.allowCoinMinting.get()).booleanValue() || ((Boolean)Config.SERVER.allowCoinMelting.get()).booleanValue()) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof CoinMintTileEntity) {
            CoinMintTileEntity mintEntity = (CoinMintTileEntity)tileEntity;
            mintEntity.dumpContents(worldIn, pos);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    private static class CoinMintMenuProvider
    implements INamedContainerProvider {
        private final CoinMintTileEntity tileEntity;

        public CoinMintMenuProvider(CoinMintTileEntity tileEntity) {
            this.tileEntity = tileEntity;
        }

        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity entity) {
            return new MintContainer(id, inventory, this.tileEntity);
        }

        public ITextComponent func_145748_c_() {
            return TITLE;
        }
    }
}

