/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks;

import io.github.lightman314.lightmanscurrency.blocks.CoinBlock;
import io.github.lightman314.lightmanscurrency.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class CoinpileBlock
extends CoinBlock
implements IRotatableBlock,
IWaterLoggable {
    private final VoxelShape SHAPE = CoinpileBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    public CoinpileBlock(AbstractBlock.Properties properties, Item coinItem) {
        super(properties, coinItem);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected int getCoinCount() {
        return 9;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        FluidState fluidstate = context.func_195991_k().func_204610_c(blockpos);
        return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext contect) {
        return this.SHAPE;
    }

    @Override
    public BlockPos getRightPos(BlockPos pos, Direction facing) {
        switch (facing) {
            case NORTH: {
                return new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            }
            case SOUTH: {
                return new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            }
            case EAST: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            }
            case WEST: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            }
        }
        return pos;
    }

    @Override
    public BlockPos getLeftPos(BlockPos pos, Direction facing) {
        switch (facing) {
            case NORTH: {
                return new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            }
            case SOUTH: {
                return new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            }
            case EAST: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            }
            case WEST: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            }
        }
        return pos;
    }

    @Override
    public BlockPos getForwardPos(BlockPos pos, Direction facing) {
        switch (facing) {
            case NORTH: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            }
            case SOUTH: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            }
            case EAST: {
                return new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            }
            case WEST: {
                return new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return pos;
    }

    @Override
    public BlockPos getBackwardPos(BlockPos pos, Direction facing) {
        switch (facing) {
            case NORTH: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            }
            case SOUTH: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            }
            case EAST: {
                return new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            }
            case WEST: {
                return new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return pos;
    }

    @Override
    public Vector3f getRightVect(Direction facing) {
        switch (facing) {
            case NORTH: {
                return new Vector3f(1.0f, 0.0f, 0.0f);
            }
            case SOUTH: {
                return new Vector3f(-1.0f, 0.0f, 0.0f);
            }
            case EAST: {
                return new Vector3f(0.0f, 0.0f, 1.0f);
            }
            case WEST: {
                return new Vector3f(0.0f, 0.0f, -1.0f);
            }
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    @Override
    public Vector3f getLeftVect(Direction facing) {
        return MathUtil.VectorMult(this.getRightVect(facing), -1.0f);
    }

    @Override
    public Vector3f getForwardVect(Direction facing) {
        switch (facing) {
            case NORTH: {
                return new Vector3f(0.0f, 0.0f, -1.0f);
            }
            case SOUTH: {
                return new Vector3f(0.0f, 0.0f, 1.0f);
            }
            case EAST: {
                return new Vector3f(1.0f, 0.0f, 0.0f);
            }
            case WEST: {
                return new Vector3f(-1.0f, 0.0f, 0.0f);
            }
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    @Override
    public Vector3f getOffsetVect(Direction facing) {
        switch (facing) {
            case NORTH: {
                return new Vector3f(0.0f, 0.0f, 1.0f);
            }
            case SOUTH: {
                return new Vector3f(1.0f, 0.0f, 0.0f);
            }
            case WEST: {
                return new Vector3f(1.0f, 0.0f, 1.0f);
            }
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    @Override
    public Vector3f getBackwardVect(Direction facing) {
        return MathUtil.VectorMult(this.getForwardVect(facing), -1.0f);
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.func_177229_b((Property)FACING);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }
}

