/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks;

import io.github.lightman314.lightmanscurrency.blocks.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.tileentity.ItemInterfaceTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.ItemTraderTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.TraderTileEntity;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DisplayCaseBlock
extends Block
implements IItemTraderBlock {
    public static final int TRADECOUNT = 1;

    public DisplayCaseBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ItemTraderTileEntity(1);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        TileEntity tileEntity;
        if (!world.func_201670_d() && (tileEntity = world.func_175625_s(pos)) instanceof ItemTraderTileEntity) {
            ItemTraderTileEntity trader = (ItemTraderTileEntity)tileEntity;
            trader.getCoreSettings().updateNames(playerEntity);
            TileEntityUtil.sendUpdatePacket(tileEntity);
            trader.openTradeMenu((PlayerEntity)((ServerPlayerEntity)playerEntity));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        ItemTraderTileEntity tileEntity;
        if (!worldIn.func_201670_d() && (tileEntity = (ItemTraderTileEntity)worldIn.func_175625_s(pos)) != null) {
            tileEntity.initOwner(PlayerReference.of((Entity)player));
            if (stack.func_82837_s()) {
                tileEntity.getCoreSettings().setCustomName(null, stack.func_200301_q().getString());
            }
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TraderTileEntity tileEntity = (TraderTileEntity)this.getTileEntity(state, (IWorld)worldIn, pos);
        if (tileEntity != null) {
            if (!tileEntity.canBreak(player)) {
                return;
            }
            tileEntity.dumpContents(worldIn, pos);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Vector3f> GetStackRenderPos(int tradeSlot, BlockState state, boolean isBlock) {
        ArrayList<Vector3f> posList = new ArrayList<Vector3f>(1);
        posList.add(new Vector3f(0.5f, 0.625f, 0.5f));
        return posList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Quaternion> GetStackRenderRot(int tradeSlot, BlockState state, boolean isBlock) {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vector3f GetStackRenderScale(int tradeSlot, BlockState state, boolean isBlock) {
        return new Vector3f(0.75f, 0.75f, 0.75f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int maxRenderIndex() {
        return 1;
    }

    @Override
    public TileEntity getTileEntity(BlockState state, IWorld world, BlockPos pos) {
        return world.func_175625_s(pos);
    }

    @Override
    public ItemInterfaceTileEntity.IItemHandlerTileEntity getItemHandlerEntity(BlockState state, World world, BlockPos pos) {
        TileEntity trader = this.getTileEntity(state, (IWorld)world, pos);
        if (trader instanceof ItemInterfaceTileEntity.IItemHandlerTileEntity) {
            return (ItemInterfaceTileEntity.IItemHandlerTileEntity)trader;
        }
        return null;
    }

    @Override
    public Direction getRelativeSide(BlockState state, Direction side) {
        return side;
    }
}

