/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks;

import io.github.lightman314.lightmanscurrency.blocks.ITraderBlock;
import io.github.lightman314.lightmanscurrency.blocks.RotatableBlock;
import io.github.lightman314.lightmanscurrency.tileentity.UniversalItemTraderTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.UniversalTraderTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ItemTraderServerBlock
extends RotatableBlock
implements ITraderBlock {
    final int tradeCount;

    public ItemTraderServerBlock(AbstractBlock.Properties properties, int tradeCount) {
        super(properties);
        this.tradeCount = tradeCount;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new UniversalItemTraderTileEntity(this.tradeCount);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        UniversalTraderTileEntity tileEntity;
        if (!worldIn.func_201670_d() && (tileEntity = (UniversalTraderTileEntity)worldIn.func_175625_s(pos)) != null && player instanceof PlayerEntity) {
            if (stack.func_82837_s()) {
                tileEntity.init((PlayerEntity)player, stack.func_200301_q().getString());
            } else {
                tileEntity.init((PlayerEntity)player);
            }
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        UniversalTraderTileEntity tileEntity = (UniversalTraderTileEntity)worldIn.func_175625_s(pos);
        if (tileEntity != null) {
            if (!tileEntity.canBreak(player)) {
                return;
            }
            tileEntity.onDestroyed();
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        UniversalItemTraderTileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = (UniversalItemTraderTileEntity)world.func_175625_s(pos)) != null && tileEntity.hasPermission(playerEntity, "openStorage")) {
            tileEntity.updateNames(playerEntity);
            tileEntity.openStorageMenu(playerEntity);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public TileEntity getTileEntity(BlockState state, IWorld world, BlockPos pos) {
        return world.func_175625_s(pos);
    }
}

