/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.blocks.RotatableBlock;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.tileentity.PaygateTileEntity;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class PaygateBlock
extends RotatableBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public PaygateBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PaygateTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        TileEntity tileEntity;
        if (!world.func_201670_d() && (tileEntity = world.func_175625_s(pos)) instanceof PaygateTileEntity) {
            PaygateTileEntity trader = (PaygateTileEntity)tileEntity;
            if (trader.isOwner((Entity)playerEntity)) {
                trader.setOwner((Entity)playerEntity);
            }
            if (!trader.isActive() && trader.validTicket(playerEntity.func_184586_b(hand))) {
                trader.activate();
                playerEntity.func_184586_b(hand).func_190918_g(1);
                ItemStack ticketStub = new ItemStack((IItemProvider)ModItems.TICKET_STUB);
                if (!playerEntity.field_71071_by.func_70441_a(ticketStub)) {
                    InventoryUtil.dumpContents(world, playerEntity.func_233580_cy_(), (List<ItemStack>)ImmutableList.of((Object)ticketStub));
                }
                return ActionResultType.SUCCESS;
            }
            TileEntityUtil.sendUpdatePacket(tileEntity);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        PaygateTileEntity tileEntity;
        if (!worldIn.func_201670_d() && (tileEntity = (PaygateTileEntity)worldIn.func_175625_s(pos)) != null) {
            tileEntity.setOwner((Entity)player);
            if (stack.func_82837_s()) {
                tileEntity.setCustomName(stack.func_200301_q());
            }
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (worldIn.func_175625_s(pos) instanceof PaygateTileEntity) {
            PaygateTileEntity tileEntity = (PaygateTileEntity)worldIn.func_175625_s(pos);
            List<ItemStack> coins = MoneyUtil.getCoinsOfValue(tileEntity.getStoredMoney());
            InventoryUtil.dumpContents(worldIn, pos, coins);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{POWERED});
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.func_177229_b((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }
}

