/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks;

import io.github.lightman314.lightmanscurrency.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;

public class RotatableBlock
extends Block
implements IRotatableBlock {
    private final VoxelShape SHAPE;
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    public RotatableBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.SHAPE = RotatableBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public RotatableBlock(AbstractBlock.Properties properties, VoxelShape customShape) {
        super(properties);
        this.SHAPE = customShape;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext contect) {
        return this.SHAPE;
    }

    @Override
    public BlockPos getRightPos(BlockPos pos, Direction facing) {
        switch (facing) {
            case NORTH: {
                return new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            }
            case SOUTH: {
                return new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            }
            case EAST: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            }
            case WEST: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            }
        }
        return pos;
    }

    @Override
    public BlockPos getLeftPos(BlockPos pos, Direction facing) {
        switch (facing) {
            case NORTH: {
                return new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            }
            case SOUTH: {
                return new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            }
            case EAST: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            }
            case WEST: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            }
        }
        return pos;
    }

    @Override
    public BlockPos getForwardPos(BlockPos pos, Direction facing) {
        switch (facing) {
            case NORTH: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            }
            case SOUTH: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            }
            case EAST: {
                return new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            }
            case WEST: {
                return new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return pos;
    }

    @Override
    public BlockPos getBackwardPos(BlockPos pos, Direction facing) {
        switch (facing) {
            case NORTH: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            }
            case SOUTH: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            }
            case EAST: {
                return new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            }
            case WEST: {
                return new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return pos;
    }

    @Override
    public Vector3f getRightVect(Direction facing) {
        switch (facing) {
            case NORTH: {
                return new Vector3f(1.0f, 0.0f, 0.0f);
            }
            case SOUTH: {
                return new Vector3f(-1.0f, 0.0f, 0.0f);
            }
            case EAST: {
                return new Vector3f(0.0f, 0.0f, 1.0f);
            }
            case WEST: {
                return new Vector3f(0.0f, 0.0f, -1.0f);
            }
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    @Override
    public Vector3f getLeftVect(Direction facing) {
        return MathUtil.VectorMult(this.getRightVect(facing), -1.0f);
    }

    @Override
    public Vector3f getForwardVect(Direction facing) {
        switch (facing) {
            case NORTH: {
                return new Vector3f(0.0f, 0.0f, -1.0f);
            }
            case SOUTH: {
                return new Vector3f(0.0f, 0.0f, 1.0f);
            }
            case EAST: {
                return new Vector3f(1.0f, 0.0f, 0.0f);
            }
            case WEST: {
                return new Vector3f(-1.0f, 0.0f, 0.0f);
            }
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    @Override
    public Vector3f getOffsetVect(Direction facing) {
        switch (facing) {
            case NORTH: {
                return new Vector3f(0.0f, 0.0f, 1.0f);
            }
            case SOUTH: {
                return new Vector3f(1.0f, 0.0f, 0.0f);
            }
            case WEST: {
                return new Vector3f(1.0f, 0.0f, 1.0f);
            }
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    @Override
    public Vector3f getBackwardVect(Direction facing) {
        return MathUtil.VectorMult(this.getForwardVect(facing), -1.0f);
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.func_177229_b((Property)FACING);
    }
}

