/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks;

import io.github.lightman314.lightmanscurrency.blocks.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.blocks.RotatableItemBlock;
import io.github.lightman314.lightmanscurrency.tileentity.ItemInterfaceTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.ItemTraderTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.TraderTileEntity;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShelfBlock
extends RotatableItemBlock
implements IItemTraderBlock {
    public static final int TRADECOUNT = 1;
    private static final VoxelShape SHAPE_NORTH = ShelfBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0);
    private static final VoxelShape SHAPE_SOUTH = ShelfBlock.func_208617_a((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = ShelfBlock.func_208617_a((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = ShelfBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0);

    public ShelfBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ItemTraderTileEntity(1);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        TileEntity tileEntity;
        if (!world.func_201670_d() && (tileEntity = world.func_175625_s(pos)) instanceof ItemTraderTileEntity) {
            ItemTraderTileEntity trader = (ItemTraderTileEntity)tileEntity;
            trader.getCoreSettings().updateNames(playerEntity);
            TileEntityUtil.sendUpdatePacket(tileEntity);
            trader.openTradeMenu((PlayerEntity)((ServerPlayerEntity)playerEntity));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        ItemTraderTileEntity tileEntity;
        if (!worldIn.func_201670_d() && (tileEntity = (ItemTraderTileEntity)worldIn.func_175625_s(pos)) != null) {
            tileEntity.initOwner(PlayerReference.of((Entity)player));
            if (stack.func_82837_s()) {
                tileEntity.getCoreSettings().setCustomName(null, stack.func_200301_q().getString());
            }
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TraderTileEntity tileEntity = (TraderTileEntity)this.getTileEntity(state, (IWorld)worldIn, pos);
        if (tileEntity != null) {
            if (!tileEntity.canBreak(player)) {
                return;
            }
            tileEntity.dumpContents(worldIn, pos);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Vector3f> GetStackRenderPos(int tradeSlot, BlockState state, boolean isBlock) {
        ArrayList<Vector3f> posList = new ArrayList<Vector3f>(1);
        Direction facing = this.getFacing(state);
        Vector3f forward = this.getForwardVect(facing);
        Vector3f right = this.getRightVect(facing);
        Vector3f up = Vector3f.field_229181_d_;
        Vector3f offset = this.getOffsetVect(facing);
        if (tradeSlot == 0) {
            float distance;
            Vector3f firstPosition = MathUtil.VectorAdd(offset, MathUtil.VectorMult(right, 0.5f), MathUtil.VectorMult(forward, 0.90625f), MathUtil.VectorMult(up, 0.5625f));
            posList.add(firstPosition);
            float f = distance = isBlock ? -3.2f : -1.0f;
            while (distance >= -3.0f) {
                posList.add(MathUtil.VectorAdd(firstPosition, MathUtil.VectorMult(forward, distance / 16.0f)));
                distance -= isBlock ? 3.2f : 1.0f;
            }
        }
        return posList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Quaternion> GetStackRenderRot(int tradeSlot, BlockState state, boolean isBlock) {
        ArrayList<Quaternion> rotation = new ArrayList<Quaternion>();
        int facing = ((Direction)state.func_177229_b((Property)FACING)).func_176736_b();
        rotation.add(Vector3f.field_229181_d_.func_229187_a_((float)facing * -90.0f));
        return rotation;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vector3f GetStackRenderScale(int tradeSlot, BlockState state, boolean isBlock) {
        return new Vector3f(0.875f, 0.875f, 0.875f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int maxRenderIndex() {
        return 1;
    }

    @Override
    public TileEntity getTileEntity(BlockState state, IWorld world, BlockPos pos) {
        return world.func_175625_s(pos);
    }

    @Override
    public ItemInterfaceTileEntity.IItemHandlerTileEntity getItemHandlerEntity(BlockState state, World world, BlockPos pos) {
        TileEntity trader = this.getTileEntity(state, (IWorld)world, pos);
        if (trader instanceof ItemInterfaceTileEntity.IItemHandlerTileEntity) {
            return (ItemInterfaceTileEntity.IItemHandlerTileEntity)trader;
        }
        return null;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext contect) {
        if (state.func_177229_b((Property)FACING) == Direction.NORTH) {
            return SHAPE_NORTH;
        }
        if (state.func_177229_b((Property)FACING) == Direction.SOUTH) {
            return SHAPE_SOUTH;
        }
        if (state.func_177229_b((Property)FACING) == Direction.EAST) {
            return SHAPE_EAST;
        }
        return SHAPE_WEST;
    }
}

