/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blocks.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.blocks.RotatableItemBlock;
import io.github.lightman314.lightmanscurrency.tileentity.ItemInterfaceTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.ItemTraderTileEntity;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VendingMachineLargeBlock
extends RotatableItemBlock
implements IItemTraderBlock {
    public static final int TRADECOUNT = 12;
    protected static final BooleanProperty ISBOTTOM = BlockStateProperties.field_222513_b;
    protected static final BooleanProperty ISLEFT = BlockStateProperties.field_208174_a;

    public VendingMachineLargeBlock(AbstractBlock.Properties properties) {
        super(properties, null);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)ISLEFT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext contect) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        Vector3f offset = new Vector3f(0.0f, 0.0f, 0.0f);
        VoxelShape shape = this.makeShape(direction);
        if (((Boolean)state.func_177229_b((Property)ISBOTTOM)).booleanValue()) {
            if (!((Boolean)state.func_177229_b((Property)ISLEFT)).booleanValue()) {
                offset = this.getLeftOffset(direction);
            }
        } else {
            offset = (Boolean)state.func_177229_b((Property)ISLEFT) != false ? new Vector3f(0.0f, -1.0f, 0.0f) : MathUtil.VectorAdd(this.getLeftOffset(direction), new Vector3f(0.0f, -1.0f, 0.0f));
        }
        return shape.func_197751_a((double)offset.func_195899_a(), (double)offset.func_195900_b(), (double)offset.func_195902_c());
    }

    private VoxelShape makeShape(Direction direction) {
        if (direction == Direction.NORTH) {
            return VendingMachineLargeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)32.0, (double)32.0, (double)16.0);
        }
        if (direction == Direction.SOUTH) {
            return VendingMachineLargeBlock.func_208617_a((double)-16.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
        }
        if (direction == Direction.EAST) {
            return VendingMachineLargeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)32.0);
        }
        if (direction == Direction.WEST) {
            return VendingMachineLargeBlock.func_208617_a((double)0.0, (double)0.0, (double)-16.0, (double)16.0, (double)32.0, (double)16.0);
        }
        return VendingMachineLargeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ISBOTTOM});
        builder.func_206894_a(new Property[]{ISLEFT});
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)ISLEFT, (Comparable)Boolean.valueOf(true));
    }

    public boolean func_196260_a(BlockState state, IWorldReader reader, BlockPos pos) {
        return reader.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        ItemTraderTileEntity tileEntity = (ItemTraderTileEntity)this.getTileEntity(state, (IWorld)worldIn, pos);
        if (tileEntity != null) {
            if (!tileEntity.canBreak(player)) {
                return;
            }
            tileEntity.dumpContents(worldIn, pos);
        }
        if (((Boolean)state.func_177229_b((Property)ISBOTTOM)).booleanValue()) {
            this.setAir(worldIn, pos.func_177984_a(), player);
            BlockPos otherPos = pos;
            otherPos = (Boolean)state.func_177229_b((Property)ISLEFT) != false ? this.getRightPos(state, pos) : this.getLeftPos(state, pos);
            this.setAir(worldIn, otherPos, player);
            this.setAir(worldIn, otherPos.func_177984_a(), player);
        } else {
            this.setAir(worldIn, pos.func_177977_b(), player);
            BlockPos otherPos = pos;
            otherPos = (Boolean)state.func_177229_b((Property)ISLEFT) != false ? this.getRightPos(state, pos) : this.getLeftPos(state, pos);
            this.setAir(worldIn, otherPos, player);
            this.setAir(worldIn, otherPos.func_177977_b(), player);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    private void setAir(World world, BlockPos pos, PlayerEntity player) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof VendingMachineLargeBlock) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_217378_a(player, 2001, pos, Block.func_196246_j((BlockState)state));
        }
    }

    private BlockPos getLeftPos(BlockState state, BlockPos pos) {
        if (state.func_177229_b((Property)FACING) == Direction.NORTH) {
            return new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
        }
        if (state.func_177229_b((Property)FACING) == Direction.SOUTH) {
            return new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
        }
        if (state.func_177229_b((Property)FACING) == Direction.EAST) {
            return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
        }
        if (state.func_177229_b((Property)FACING) == Direction.WEST) {
            return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
        }
        return pos;
    }

    private BlockPos getRightPos(BlockState state, BlockPos pos) {
        if (state.func_177229_b((Property)FACING) == Direction.NORTH) {
            return new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
        }
        if (state.func_177229_b((Property)FACING) == Direction.SOUTH) {
            return new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
        }
        if (state.func_177229_b((Property)FACING) == Direction.EAST) {
            return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
        }
        if (state.func_177229_b((Property)FACING) == Direction.WEST) {
            return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
        }
        return pos;
    }

    private Vector3f getLeftOffset(Direction direction) {
        if (direction == Direction.NORTH) {
            return new Vector3f(-1.0f, 0.0f, 0.0f);
        }
        if (direction == Direction.SOUTH) {
            return new Vector3f(1.0f, 0.0f, 0.0f);
        }
        if (direction == Direction.EAST) {
            return new Vector3f(0.0f, 0.0f, -1.0f);
        }
        if (direction == Direction.WEST) {
            return new Vector3f(0.0f, 0.0f, 1.0f);
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        ItemTraderTileEntity tileEntity;
        PlayerEntity playerEntity = (PlayerEntity)player;
        ItemStack giveStack = stack.func_77946_l();
        giveStack.func_190920_e(1);
        BlockPos rightPos = this.getRightPos(state, pos);
        if (worldIn.func_180495_p(rightPos).func_177230_c() != Blocks.field_150350_a || worldIn.func_180495_p(rightPos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) {
            LightmansCurrency.LogInfo("Failed placing the lower-right block. Aborting placement.");
            if (!playerEntity.func_184812_l_()) {
                playerEntity.field_71071_by.func_70441_a(giveStack);
            }
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 35);
            return;
        }
        worldIn.func_175656_a(rightPos, (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING))).func_206870_a((Property)ISLEFT, (Comparable)Boolean.valueOf(false)));
        worldIn.func_175656_a(rightPos.func_177984_a(), (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)ISBOTTOM, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING))).func_206870_a((Property)ISLEFT, (Comparable)Boolean.valueOf(false)));
        worldIn.func_175656_a(pos.func_177984_a(), (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)ISBOTTOM, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING))).func_206870_a((Property)ISLEFT, (Comparable)Boolean.valueOf(true)));
        if (!worldIn.func_201670_d() && (tileEntity = (ItemTraderTileEntity)worldIn.func_175625_s(pos)) != null) {
            tileEntity.initOwner(PlayerReference.of((Entity)player));
            if (stack.func_82837_s()) {
                tileEntity.getCoreSettings().setCustomName(null, stack.func_200301_q().getString());
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        TileEntity tileEntity;
        if (!world.func_201670_d() && (tileEntity = this.getTileEntity(state, (IWorld)world, pos)) instanceof ItemTraderTileEntity) {
            ItemTraderTileEntity trader = (ItemTraderTileEntity)tileEntity;
            trader.getCoreSettings().updateNames(playerEntity);
            TileEntityUtil.sendUpdatePacket(tileEntity);
            trader.openTradeMenu((PlayerEntity)((ServerPlayerEntity)playerEntity));
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public TileEntity getTileEntity(BlockState state, IWorld world, BlockPos pos) {
        BlockPos getPos = pos;
        if (!((Boolean)state.func_177229_b((Property)ISLEFT)).booleanValue()) {
            getPos = this.getLeftPos(state, pos);
        }
        if (((Boolean)state.func_177229_b((Property)ISBOTTOM)).booleanValue()) {
            return world.func_175625_s(getPos);
        }
        return world.func_175625_s(getPos.func_177977_b());
    }

    @Override
    public ItemInterfaceTileEntity.IItemHandlerTileEntity getItemHandlerEntity(BlockState state, World world, BlockPos pos) {
        TileEntity trader = this.getTileEntity(state, (IWorld)world, pos);
        if (trader instanceof ItemInterfaceTileEntity.IItemHandlerTileEntity) {
            return (ItemInterfaceTileEntity.IItemHandlerTileEntity)trader;
        }
        return null;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (((Boolean)state.func_177229_b((Property)ISBOTTOM)).booleanValue() && ((Boolean)state.func_177229_b((Property)ISLEFT)).booleanValue()) {
            return new ItemTraderTileEntity(12);
        }
        return new ItemInterfaceTileEntity();
    }

    @Override
    public List<Vector3f> GetStackRenderPos(int tradeSlot, BlockState state, boolean isBlock) {
        Vector3f vertOffset;
        Vector3f rightOffset;
        Direction facing = this.getFacing(state);
        Vector3f forward = this.getForwardVect(facing);
        Vector3f right = this.getRightVect(facing);
        Vector3f up = Vector3f.field_229181_d_;
        Vector3f offset = this.getOffsetVect(facing);
        Vector3f forwardOffset = MathUtil.VectorMult(forward, 0.375f);
        Vector3f firstPosition = null;
        if (tradeSlot == 0) {
            rightOffset = MathUtil.VectorMult(right, 0.21875f);
            vertOffset = MathUtil.VectorMult(up, 1.6875f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 1) {
            rightOffset = MathUtil.VectorMult(right, 0.65625f);
            vertOffset = MathUtil.VectorMult(up, 1.6875f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 2) {
            rightOffset = MathUtil.VectorMult(right, 1.09375f);
            vertOffset = MathUtil.VectorMult(up, 1.6875f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 3) {
            rightOffset = MathUtil.VectorMult(right, 1.53125f);
            vertOffset = MathUtil.VectorMult(up, 1.6875f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 4) {
            rightOffset = MathUtil.VectorMult(right, 0.21875f);
            vertOffset = MathUtil.VectorMult(up, 1.25f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 5) {
            rightOffset = MathUtil.VectorMult(right, 0.65625f);
            vertOffset = MathUtil.VectorMult(up, 1.25f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 6) {
            rightOffset = MathUtil.VectorMult(right, 1.09375f);
            vertOffset = MathUtil.VectorMult(up, 1.25f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 7) {
            rightOffset = MathUtil.VectorMult(right, 1.53125f);
            vertOffset = MathUtil.VectorMult(up, 1.25f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 8) {
            rightOffset = MathUtil.VectorMult(right, 0.21875f);
            vertOffset = MathUtil.VectorMult(up, 0.8125f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 9) {
            rightOffset = MathUtil.VectorMult(right, 0.65625f);
            vertOffset = MathUtil.VectorMult(up, 0.8125f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 10) {
            rightOffset = MathUtil.VectorMult(right, 1.09375f);
            vertOffset = MathUtil.VectorMult(up, 0.8125f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 11) {
            rightOffset = MathUtil.VectorMult(right, 1.53125f);
            vertOffset = MathUtil.VectorMult(up, 0.8125f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        }
        ArrayList<Vector3f> posList = new ArrayList<Vector3f>(3);
        if (firstPosition != null) {
            float distance;
            posList.add(firstPosition);
            float f = distance = isBlock ? 3.2f : 0.5f;
            while (distance < 7.0f) {
                posList.add(MathUtil.VectorAdd(firstPosition, MathUtil.VectorMult(forward, distance / 16.0f)));
                distance += isBlock ? 3.2f : 0.5f;
            }
        } else {
            posList.add(new Vector3f(0.0f, 1.0f, 0.0f));
        }
        return posList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Quaternion> GetStackRenderRot(int tradeSlot, BlockState state, boolean isBlock) {
        ArrayList<Quaternion> rotation = new ArrayList<Quaternion>();
        int facing = ((Direction)state.func_177229_b((Property)FACING)).func_176736_b();
        rotation.add(Vector3f.field_229181_d_.func_229187_a_((float)facing * -90.0f));
        return rotation;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vector3f GetStackRenderScale(int tradeSlot, BlockState state, boolean isBlock) {
        return new Vector3f(0.4f, 0.4f, 0.4f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int maxRenderIndex() {
        return 12;
    }
}

