/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientTradingOffice {
    private static Map<UUID, UniversalTraderData> loadedTraders = new HashMap<UUID, UniversalTraderData>();
    private static Map<UUID, Team> loadedTeams = new HashMap<UUID, Team>();
    private static Map<UUID, BankAccount> loadedBankAccounts = new HashMap<UUID, BankAccount>();

    public static List<UniversalTraderData> getTraderList() {
        return loadedTraders.values().stream().collect(Collectors.toList());
    }

    public static UniversalTraderData getData(UUID traderID) {
        if (loadedTraders.containsKey(traderID)) {
            return loadedTraders.get(traderID);
        }
        return null;
    }

    public static void clearData() {
        loadedTraders.clear();
    }

    public static void updateTrader(CompoundNBT compound) {
        UUID traderID = compound.func_186857_a("ID");
        if (loadedTraders.containsKey(traderID)) {
            loadedTraders.get(traderID).read(compound);
        } else {
            loadedTraders.put(traderID, TradingOffice.Deserialize(compound).flagAsClient());
        }
    }

    public static void removeTrader(UUID traderID) {
        if (loadedTraders.containsKey(traderID)) {
            loadedTraders.remove(traderID);
        }
    }

    public static List<Team> getTeamList() {
        return loadedTeams.values().stream().collect(Collectors.toList());
    }

    public static Team getTeam(UUID teamID) {
        if (loadedTeams.containsKey(teamID)) {
            return loadedTeams.get(teamID);
        }
        return null;
    }

    public static void initTeams(List<Team> teams) {
        loadedTeams.clear();
        teams.forEach(team -> loadedTeams.put(team.getID(), (Team)team));
    }

    public static void updateTeam(CompoundNBT compound) {
        Team updatedTeam = Team.load(compound);
        loadedTeams.put(updatedTeam.getID(), updatedTeam);
    }

    public static void removeTeam(UUID teamID) {
        if (loadedTeams.containsKey(teamID)) {
            loadedTeams.remove(teamID);
        }
    }

    public static BankAccount getPlayerBankAccount(PlayerEntity player) {
        return ClientTradingOffice.getPlayerBankAccount(player.func_110124_au());
    }

    public static BankAccount getPlayerBankAccount(UUID playerID) {
        if (loadedBankAccounts.containsKey(playerID)) {
            return loadedBankAccounts.get(playerID);
        }
        LightmansCurrency.LogWarning("No bank account for player with id " + playerID.toString() + " is present on the client.");
        return new BankAccount();
    }

    public static void initBankAccounts(Map<UUID, BankAccount> bankAccounts) {
        loadedBankAccounts.clear();
        bankAccounts.forEach((id, account) -> loadedBankAccounts.put((UUID)id, (BankAccount)account));
    }

    public static void updateBankAccount(CompoundNBT compound) {
        try {
            UUID owner = compound.func_186857_a("Player");
            BankAccount account = new BankAccount(compound);
            loadedBankAccounts.put(owner, account);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

