/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamBankAccountTab;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamMemberEditTab;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamMemberListTab;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamNameTab;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamOwnerTab;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamSelectionTab;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TabButton;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TeamManagerScreen
extends Screen {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/teammanager.png");
    public final int xSize = 200;
    public final int ySize = 200;
    private UUID activeTeamID = null;
    List<Widget> tabWidgets = Lists.newArrayList();
    List<IGuiEventListener> tabListeners = Lists.newArrayList();
    List<TeamTab> tabs = Lists.newArrayList((Object[])new TeamTab[]{TeamSelectionTab.INSTANCE, TeamMemberListTab.INSTANCE, TeamNameTab.INSTANCE, TeamMemberEditTab.INSTANCE, TeamBankAccountTab.INSTANCE, TeamOwnerTab.INSTANCE});
    List<TabButton> tabButtons = Lists.newArrayList();
    int currentTabIndex = 0;

    public TeamManagerScreen() {
        super((ITextComponent)new StringTextComponent(""));
        this.tabs.forEach(tab -> tab.setScreen(this));
    }

    public PlayerEntity getPlayer() {
        return this.field_230706_i_.field_71439_g;
    }

    public FontRenderer getFont() {
        return this.field_230712_o_;
    }

    public final int guiLeft() {
        ((Object)((Object)this)).getClass();
        return (this.field_230708_k_ - 200) / 2;
    }

    public final int guiTop() {
        ((Object)((Object)this)).getClass();
        return (this.field_230709_l_ - 200) / 2;
    }

    public Team getActiveTeam() {
        if (this.activeTeamID == null) {
            return null;
        }
        Team team = ClientTradingOffice.getTeam(this.activeTeamID);
        if (team != null && team.isMember(this.getPlayer())) {
            return team;
        }
        return null;
    }

    public void setActiveTeam(UUID teamID) {
        this.activeTeamID = teamID;
    }

    public TeamTab currentTab() {
        return this.tabs.get(MathUtil.clamp(this.currentTabIndex, 0, this.tabs.size() - 1));
    }

    public void func_231160_c_() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabButton button = (TabButton)this.func_230480_a_((Widget)new TabButton(this::clickedOnTab, this.field_230712_o_, this.tabs.get(i)));
            button.field_230693_o_ = i != this.currentTabIndex;
            button.field_230694_p_ = this.tabs.get(i).allowViewing(this.getPlayer(), this.getActiveTeam());
            this.tabButtons.add(button);
        }
        this.positionTabButtons();
        this.currentTab().initTab();
    }

    private int getTabPosX(int index) {
        if (index < 8) {
            return this.guiLeft() + 25 * index;
        }
        if (index < 16) {
            int n = this.guiLeft();
            ((Object)((Object)this)).getClass();
            return n + 200;
        }
        if (index < 24) {
            int n = this.guiLeft();
            ((Object)((Object)this)).getClass();
            return n + 200 - 25 * (index - 15);
        }
        return this.guiLeft() - 25;
    }

    private int getTabPosY(int index) {
        if (index < 8) {
            return this.guiTop() - 25;
        }
        if (index < 16) {
            return this.guiTop() + 25 * (index - 10);
        }
        if (index < 24) {
            int n = this.guiTop();
            ((Object)((Object)this)).getClass();
            return n + 200;
        }
        int n = this.guiTop();
        ((Object)((Object)this)).getClass();
        return n + 200 - 25 * (index - 23);
    }

    private int getTabRotation(int index) {
        if (index < 8) {
            return 0;
        }
        if (index < 16) {
            return 1;
        }
        if (index < 24) {
            return 2;
        }
        return 3;
    }

    private void positionTabButtons() {
        int index = 0;
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            TabButton thisButton = this.tabButtons.get(i);
            if (!thisButton.field_230694_p_) continue;
            thisButton.reposition(this.getTabPosX(index), this.getTabPosY(index), this.getTabRotation(index));
            ++index;
        }
    }

    public void func_230430_a_(MatrixStack pose, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(pose);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int n = this.guiLeft();
        int n2 = this.guiTop();
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.func_238474_b_(pose, n, n2, 0, 0, 200, 200);
        super.func_230430_a_(pose, mouseX, mouseY, partialTicks);
        try {
            this.currentTab().preRender(pose, mouseX, mouseY, partialTicks);
            this.tabWidgets.forEach(widget -> widget.func_230430_a_(pose, mouseX, mouseY, partialTicks));
            this.currentTab().postRender(pose, mouseX, mouseY, partialTicks);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            if (!this.tabButtons.get(i).func_231047_b_(mouseX, mouseY)) continue;
            this.func_238652_a_(pose, this.tabButtons.get((int)i).tab.getTooltip(), mouseX, mouseY);
        }
    }

    public void func_231023_e_() {
        if (this.activeTeamID == null && this.currentTabIndex != 0) {
            this.changeTab(0);
        }
        boolean updateTabs = false;
        for (int i = 0; i < this.tabs.size(); ++i) {
            boolean visible = this.tabs.get(i).allowViewing(this.getPlayer(), this.getActiveTeam());
            if (visible == this.tabButtons.get((int)i).field_230694_p_) continue;
            updateTabs = true;
            this.tabButtons.get((int)i).field_230694_p_ = visible;
        }
        if (updateTabs) {
            this.positionTabButtons();
        }
        if (!this.currentTab().allowViewing(this.getPlayer(), this.getActiveTeam()) && this.currentTabIndex != 0) {
            this.changeTab(0);
        }
        this.currentTab().tick();
    }

    public <T extends Widget> T addRenderableTabWidget(T widget) {
        this.tabWidgets.add(widget);
        return widget;
    }

    public void removeRenderableTabWidget(Widget widget) {
        if (this.tabWidgets.contains(widget)) {
            this.tabWidgets.remove(widget);
        }
    }

    public <T extends IGuiEventListener> T addTabListener(T listener) {
        this.tabListeners.add(listener);
        return listener;
    }

    public void removeTabListener(IGuiEventListener listener) {
        if (this.tabListeners.contains(listener)) {
            this.tabListeners.remove(listener);
        }
    }

    public void changeTab(int tabIndex) {
        if (!this.tabs.get(tabIndex).allowViewing(this.getPlayer(), this.getActiveTeam())) {
            return;
        }
        this.currentTab().closeTab();
        this.tabButtons.get((int)this.currentTabIndex).field_230693_o_ = true;
        this.currentTabIndex = tabIndex;
        this.tabButtons.get((int)this.currentTabIndex).field_230693_o_ = false;
        this.tabWidgets.clear();
        this.tabListeners.clear();
        this.currentTab().initTab();
    }

    private void clickedOnTab(Button tab) {
        int tabIndex = this.tabButtons.indexOf(tab);
        if (tabIndex < 0) {
            return;
        }
        this.changeTab(tabIndex);
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        List coreListeners = super.func_231039_at__();
        ArrayList listeners = Lists.newArrayList();
        for (int i = 0; i < coreListeners.size(); ++i) {
            listeners.add(coreListeners.get(i));
        }
        listeners.addAll(this.tabWidgets);
        listeners.addAll(this.tabListeners);
        return listeners;
    }

    public boolean func_231177_au__() {
        return false;
    }
}

