/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.ITradeRuleScreenHandler;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TradeItemPriceScreen
extends Screen
implements CoinValueInput.ICoinValueInput {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/tradeprice.png");
    private int xSize = 176;
    private int ySize = 157;
    PlayerEntity player;
    Supplier<IItemTrader> traderSource;
    ItemTradeData trade;
    int tradeIndex;
    Button buttonSetSell;
    Button buttonSetPurchase;
    Button buttonSetBarter;
    Button buttonTradeRules;
    ItemTradeData.ItemTradeType localDirection;
    CoinValueInput priceInput;
    TextFieldWidget nameField;

    public IItemTrader getTrader() {
        return this.traderSource.get();
    }

    public TradeItemPriceScreen(Supplier<IItemTrader> traderSource, int tradeIndex, PlayerEntity player) {
        super((ITextComponent)new TranslationTextComponent("gui.lightmanscurrency.changeprice"));
        this.traderSource = traderSource;
        this.tradeIndex = tradeIndex;
        this.trade = (ItemTradeData)this.getTrader().getTrade(this.tradeIndex);
        this.player = player;
        this.localDirection = this.trade.getTradeType();
    }

    protected void func_231160_c_() {
        int guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        int guiTop = (this.field_230709_l_ - this.ySize) / 2;
        this.priceInput = new CoinValueInput(guiTop, this.field_230704_d_, this.trade.getCost(), this);
        this.field_230705_e_.add(this.priceInput);
        this.nameField = new TextFieldWidget(this.field_230712_o_, guiLeft + 8, guiTop + 69 + 38, 160, 18, ITextComponent.func_244388_a((String)""));
        this.nameField.func_146180_a(this.trade.getCustomName());
        this.nameField.func_146203_f(30);
        this.field_230705_e_.add(this.nameField);
        this.buttonSetSell = (Button)this.func_230480_a_((Widget)new Button(guiLeft + 7, guiTop + 69 + 6, 50, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.tradedirection.sale"), this::SetTradeDirection));
        this.buttonSetPurchase = (Button)this.func_230480_a_((Widget)new Button(guiLeft + 63, guiTop + 69 + 6, 51, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.tradedirection.purchase"), this::SetTradeDirection));
        this.buttonSetBarter = (Button)this.func_230480_a_((Widget)new Button(guiLeft + 120, guiTop + 69 + 6, 50, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.tradedirection.barter"), this::SetTradeDirection));
        this.func_230480_a_((Widget)new Button(guiLeft + 7, guiTop + 69 + 62, 50, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.save"), this::PressSaveButton));
        this.func_230480_a_((Widget)new Button(guiLeft + 120, guiTop + 69 + 62, 50, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.back"), this::PressBackButton));
        this.buttonTradeRules = (Button)this.func_230480_a_((Widget)IconAndButtonUtil.tradeRuleButton(guiLeft + this.xSize, guiTop + 69, this::PressTradeRuleButton));
        this.buttonTradeRules.field_230694_p_ = this.getTrader().hasPermission(this.player, "editTradeRules");
        this.func_231023_e_();
    }

    public void func_231023_e_() {
        if (this.getTrader() == null) {
            this.player.func_71053_j();
            return;
        }
        this.buttonSetSell.field_230693_o_ = this.localDirection != ItemTradeData.ItemTradeType.SALE;
        this.buttonSetPurchase.field_230693_o_ = this.localDirection != ItemTradeData.ItemTradeType.PURCHASE;
        this.buttonSetBarter.field_230693_o_ = this.localDirection != ItemTradeData.ItemTradeType.BARTER;
        this.buttonTradeRules.field_230694_p_ = this.getTrader().hasPermission(this.player, "editTradeRules");
        this.priceInput.field_230694_p_ = this.localDirection != ItemTradeData.ItemTradeType.BARTER;
        super.func_231023_e_();
        this.priceInput.tick();
        this.nameField.func_146178_a();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        int startX = (this.field_230708_k_ - this.xSize) / 2;
        int startY = (this.field_230709_l_ - this.ySize) / 2;
        this.func_238474_b_(matrixStack, startX, startY + 69, 0, 0, this.xSize, this.ySize - 69);
        this.priceInput.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.field_230712_o_.func_238421_b_(matrixStack, new TranslationTextComponent("gui.lightmanscurrency.customname").getString(), (float)startX + 8.0f, (float)(startY + 69) + 28.0f, 0x404040);
        this.nameField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.buttonTradeRules.func_231047_b_((double)mouseX, (double)mouseY)) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.trader.traderules"), mouseX, mouseY);
        }
    }

    protected void PressSaveButton(Button button) {
        this.SaveChanges();
        this.PressBackButton(button);
    }

    protected void SaveChanges() {
        this.getTrader().sendSetTradePriceMessage(this.tradeIndex, this.priceInput.getCoinValue(), this.nameField.func_146179_b(), this.localDirection);
    }

    protected void PressBackButton(Button button) {
        this.getTrader().sendOpenStorageMessage();
    }

    protected void SetTradeDirection(Button button) {
        if (button == this.buttonSetSell) {
            this.localDirection = ItemTradeData.ItemTradeType.SALE;
        } else if (button == this.buttonSetPurchase) {
            this.localDirection = ItemTradeData.ItemTradeType.PURCHASE;
        } else if (button == this.buttonSetBarter) {
            this.localDirection = ItemTradeData.ItemTradeType.BARTER;
        } else {
            LightmansCurrency.LogWarning("Invalid button triggered SetTradeDirection");
        }
    }

    protected void PressTradeRuleButton(Button button) {
        Minecraft.func_71410_x().func_147108_a((Screen)new TradeRuleScreen(this.getRuleScreenHandler()));
    }

    public ITradeRuleScreenHandler getRuleScreenHandler() {
        return new CloseRuleHandler(this.traderSource, this.tradeIndex, this.player);
    }

    @Override
    public <T extends Button> T addCustomButton(T button) {
        return (T)((Button)super.func_230480_a_(button));
    }

    @Override
    public <T extends IGuiEventListener> T addCustomListener(T listener) {
        return (T)super.func_230481_d_(listener);
    }

    @Override
    public int getWidth() {
        return this.field_230708_k_;
    }

    @Override
    public void OnCoinValueChanged(CoinValueInput input) {
    }

    @Override
    public FontRenderer getFont() {
        return this.field_230712_o_;
    }

    private static class CloseRuleHandler
    implements ITradeRuleScreenHandler {
        final Supplier<IItemTrader> traderSource;
        final int tradeIndex;
        final PlayerEntity player;

        private IItemTrader getTrader() {
            return this.traderSource.get();
        }

        public CloseRuleHandler(Supplier<IItemTrader> traderSource, int tradeIndex, PlayerEntity player) {
            this.traderSource = traderSource;
            this.tradeIndex = tradeIndex;
            this.player = player;
        }

        @Override
        public ITradeRuleHandler ruleHandler() {
            return this.getTrader().getTrade(this.tradeIndex);
        }

        @Override
        public void reopenLastScreen() {
            Minecraft.func_71410_x().func_147108_a((Screen)new TradeItemPriceScreen(this.traderSource, this.tradeIndex, this.player));
        }

        @Override
        public void updateServer(ResourceLocation type, CompoundNBT updateInfo) {
            this.getTrader().sendTradeRuleUpdateMessage(this.tradeIndex, type, updateInfo);
        }

        @Override
        public boolean stillValid() {
            return this.getTrader() != null;
        }
    }
}

