/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.ITradeRuleScreenHandler;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeRule;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TradeRuleScreen
extends Screen {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/traderules.png");
    private static final List<Supplier<TradeRule>> REGISTERED_RULES = new ArrayList<Supplier<TradeRule>>();
    public final int xSize = 176;
    public final int ySize = 176;
    final ITradeRuleScreenHandler handler;
    int openTab = -1;
    Button managerTab;
    List<Button> tabButtons = new ArrayList<Button>();
    List<Button> removeRuleButtons = new ArrayList<Button>();
    List<Button> addRuleButtons = new ArrayList<Button>();
    TradeRule.GUIHandler currentGUIHandler = null;

    public static void RegisterTradeRule(Supplier<TradeRule> rule) {
        REGISTERED_RULES.forEach(registeredRule -> {
            if (((TradeRule)registeredRule.get()).type == ((TradeRule)rule.get()).type) {
                return;
            }
        });
        REGISTERED_RULES.add(rule);
    }

    public final int guiLeft() {
        ((Object)((Object)this)).getClass();
        return (this.field_230708_k_ - 176) / 2;
    }

    public final int guiTop() {
        ((Object)((Object)this)).getClass();
        return (this.field_230709_l_ - 176) / 2;
    }

    List<TradeRule> activeRules() {
        return this.handler.ruleHandler().getRules();
    }

    TradeRule currentRule() {
        if (this.openTab >= 0 && this.openTab < this.activeRules().size()) {
            return this.activeRules().get(this.openTab);
        }
        return null;
    }

    List<TradeRule> addableRules() {
        ArrayList<TradeRule> addableRules = new ArrayList<TradeRule>();
        REGISTERED_RULES.forEach(rule -> addableRules.add((TradeRule)rule.get()));
        this.activeRules().forEach(rule -> {
            for (int i = 0; i < addableRules.size(); ++i) {
                if (((TradeRule)addableRules.get((int)i)).type != rule.type) continue;
                addableRules.remove(i);
            }
        });
        return addableRules;
    }

    public TradeRuleScreen(ITradeRuleScreenHandler handler) {
        super((ITextComponent)new StringTextComponent(""));
        this.handler = handler;
    }

    public void func_231160_c_() {
        int n = this.guiLeft();
        ((Object)((Object)this)).getClass();
        this.func_230480_a_((Widget)new IconButton(n + 176, this.guiTop(), this::PressBackButton, IconAndButtonUtil.ICON_BACK));
        this.managerTab = (Button)this.func_230480_a_((Widget)new IconButton(this.guiLeft(), this.guiTop() - 20, this::PressTabButton, IconAndButtonUtil.ICON_TRADE_RULES));
        this.refreshTabs();
        this.initManagerTab();
    }

    private void initManagerTab() {
        int i;
        int y = 0;
        this.removeRuleButtons.clear();
        for (i = 0; i < this.activeRules().size(); ++i) {
            this.removeRuleButtons.add((Button)this.func_230480_a_((Widget)new IconButton(this.guiLeft() + 10, this.guiTop() + 10 + 20 * y, this::PressRemoveRuleButton, IconAndButtonUtil.ICON_X)));
            ++y;
        }
        this.addRuleButtons.clear();
        for (i = 0; i < this.addableRules().size(); ++i) {
            this.addRuleButtons.add((Button)this.func_230480_a_((Widget)new IconButton(this.guiLeft() + 10, this.guiTop() + 10 + 20 * y, this::PressAddRuleButton, IconAndButtonUtil.ICON_PLUS)));
            ++y;
        }
    }

    private void closeManagerTab() {
        this.addRuleButtons.forEach(button -> this.removeButton((Button)button));
        this.addRuleButtons.clear();
        this.removeRuleButtons.forEach(button -> this.removeButton((Button)button));
        this.removeRuleButtons.clear();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        int n = this.guiLeft();
        int n2 = this.guiTop();
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.func_238474_b_(matrixStack, n, n2, 0, 0, 176, 176);
        if (this.currentGUIHandler != null) {
            this.currentGUIHandler.renderTab(matrixStack, mouseX, mouseY, partialTicks);
        } else {
            if (this.openTab >= 0) {
                this.openTab = -1;
            }
            int y = 0;
            for (i = 0; i < this.activeRules().size(); ++i) {
                this.field_230712_o_.func_238421_b_(matrixStack, this.activeRules().get(i).getName().getString(), (float)(this.guiLeft() + 34), (float)(this.guiTop() + 16 + y * 20), 0xFFFFFF);
                ++y;
            }
            for (i = 0; i < this.addableRules().size(); ++i) {
                this.field_230712_o_.func_238421_b_(matrixStack, this.addableRules().get(i).getName().getString(), (float)(this.guiLeft() + 34), (float)(this.guiTop() + 16 + y * 20), 0xFFFFFF);
                ++y;
            }
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.managerTab.func_231047_b_((double)mouseX, (double)mouseY)) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.mananger"), mouseX, mouseY);
        } else {
            boolean hoverButton = true;
            for (i = 0; i < this.tabButtons.size() && i < this.activeRules().size() && hoverButton; ++i) {
                Button thisTab = this.tabButtons.get(i);
                if (!thisTab.func_231047_b_((double)mouseX, (double)mouseY)) continue;
                this.func_238652_a_(matrixStack, this.activeRules().get(i).getName(), mouseX, mouseY);
                hoverButton = false;
            }
            for (i = 0; i < this.removeRuleButtons.size() && i < this.activeRules().size() && hoverButton; ++i) {
                if (!this.removeRuleButtons.get(i).func_231047_b_((double)mouseX, (double)mouseY)) continue;
                this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.removerule", new Object[]{this.activeRules().get(i).getName()}), mouseX, mouseY);
                hoverButton = false;
            }
            for (i = 0; i < this.addRuleButtons.size() && i < this.addableRules().size() && hoverButton; ++i) {
                if (!this.addRuleButtons.get(i).func_231047_b_((double)mouseX, (double)mouseY)) continue;
                this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.addrule", new Object[]{this.addableRules().get(i).getName()}), mouseX, mouseY);
                hoverButton = false;
            }
        }
    }

    public void func_231023_e_() {
        if (!this.handler.stillValid()) {
            this.field_230706_i_.func_147108_a(null);
            return;
        }
        if (this.currentGUIHandler != null) {
            this.currentGUIHandler.onScreenTick();
        }
    }

    void PressBackButton(Button button) {
        this.handler.reopenLastScreen();
    }

    void PressTabButton(Button button) {
        if (this.tabButtons.contains(button)) {
            if (this.openTab == this.tabButtons.indexOf(button)) {
                return;
            }
            if (this.currentGUIHandler != null) {
                this.currentGUIHandler.onTabClose();
                this.currentGUIHandler = null;
            } else {
                this.closeManagerTab();
            }
            this.openTab = this.tabButtons.indexOf(button);
            if (this.currentRule() != null) {
                this.currentGUIHandler = this.currentRule().createHandler(this, (Supplier<TradeRule>)((Supplier)() -> this.currentRule()));
                this.currentGUIHandler.initTab();
            }
        } else if (button == this.managerTab) {
            if (this.openTab < 0) {
                return;
            }
            if (this.currentGUIHandler != null) {
                this.currentGUIHandler.onTabClose();
                this.currentGUIHandler = null;
            }
            this.openTab = -1;
            this.initManagerTab();
        }
    }

    void PressAddRuleButton(Button button) {
        int addIndex;
        if (this.addRuleButtons.contains(button) && (addIndex = this.addRuleButtons.indexOf(button)) >= 0 && addIndex < this.addableRules().size()) {
            TradeRule newRule = this.addableRules().get(addIndex);
            this.handler.ruleHandler().getRules().add(newRule);
            LightmansCurrency.LogInfo("Adding rule type " + newRule.getName().getString());
            this.handler.updateServer(newRule.type, TradeRule.CreateRuleMessage());
            this.closeManagerTab();
            this.refreshTabs();
            this.initManagerTab();
        }
    }

    void PressRemoveRuleButton(Button button) {
        int removeIndex;
        if (this.removeRuleButtons.contains(button) && (removeIndex = this.removeRuleButtons.indexOf(button)) >= 0 && removeIndex < this.activeRules().size()) {
            TradeRule removedRule = this.activeRules().get(removeIndex);
            this.handler.ruleHandler().getRules().remove(removedRule);
            this.handler.updateServer(removedRule.type, TradeRule.RemoveRuleMessage());
            LightmansCurrency.LogInfo("Removing rule type " + removedRule.getName().getString());
            this.closeManagerTab();
            this.refreshTabs();
            this.initManagerTab();
        }
    }

    public void updateServer(ResourceLocation type, CompoundNBT updateInfo) {
        this.handler.updateServer(type, updateInfo);
    }

    public void refreshTabs() {
        this.tabButtons.forEach(button -> this.removeButton((Button)button));
        this.tabButtons.clear();
        List<TradeRule> activeRules = this.activeRules();
        for (int i = 0; i < activeRules.size(); ++i) {
            TradeRule thisRule = activeRules.get(i);
            this.tabButtons.add((Button)this.func_230480_a_((Widget)new IconButton(this.guiLeft() + 20 + 20 * i, this.guiTop() - 20, this::PressTabButton, thisRule.getButtonIcon())));
        }
    }

    public FontRenderer getFont() {
        return this.field_230712_o_;
    }

    public <T extends Button> T addCustomButton(T button) {
        if (button != null) {
            this.func_230480_a_((Widget)button);
        }
        return button;
    }

    public <T extends IGuiEventListener> T addCustomListener(T listener) {
        if (listener != null) {
            this.func_230481_d_(listener);
        }
        return listener;
    }

    public void removeButton(Button button) {
        if (this.field_230710_m_.contains(button)) {
            this.field_230710_m_.remove(button);
        }
        if (this.field_230705_e_.contains(button)) {
            this.field_230705_e_.remove(button);
        }
    }

    public void removeListener(IGuiEventListener listener) {
        if (this.field_230705_e_.contains(listener)) {
            this.field_230705_e_.remove(listener);
        }
    }
}

