/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.client.gui.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TabButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TraderSettingsScreen
extends Screen {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/tradersettings.png");
    private final Supplier<ITrader> trader;
    private final Consumer<PlayerEntity> openStorage;
    public final int xSize = 200;
    public final int ySize = 200;
    List<Settings> settings;
    List<Widget> tabWidgets = Lists.newArrayList();
    List<IGuiEventListener> tabListeners = Lists.newArrayList();
    List<TabButton> tabButtons = Lists.newArrayList();
    List<SettingsTab> tabs;
    int currentTabIndex = 0;

    public PlayerEntity getPlayer() {
        return this.field_230706_i_.field_71439_g;
    }

    public ITrader getTrader() {
        return (ITrader)this.trader.get();
    }

    public FontRenderer getFont() {
        return this.field_230712_o_;
    }

    public final int guiLeft() {
        ((Object)((Object)this)).getClass();
        return (this.field_230708_k_ - 200) / 2;
    }

    public final int guiTop() {
        ((Object)((Object)this)).getClass();
        return (this.field_230709_l_ - 200) / 2;
    }

    public List<Settings> getSettings() {
        return this.settings;
    }

    public SettingsTab currentTab() {
        return this.tabs.get(MathUtil.clamp(this.currentTabIndex, 0, this.tabs.size() - 1));
    }

    public <T extends Settings> T getSetting(Class<T> type) {
        for (int i = 0; i < this.settings.size(); ++i) {
            if (this.settings.get(i).getClass() != type) continue;
            return (T)this.settings.get(i);
        }
        return null;
    }

    public TraderSettingsScreen(Supplier<ITrader> trader, Consumer<PlayerEntity> openStorage) {
        super((ITextComponent)new StringTextComponent(""));
        this.trader = trader;
        this.openStorage = openStorage;
        this.settings = Lists.newArrayList((Object[])new Settings[]{this.getTrader().getCoreSettings()});
        this.settings.addAll(this.getTrader().getAdditionalSettings());
        this.tabs = Lists.newArrayList();
        this.settings.forEach(setting -> this.tabs.addAll(setting.getSettingsTabs()));
        this.settings.forEach(setting -> this.tabs.addAll(setting.getBackEndSettingsTabs()));
        this.tabs.forEach(tab -> tab.setScreen(this));
    }

    public void func_231160_c_() {
        this.func_230480_a_((Widget)new IconButton(this.guiLeft(), this.guiTop() - 20, this::OpenStorage, IconAndButtonUtil.ICON_BACK));
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabButton button = (TabButton)this.func_230480_a_((Widget)new TabButton(this::clickedOnTab, this.field_230712_o_, this.tabs.get(i)));
            button.field_230693_o_ = i != this.currentTabIndex;
            button.field_230694_p_ = this.hasPermissions((List<String>)this.tabs.get(i).requiredPermissions());
            this.tabButtons.add(button);
        }
        this.positionTabButtons();
        this.currentTab().initTab();
    }

    private int getTabPosX(int index) {
        if (index < 7) {
            return this.guiLeft() + 20 + 25 * index;
        }
        if (index < 15) {
            int n = this.guiLeft();
            ((Object)((Object)this)).getClass();
            return n + 200;
        }
        if (index < 23) {
            int n = this.guiLeft();
            ((Object)((Object)this)).getClass();
            return n + 200 - 25 * (index - 15);
        }
        return this.guiLeft() - 25;
    }

    private int getTabPosY(int index) {
        if (index < 7) {
            return this.guiTop() - 25;
        }
        if (index < 15) {
            return this.guiTop() + 25 * (index - 10);
        }
        if (index < 23) {
            int n = this.guiTop();
            ((Object)((Object)this)).getClass();
            return n + 200;
        }
        int n = this.guiTop();
        ((Object)((Object)this)).getClass();
        return n + 200 - 25 * (index - 23);
    }

    private int getTabRotation(int index) {
        if (index < 7) {
            return 0;
        }
        if (index < 15) {
            return 1;
        }
        if (index < 23) {
            return 2;
        }
        return 3;
    }

    private void positionTabButtons() {
        int index = 0;
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            TabButton thisButton = this.tabButtons.get(i);
            if (!thisButton.field_230694_p_) continue;
            thisButton.reposition(this.getTabPosX(index), this.getTabPosY(index), this.getTabRotation(index));
            ++index;
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_TEXTURE);
        this.setColor(this.currentTab().getColor());
        int n = this.guiLeft();
        int n2 = this.guiTop();
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.func_238474_b_(matrix, n, n2, 0, 0, 200, 200);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.currentTab().preRender(matrix, mouseX, mouseY, partialTicks);
        this.tabWidgets.forEach(widget -> widget.func_230430_a_(matrix, mouseX, mouseY, partialTicks));
        this.currentTab().postRender(matrix, mouseX, mouseY, partialTicks);
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            if (!this.tabButtons.get(i).func_231047_b_(mouseX, mouseY)) continue;
            this.func_238652_a_(matrix, this.tabButtons.get((int)i).tab.getTooltip(), mouseX, mouseY);
        }
    }

    public void setColor(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color3f((float)r, (float)g, (float)b);
    }

    public void func_231023_e_() {
        if (this.getTrader() == null) {
            this.field_230706_i_.func_147108_a(null);
            return;
        }
        boolean updateTabs = false;
        for (int i = 0; i < this.tabs.size(); ++i) {
            boolean visible = this.hasPermissions((List<String>)this.tabs.get(i).requiredPermissions());
            if (visible == this.tabButtons.get((int)i).field_230694_p_) continue;
            updateTabs = true;
            this.tabButtons.get((int)i).field_230694_p_ = visible;
        }
        if (updateTabs) {
            this.positionTabButtons();
        }
        this.currentTab().tick();
    }

    public boolean hasPermission(String permission) {
        if (this.trader.get() != null) {
            return ((ITrader)this.trader.get()).getCoreSettings().hasPermission(this.getPlayer(), permission);
        }
        return false;
    }

    public int getPermissionLevel(String permission) {
        if (this.trader.get() != null) {
            return ((ITrader)this.trader.get()).getCoreSettings().getPermissionLevel(this.getPlayer(), permission);
        }
        return 0;
    }

    public boolean hasPermissions(List<String> permissions) {
        for (int i = 0; i < permissions.size(); ++i) {
            if (this.hasPermission(permissions.get(i))) continue;
            return false;
        }
        return true;
    }

    public <T extends Widget> T addRenderableTabWidget(T widget) {
        this.tabWidgets.add(widget);
        return widget;
    }

    public void removeRenderableTabWidget(Widget widget) {
        if (this.tabWidgets.contains(widget)) {
            this.tabWidgets.remove(widget);
        }
    }

    public <T extends IGuiEventListener> T addTabListener(T listener) {
        this.tabListeners.add(listener);
        return listener;
    }

    public void removeTabListener(IGuiEventListener listener) {
        if (this.tabListeners.contains(listener)) {
            this.tabListeners.remove(listener);
        }
    }

    private void clickedOnTab(Button tab) {
        int tabIndex = this.tabButtons.indexOf(tab);
        if (tabIndex < 0) {
            return;
        }
        if (tabIndex != this.currentTabIndex) {
            this.currentTab().closeTab();
            this.tabButtons.get((int)this.currentTabIndex).field_230693_o_ = true;
            this.currentTabIndex = tabIndex;
            this.tabButtons.get((int)this.currentTabIndex).field_230693_o_ = false;
            this.tabWidgets.clear();
            this.tabListeners.clear();
            this.currentTab().initTab();
        }
    }

    private void OpenStorage(Button button) {
        this.openStorage.accept(this.getPlayer());
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        List coreListeners = super.func_231039_at__();
        ArrayList listeners = Lists.newArrayList();
        for (int i = 0; i < coreListeners.size(); ++i) {
            listeners.add(coreListeners.get(i));
        }
        listeners.addAll(this.tabWidgets);
        listeners.addAll(this.tabListeners);
        return listeners;
    }

    public boolean func_231177_au__() {
        return false;
    }
}

