/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.UniversalTraderButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageOpenTrades2;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TradingTerminalScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/trader_selection.png");
    private static final Comparator<UniversalTraderData> TRADER_SORTER = new TraderSorter();
    private int xSize = 176;
    private int ySize = 187;
    private TextFieldWidget searchField;
    private static int page = 0;
    Button buttonNextPage;
    Button buttonPreviousPage;
    List<UniversalTraderButton> traderButtons;
    private List<UniversalTraderData> filteredTraderList = new ArrayList<UniversalTraderData>();

    private List<UniversalTraderData> traderList() {
        List<UniversalTraderData> traderList = ClientTradingOffice.getTraderList();
        traderList.sort(TRADER_SORTER);
        return traderList;
    }

    public TradingTerminalScreen() {
        super((ITextComponent)new TranslationTextComponent("block.lightmanscurrency.terminal"));
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        int guiTop = (this.field_230709_l_ - this.ySize) / 2;
        this.searchField = new TextFieldWidget(this.field_230712_o_, guiLeft + 28, guiTop + 6, 101, 9, (ITextComponent)new TranslationTextComponent("gui.lightmanscurrency.terminal.search"));
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(32);
        this.searchField.func_146193_g(0xFFFFFF);
        this.field_230705_e_.add(this.searchField);
        this.buttonPreviousPage = (Button)this.func_230480_a_((Widget)IconAndButtonUtil.leftButton(guiLeft - 6, guiTop + 18, this::PreviousPage));
        this.buttonNextPage = (Button)this.func_230480_a_((Widget)IconAndButtonUtil.rightButton(guiLeft + this.xSize - 14, guiTop + 18, this::NextPage));
        this.initTraderButtons(guiLeft, guiTop);
        page = MathUtil.clamp(page, 0, this.pageLimit());
        this.func_231023_e_();
        this.updateTraderList();
    }

    private void initTraderButtons(int guiLeft, int guiTop) {
        this.traderButtons = new ArrayList<UniversalTraderButton>();
        for (int y = 0; y < 5; ++y) {
            UniversalTraderButton newButton = (UniversalTraderButton)this.func_230480_a_((Widget)new UniversalTraderButton(guiLeft + 15, guiTop + 18 + y * 30, this::OpenTrader, this.field_230712_o_));
            this.traderButtons.add(newButton);
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.searchField.func_146178_a();
        if (this.buttonPreviousPage != null) {
            this.buttonPreviousPage.field_230694_p_ = this.pageLimit() > 0;
        }
        this.buttonPreviousPage.field_230693_o_ = page > 0;
        this.buttonNextPage.field_230694_p_ = this.pageLimit() > 0;
        this.buttonNextPage.field_230693_o_ = page < this.pageLimit();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        int startX = (this.field_230708_k_ - this.xSize) / 2;
        int startY = (this.field_230709_l_ - this.ySize) / 2;
        this.func_238474_b_(matrixStack, startX, startY, 0, 0, this.xSize, this.ySize);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.searchField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231042_a_(char c, int code) {
        String s = this.searchField.func_146179_b();
        if (this.searchField.func_231042_a_(c, code)) {
            if (!Objects.equals(s, this.searchField.func_146179_b())) {
                this.updateTraderList();
            }
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int key, int scanCode, int mods) {
        String s = this.searchField.func_146179_b();
        if (this.searchField.func_231046_a_(key, scanCode, mods)) {
            if (!Objects.equals(s, this.searchField.func_146179_b())) {
                this.updateTraderList();
            }
            return true;
        }
        return this.searchField.func_230999_j_() && this.searchField.func_146176_q() && key != 256 || super.func_231046_a_(key, scanCode, mods);
    }

    private void PreviousPage(Button button) {
        if (page > 0) {
            --page;
            this.updateTraderButtons();
        }
    }

    private void NextPage(Button button) {
        if (page < this.pageLimit()) {
            ++page;
            this.updateTraderButtons();
        }
    }

    private void OpenTrader(Button button) {
        int index = this.getTraderIndex(button);
        if (index >= 0 && index < this.filteredTraderList.size()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenTrades2(this.filteredTraderList.get(index).getTraderID()));
        }
    }

    private int getTraderIndex(Button button) {
        if (!this.traderButtons.contains(button)) {
            return -1;
        }
        int index = this.traderButtons.indexOf(button);
        return index += page * this.traderButtons();
    }

    private int pageLimit() {
        return (this.filteredTraderList.size() - 1) / this.traderButtons();
    }

    private int traderButtons() {
        return this.traderButtons.size();
    }

    private void updateTraderList() {
        this.filteredTraderList = TradingOffice.filterTraders(this.searchField.func_146179_b(), this.traderList());
        this.updateTraderButtons();
        if (page > this.pageLimit()) {
            page = this.pageLimit();
        }
    }

    private void updateTraderButtons() {
        int startIndex = page * this.traderButtons();
        for (int i = 0; i < this.traderButtons.size(); ++i) {
            if (startIndex + i < this.filteredTraderList.size()) {
                this.traderButtons.get(i).SetData(this.filteredTraderList.get(startIndex + i));
                continue;
            }
            this.traderButtons.get(i).SetData(null);
        }
    }

    private static class TraderSorter
    implements Comparator<UniversalTraderData> {
        private TraderSorter() {
        }

        @Override
        public int compare(UniversalTraderData a, UniversalTraderData b) {
            try {
                int sort = a.getName().getString().toLowerCase().compareTo(b.getName().getString().toLowerCase());
                if (sort == 0) {
                    sort = a.getCoreSettings().getOwner().lastKnownName().toLowerCase().compareTo(b.getCoreSettings().getOwner().lastKnownName().toLowerCase());
                }
                return sort;
            }
            catch (Throwable t) {
                return 0;
            }
        }
    }
}

