/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ConversionTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.InteractionTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.LogTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.SelectionTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.TransferTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TabButton;
import io.github.lightman314.lightmanscurrency.containers.ATMContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class ATMScreen
extends ContainerScreen<ATMContainer> {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/atm.png");
    int currentTabIndex = 0;
    List<ATMTab> tabs = Lists.newArrayList((Object[])new ATMTab[]{new ConversionTab(this), new SelectionTab(this), new InteractionTab(this), new LogTab(this), new TransferTab(this)});
    List<Widget> tabWidgets = Lists.newArrayList();
    List<IGuiEventListener> tabListeners = Lists.newArrayList();
    List<TabButton> tabButtons = Lists.newArrayList();
    boolean logError = true;

    public FontRenderer getFont() {
        return this.field_230712_o_;
    }

    public List<ATMTab> getTabs() {
        return this.tabs;
    }

    public ATMTab currentTab() {
        return this.tabs.get(this.currentTabIndex);
    }

    public ATMScreen(ATMContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        this.field_147000_g = 212;
        this.field_146999_f = 176;
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        block2: {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
            int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
            int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
            this.func_238474_b_(matrix, startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
            try {
                this.currentTab().preRender(matrix, mouseX, mouseY, partialTicks);
                this.tabWidgets.forEach(widget -> widget.func_230430_a_(matrix, mouseX, mouseY, partialTicks));
            }
            catch (Exception e) {
                if (!this.logError) break block2;
                LightmansCurrency.LogError("Error rendering " + this.currentTab().getClass().getName() + " tab.", e);
                this.logError = false;
            }
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrix, this.field_213127_e.func_145748_c_().getString(), 8.0f, (float)(this.field_147000_g - 94), 0x404040);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabButton button = (TabButton)this.func_230480_a_((Widget)new TabButton(this::clickedOnTab, this.field_230712_o_, this.tabs.get(i)));
            button.reposition(this.field_147003_i - 25, this.field_147009_r + i * 25, 3);
            button.field_230693_o_ = i != this.currentTabIndex;
            this.tabButtons.add(button);
        }
        this.currentTab().init();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        block3: {
            this.func_230446_a_(matrixStack);
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            try {
                this.currentTab().postRender(matrixStack, mouseX, mouseY);
            }
            catch (Exception e) {
                if (!this.logError) break block3;
                LightmansCurrency.LogError("Error rendering " + this.currentTab().getClass().getName() + " tab.", e);
                this.logError = false;
            }
        }
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            if (!this.tabButtons.get(i).func_231047_b_(mouseX, mouseY)) continue;
            this.func_238652_a_(matrixStack, this.tabButtons.get((int)i).tab.getTooltip(), mouseX, mouseY);
        }
    }

    public void changeTab(int tabIndex) {
        int oldTab = this.currentTabIndex;
        this.currentTab().onClose();
        this.tabButtons.get((int)this.currentTabIndex).field_230693_o_ = true;
        this.currentTabIndex = tabIndex;
        this.tabButtons.get((int)this.currentTabIndex).field_230693_o_ = false;
        LightmansCurrency.LogInfo("Changed from tab " + oldTab + " to tab " + this.currentTabIndex + ".");
        LightmansCurrency.LogInfo(this.tabWidgets.size() + " tab widgets & " + this.tabListeners.size() + " tab listeners were present.");
        this.tabWidgets.clear();
        this.tabListeners.clear();
        this.currentTab().init();
        this.logError = true;
    }

    private void clickedOnTab(Button tab) {
        int tabIndex = this.tabButtons.indexOf(tab);
        if (tabIndex < 0) {
            return;
        }
        this.changeTab(tabIndex);
    }

    public void func_231023_e_() {
        this.currentTab().tick();
    }

    public <T extends Widget> T addRenderableTabWidget(T widget) {
        this.tabWidgets.add(widget);
        return widget;
    }

    public void removeRenderableTabWidget(Widget widget) {
        if (this.tabWidgets.contains(widget)) {
            this.tabWidgets.remove(widget);
        }
    }

    public <T extends IGuiEventListener> T addTabListener(T listener) {
        this.tabListeners.add(listener);
        return listener;
    }

    public void removeTabListener(IGuiEventListener listener) {
        if (this.tabListeners.contains(listener)) {
            this.tabListeners.remove(listener);
        }
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        List coreListeners = super.func_231039_at__();
        ArrayList listeners = Lists.newArrayList();
        for (int i = 0; i < coreListeners.size(); ++i) {
            listeners.add(coreListeners.get(i));
        }
        listeners.addAll(this.tabWidgets);
        listeners.addAll(this.tabListeners);
        return listeners;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey) && this.currentTab().blockInventoryClosing()) {
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }
}

