/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradingTerminalScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.ItemTradeButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.ItemTraderUtil;
import io.github.lightman314.lightmanscurrency.containers.ItemTraderContainer;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.cashregister.MessageCRNextTrader;
import io.github.lightman314.lightmanscurrency.network.message.cashregister.MessageCRSkipTo;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageCollectCoins;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageExecuteTrade;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class ItemTraderScreen
extends ContainerScreen<ItemTraderContainer> {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/trader.png");
    public static final int TRADEBUTTON_VERT_SPACER = 4;
    public static final int TRADEBUTTON_VERTICALITY = 22;
    public static final int TRADEBUTTON_HORIZ_SPACER = 6;
    public static final int TRADEBUTTON_HORIZONTAL = 85;
    Button buttonShowStorage;
    Button buttonCollectMoney;
    Button buttonBack;
    Button buttonLeft;
    Button buttonRight;
    TextFieldWidget pageInput;
    Button buttonSkipToPage;
    protected List<ItemTradeButton> tradeButtons = new ArrayList<ItemTradeButton>();

    public ItemTraderScreen(ItemTraderContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        this.field_147000_g = 133 + ItemTraderUtil.getTradeDisplayHeight(((ItemTraderContainer)this.field_147002_h).getTrader());
        this.field_146999_f = ItemTraderUtil.getWidth(((ItemTraderContainer)this.field_147002_h).getTrader());
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        int x;
        if (((ItemTraderContainer)this.field_147002_h).getTrader() == null) {
            return;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        int columnCount = ItemTraderUtil.getTradeDisplayColumnCount(((ItemTraderContainer)this.field_147002_h).getTrader());
        int rowCount = ItemTraderUtil.getTradeDisplayRowCount(((ItemTraderContainer)this.field_147002_h).getTrader());
        int tradeOffset = ItemTraderUtil.getTradeDisplayOffset(((ItemTraderContainer)this.field_147002_h).getTrader());
        this.func_238474_b_(matrix, startX + ItemTraderUtil.getTradeDisplayOffset(((ItemTraderContainer)this.field_147002_h).getTrader()), startY, 0, 0, 6, 17);
        for (x = 0; x < columnCount; ++x) {
            this.func_238474_b_(matrix, startX + tradeOffset + x * 85 + 6, startY, 6, 0, 79, 17);
            if (x >= columnCount - 1) continue;
            this.func_238474_b_(matrix, startX + tradeOffset + x * 85 + 79 + 6, startY, 85, 0, 6, 17);
        }
        this.func_238474_b_(matrix, startX + tradeOffset + ItemTraderUtil.getTradeDisplayWidth(((ItemTraderContainer)this.field_147002_h).getTrader()) - 6, startY, 91, 0, 6, 17);
        for (int y = 0; y < rowCount; ++y) {
            this.func_238474_b_(matrix, startX + tradeOffset, startY + 17 + y * 22, 0, 17, 6, 22);
            for (int x2 = 0; x2 < columnCount; ++x2) {
                this.func_238474_b_(matrix, startX + tradeOffset + x2 * 85 + 6, startY + 17 + y * 22, 6, 17, 79, 22);
                if (x2 >= columnCount - 1) continue;
                this.func_238474_b_(matrix, startX + tradeOffset + x2 * 85 + 79 + 6, startY + 17 + y * 22, 85, 17, 6, 22);
            }
            this.func_238474_b_(matrix, startX + tradeOffset + ItemTraderUtil.getTradeDisplayWidth(((ItemTraderContainer)this.field_147002_h).getTrader()) - 6, startY + 17 + y * 22, 91, 17, 6, 22);
        }
        this.func_238474_b_(matrix, startX + tradeOffset, startY + 17 + rowCount * 22, 0, 43, 6, 7);
        for (x = 0; x < columnCount; ++x) {
            this.func_238474_b_(matrix, startX + tradeOffset + x * 85 + 6, startY + 17 + rowCount * 22, 6, 43, 79, 7);
            if (x >= columnCount - 1) continue;
            this.func_238474_b_(matrix, startX + tradeOffset + x * 85 + 79 + 6, startY + 17 + rowCount * 22, 6, 43, 6, 7);
        }
        this.func_238474_b_(matrix, startX + tradeOffset + ItemTraderUtil.getTradeDisplayWidth(((ItemTraderContainer)this.field_147002_h).getTrader()) - 6, startY + 17 + rowCount * 22, 91, 43, 6, 7);
        this.func_238474_b_(matrix, startX + ItemTraderUtil.getInventoryDisplayOffset(((ItemTraderContainer)this.field_147002_h).getTrader()), startY + ItemTraderUtil.getTradeDisplayHeight(((ItemTraderContainer)this.field_147002_h).getTrader()), 0, 50, 176, 133);
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        if (((ItemTraderContainer)this.field_147002_h).getTrader() == null) {
            return;
        }
        int tradeOffset = ItemTraderUtil.getTradeDisplayOffset(((ItemTraderContainer)this.field_147002_h).getTrader());
        int inventoryOffset = ItemTraderUtil.getInventoryDisplayOffset(((ItemTraderContainer)this.field_147002_h).getTrader());
        this.field_230712_o_.func_238421_b_(matrix, ((ItemTraderContainer)this.field_147002_h).getTrader().getTitle().getString(), (float)tradeOffset + 8.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrix, this.field_213127_e.func_200200_C_().getString(), (float)inventoryOffset + 8.0f, (float)(this.field_147000_g - 94), 0x404040);
        this.field_230712_o_.func_238421_b_(matrix, new TranslationTextComponent("tooltip.lightmanscurrency.credit", new Object[]{MoneyUtil.getStringOfValue(((ItemTraderContainer)this.field_147002_h).GetCoinValue())}).getString(), (float)inventoryOffset + 80.0f, (float)this.field_147000_g - 124.0f, 0x404040);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int tradeOffset = ItemTraderUtil.getTradeDisplayOffset(((ItemTraderContainer)this.field_147002_h).getTrader());
        int inventoryOffset = ItemTraderUtil.getInventoryDisplayOffset(((ItemTraderContainer)this.field_147002_h).getTrader());
        this.buttonShowStorage = (Button)this.func_230480_a_((Widget)IconAndButtonUtil.storageButton(this.field_147003_i - 20 + tradeOffset, this.field_147009_r, this::PressStorageButton));
        this.buttonShowStorage.field_230694_p_ = ((ItemTraderContainer)this.field_147002_h).hasPermission("openStorage") && !((ItemTraderContainer)this.field_147002_h).isCashRegister();
        this.buttonCollectMoney = (Button)this.func_230480_a_((Widget)IconAndButtonUtil.collectCoinButton(this.field_147003_i - 20 + tradeOffset, this.field_147009_r + 20, this::PressCollectionButton, ((ItemTraderContainer)this.field_147002_h)::getTrader));
        this.buttonCollectMoney.field_230693_o_ = false;
        boolean bl = this.buttonCollectMoney.field_230694_p_ = ((ItemTraderContainer)this.field_147002_h).hasPermission("collectCoins") && !((ItemTraderContainer)this.field_147002_h).getTrader().getCoreSettings().hasBankAccount();
        if (((ItemTraderContainer)this.field_147002_h).isUniversal()) {
            this.buttonBack = (Button)this.func_230480_a_((Widget)IconAndButtonUtil.backToTerminalButton(this.field_147003_i - 20 + inventoryOffset, this.field_147009_r + this.field_147000_g - 20, this::PressBackButton));
        }
        if (((ItemTraderContainer)this.field_147002_h).isCashRegister() && ((ItemTraderContainer)this.field_147002_h).getTotalCRSize() > 1) {
            this.buttonLeft = (Button)this.func_230480_a_((Widget)IconAndButtonUtil.leftButton(this.field_147003_i + tradeOffset - 20, this.field_147009_r, this::PressArrowButton));
            this.buttonRight = (Button)this.func_230480_a_((Widget)IconAndButtonUtil.rightButton(this.field_147003_i + this.field_146999_f - tradeOffset, this.field_147009_r, this::PressArrowButton));
            this.pageInput = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 50, this.field_147009_r - 19, this.field_146999_f - 120, 18, (ITextComponent)new StringTextComponent("")));
            this.pageInput.func_146203_f(9);
            this.pageInput.func_146180_a(String.valueOf(((ItemTraderContainer)this.field_147002_h).getThisCRIndex() + 1));
            this.buttonSkipToPage = (Button)this.func_230480_a_((Widget)IconAndButtonUtil.rightButton(this.field_147003_i + this.field_146999_f - 68, this.field_147009_r - 20, this::PressPageSkipButton));
        }
        this.initTradeButtons();
    }

    protected void initTradeButtons() {
        int tradeCount = ((ItemTraderContainer)this.field_147002_h).getTrader().getTradeCount();
        for (int i = 0; i < tradeCount; ++i) {
            this.tradeButtons.add((ItemTradeButton)this.func_230480_a_((Widget)new ItemTradeButton(this.field_147003_i + ItemTraderUtil.getButtonPosX(((ItemTraderContainer)this.field_147002_h).getTrader(), i), this.field_147009_r + ItemTraderUtil.getButtonPosY(((ItemTraderContainer)this.field_147002_h).getTrader(), i), this::PressTradeButton, i, (Screen)this, this.field_230712_o_, (Supplier<IItemTrader>)((Supplier)() -> ((ItemTraderContainer)this.field_147002_h).getTrader()), (Supplier<Long>)((Supplier)() -> ((ItemTraderContainer)this.field_147002_h).GetCoinValue()), (Supplier<IInventory>)((Supplier)() -> ((ItemTraderContainer)this.field_147002_h).GetItemInventory()))));
        }
    }

    public void func_231023_e_() {
        if (((ItemTraderContainer)this.field_147002_h).getTrader() == null) {
            ((ItemTraderContainer)this.field_147002_h).player.func_71053_j();
            return;
        }
        super.func_231023_e_();
        this.buttonShowStorage.field_230694_p_ = ((ItemTraderContainer)this.field_147002_h).hasPermission("openStorage");
        if (((ItemTraderContainer)this.field_147002_h).hasPermission("collectCoins")) {
            this.buttonCollectMoney.field_230694_p_ = !((ItemTraderContainer)this.field_147002_h).getTrader().getCoreSettings().hasBankAccount();
            boolean bl = this.buttonCollectMoney.field_230693_o_ = ((ItemTraderContainer)this.field_147002_h).getTrader().getStoredMoney().getRawValue() > 0L;
            if (!this.buttonCollectMoney.field_230693_o_) {
                this.buttonCollectMoney.field_230694_p_ = !((ItemTraderContainer)this.field_147002_h).getTrader().getCoreSettings().isCreative();
            }
        } else {
            this.buttonCollectMoney.field_230694_p_ = false;
        }
        if (this.buttonSkipToPage != null) {
            this.buttonSkipToPage.field_230693_o_ = this.getPageInput() >= 0 && this.getPageInput() < ((ItemTraderContainer)this.field_147002_h).getTotalCRSize() && this.getPageInput() != ((ItemTraderContainer)this.field_147002_h).getThisCRIndex();
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (((ItemTraderContainer)this.field_147002_h).getTrader() == null) {
            ((ItemTraderContainer)this.field_147002_h).player.func_71053_j();
            return;
        }
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        IconAndButtonUtil.renderButtonTooltips(matrixStack, mouseX, mouseY, this.field_230710_m_);
        for (int i = 0; i < this.tradeButtons.size(); ++i) {
            this.tradeButtons.get(i).tryRenderTooltip(matrixStack, (Screen)this, ((ItemTraderContainer)this.field_147002_h).getTrader(), false, mouseX, mouseY);
        }
    }

    private void PressStorageButton(Button button) {
        if (((ItemTraderContainer)this.field_147002_h).hasPermission("openStorage")) {
            ((ItemTraderContainer)this.field_147002_h).getTrader().sendOpenStorageMessage();
        }
    }

    private void PressCollectionButton(Button button) {
        if (((ItemTraderContainer)this.field_147002_h).hasPermission("collectCoins")) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCollectCoins());
        }
    }

    private void PressTradeButton(Button button) {
        int tradeIndex = 0;
        if (this.tradeButtons.contains(button)) {
            tradeIndex = this.tradeButtons.indexOf(button);
        }
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageExecuteTrade(tradeIndex));
    }

    private void PressBackButton(Button button) {
        ((ItemTraderContainer)this.field_147002_h).player.func_71053_j();
        this.field_230706_i_.func_147108_a((Screen)new TradingTerminalScreen());
    }

    private void PressArrowButton(Button button) {
        int direction = 1;
        if (button == this.buttonLeft) {
            direction = -1;
        }
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCRNextTrader(direction));
    }

    private void PressPageSkipButton(Button button) {
        int page = this.getPageInput();
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCRSkipTo(page));
    }

    private int getPageInput() {
        if (this.pageInput != null) {
            return TextInputUtil.getIntegerValue(this.pageInput) - 1;
        }
        return 0;
    }
}

