/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.api.ItemShopLogger;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeItemPriceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TextLogWindow;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.ItemTradeButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.ItemTraderStorageUtil;
import io.github.lightman314.lightmanscurrency.containers.ItemTraderStorageContainer;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageCollectCoins;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageStoreCoins;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class ItemTraderStorageScreen
extends ContainerScreen<ItemTraderStorageContainer> {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/traderstorage.png");
    public static final int SCREEN_EXTENSION = 99;
    Button buttonShowTrades;
    Button buttonCollectMoney;
    Button buttonOpenSettings;
    Button buttonStoreMoney;
    Button buttonShowLog;
    Button buttonClearLog;
    TextLogWindow logWindow;
    Button buttonTradeRules;
    List<Button> tradePriceButtons = new ArrayList<Button>();

    public ItemTraderStorageScreen(ItemTraderStorageContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        int tradeCount = ((ItemTraderStorageContainer)this.field_147002_h).getTrader().getTradeCount();
        this.field_147000_g = 18 * ItemTraderStorageUtil.getRowCount(tradeCount) + 125;
        this.field_146999_f = ItemTraderStorageUtil.getWidth(tradeCount);
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        if (((ItemTraderStorageContainer)this.field_147002_h).getTrader() == null) {
            return;
        }
        List<ItemTradeData> trades = ((ItemTraderStorageContainer)this.field_147002_h).getTrader().getAllTrades();
        int tradeCount = trades.size();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        int rowCount = ItemTraderStorageUtil.getRowCount(tradeCount);
        int columnCount = ItemTraderStorageUtil.getColumnCount(tradeCount);
        this.func_238474_b_(matrix, startX + 99, startY, 0, 0, 7, 17);
        for (int x = 0; x < columnCount; ++x) {
            this.func_238474_b_(matrix, startX + 99 + 7 + x * 162, startY, 7, 0, 162, 17);
        }
        this.func_238474_b_(matrix, startX + this.field_146999_f - 99 - 7, startY, 169, 0, 7, 17);
        int index = 0;
        for (int y = 0; y < rowCount; ++y) {
            int x;
            this.func_238474_b_(matrix, startX + 99, startY + 17 + 18 * y, 0, 17, 7, 18);
            if (y < rowCount - 1 || tradeCount % ItemTraderStorageUtil.getColumnCount(tradeCount) == 0 || y == 0) {
                for (x = 0; x < columnCount; ++x) {
                    if (index < tradeCount) {
                        this.func_238474_b_(matrix, startX + 99 + 7 + x * 162, startY + 17 + 18 * y, 7, 17, 162, 18);
                    } else {
                        this.func_238474_b_(matrix, startX + 99 + 7 + x * 162, startY + 17 + 18 * y, 0, 143, 162, 18);
                    }
                    ++index;
                }
            } else {
                for (x = 0; x < columnCount; ++x) {
                    this.func_238474_b_(matrix, startX + 99 + 7 + x * 162, startY + 17 + 18 * y, 0, 143, 162, 18);
                }
                this.func_238474_b_(matrix, startX + 99 + 7 + ItemTraderStorageUtil.getStorageSlotOffset(tradeCount, y), startY + 17 + 18 * y, 7, 17, 162, 18);
            }
            this.func_238474_b_(matrix, startX + this.field_146999_f - 99 - 7, startY + 17 + 18 * y, 169, 17, 7, 18);
        }
        this.func_238474_b_(matrix, startX + 99, startY + 17 + 18 * rowCount, 0, 35, 7, 8);
        for (int x = 0; x < columnCount; ++x) {
            this.func_238474_b_(matrix, startX + 99 + 7 + x * 162, startY + 17 + 18 * rowCount, 7, 35, 162, 8);
        }
        this.func_238474_b_(matrix, startX + this.field_146999_f - 99 - 7, startY + 17 + 18 * rowCount, 169, 35, 7, 8);
        this.func_238474_b_(matrix, startX + 99 + ItemTraderStorageUtil.getInventoryOffset(tradeCount), startY + 25 + rowCount * 18, 0, 43, 208, 100);
        for (int i = 0; i < tradeCount; ++i) {
            boolean inverted = ItemTraderStorageUtil.isFakeTradeButtonInverted(tradeCount, i);
            ItemTradeButton.renderItemTradeButton(matrix, (Screen)this, this.field_230712_o_, startX + ItemTraderStorageUtil.getFakeTradeButtonPosX(tradeCount, i), startY + ItemTraderStorageUtil.getFakeTradeButtonPosY(tradeCount, i), i, ((ItemTraderStorageContainer)this.field_147002_h).getTrader(), inverted);
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        if (((ItemTraderStorageContainer)this.field_147002_h).getTrader() == null) {
            return;
        }
        this.field_230712_o_.func_238421_b_(matrix, ((ItemTraderStorageContainer)this.field_147002_h).getTrader().getName().getString(), 107.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrix, this.field_213127_e.func_200200_C_().getString(), (float)ItemTraderStorageUtil.getInventoryOffset(((ItemTraderStorageContainer)this.field_147002_h).getTrader().getTradeCount()) + 8.0f + 99.0f, (float)(this.field_147000_g - 94), 0x404040);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.buttonShowTrades = (Button)this.func_230480_a_((Widget)IconAndButtonUtil.traderButton(this.field_147003_i + 99, this.field_147009_r - 20, this::PressTradesButton));
        this.buttonCollectMoney = (Button)this.func_230480_a_((Widget)IconAndButtonUtil.collectCoinButton(this.field_147003_i + 99 + 20, this.field_147009_r - 20, this::PressCollectionButton, ((ItemTraderStorageContainer)this.field_147002_h)::getTrader));
        this.buttonCollectMoney.field_230693_o_ = false;
        this.buttonCollectMoney.field_230694_p_ = ((ItemTraderStorageContainer)this.field_147002_h).hasPermission("collectCoins") && !((ItemTraderStorageContainer)this.field_147002_h).getTrader().getCoreSettings().hasBankAccount();
        int tradeCount = ((ItemTraderStorageContainer)this.field_147002_h).getTrader().getTradeCount();
        this.buttonStoreMoney = (Button)this.func_230480_a_((Widget)IconAndButtonUtil.storeCoinButton(this.field_147003_i + 99 + ItemTraderStorageUtil.getInventoryOffset(tradeCount) + 176 + 32, this.field_147009_r + 25 + ItemTraderStorageUtil.getRowCount(tradeCount) * 18, this::PressStoreCoinsButton));
        this.buttonStoreMoney.field_230694_p_ = false;
        this.buttonShowLog = (Button)this.func_230480_a_((Widget)IconAndButtonUtil.showLoggerButton(this.field_147003_i + 99 + 40, this.field_147009_r - 20, this::PressLogButton, () -> this.logWindow.field_230694_p_));
        this.buttonClearLog = (Button)this.func_230480_a_((Widget)IconAndButtonUtil.clearLoggerButton(this.field_147003_i + 99 + 60, this.field_147009_r - 20, this::PressClearLogButton));
        this.buttonClearLog.field_230694_p_ = ((ItemShopLogger)((ItemTraderStorageContainer)this.field_147002_h).getTrader().getLogger()).logText.size() > 0 && ((ItemTraderStorageContainer)this.field_147002_h).hasPermission("clearLogs");
        this.buttonOpenSettings = (Button)this.func_230480_a_((Widget)IconAndButtonUtil.openSettingsButton(this.field_147003_i + this.field_146999_f - 99 - 20, this.field_147009_r - 20, this::PressSettingsButton));
        this.buttonOpenSettings.field_230694_p_ = ((ItemTraderStorageContainer)this.field_147002_h).hasPermission("editSettings");
        this.buttonTradeRules = (Button)this.func_230480_a_((Widget)IconAndButtonUtil.tradeRuleButton(this.field_147003_i + this.field_146999_f - 99 - 40, this.field_147009_r - 20, this::PressTradeRulesButton));
        this.buttonTradeRules.field_230694_p_ = ((ItemTraderStorageContainer)this.field_147002_h).hasPermission("editTradeRules");
        this.logWindow = (TextLogWindow)this.func_230481_d_((IGuiEventListener)IconAndButtonUtil.traderLogWindow(this, ((ItemTraderStorageContainer)this.field_147002_h)::getTrader));
        this.logWindow.field_230694_p_ = false;
        for (int i = 0; i < tradeCount; ++i) {
            this.tradePriceButtons.add((Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + ItemTraderStorageUtil.getTradePriceButtonPosX(tradeCount, i), this.field_147009_r + ItemTraderStorageUtil.getTradePriceButtonPosY(tradeCount, i), 20, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.dollarsign"), this::PressTradePriceButton)));
        }
        this.func_231023_e_();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (((ItemTraderStorageContainer)this.field_147002_h).getTrader() == null) {
            ((ItemTraderStorageContainer)this.field_147002_h).player.func_71053_j();
            return;
        }
        this.func_230446_a_(matrixStack);
        if (this.logWindow.field_230694_p_) {
            this.logWindow.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.buttonShowLog.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            if (this.buttonClearLog.field_230694_p_) {
                this.buttonClearLog.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
            IconAndButtonUtil.renderButtonTooltips(matrixStack, mouseX, mouseY, Lists.newArrayList((Object[])new Widget[]{this.buttonShowLog, this.buttonClearLog}));
            return;
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        IconAndButtonUtil.renderButtonTooltips(matrixStack, mouseX, mouseY, this.field_230710_m_);
        if (((ItemTraderStorageContainer)this.field_147002_h).player.field_71071_by.func_70445_o().func_190926_b()) {
            int tradeCount = ((ItemTraderStorageContainer)this.field_147002_h).getTrader().getTradeCount();
            for (int i = 0; i < ((ItemTraderStorageContainer)this.field_147002_h).getTrader().getTradeCount(); ++i) {
                boolean inverted = ItemTraderStorageUtil.isFakeTradeButtonInverted(tradeCount, i);
                int result = ItemTradeButton.tryRenderTooltip(matrixStack, (Screen)this, i, ((ItemTraderStorageContainer)this.field_147002_h).getTrader(), this.field_147003_i + ItemTraderStorageUtil.getFakeTradeButtonPosX(tradeCount, i), this.field_147009_r + ItemTraderStorageUtil.getFakeTradeButtonPosY(tradeCount, i), inverted, mouseX, mouseY);
                if (result >= 0 || !((ItemTraderStorageContainer)this.field_147002_h).hasPermission("editTrades")) continue;
                this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.trader.item_edit"), mouseX, mouseY);
            }
        }
    }

    public void func_231023_e_() {
        if (((ItemTraderStorageContainer)this.field_147002_h).getTrader() == null) {
            ((ItemTraderStorageContainer)this.field_147002_h).player.func_71053_j();
            return;
        }
        if (!((ItemTraderStorageContainer)this.field_147002_h).hasPermission("openStorage")) {
            ((ItemTraderStorageContainer)this.field_147002_h).player.func_71053_j();
            ((ItemTraderStorageContainer)this.field_147002_h).getTrader().sendOpenTraderMessage();
            return;
        }
        super.func_231023_e_();
        this.buttonCollectMoney.field_230694_p_ = (!((ItemTraderStorageContainer)this.field_147002_h).getTrader().getCoreSettings().isCreative() || ((ItemTraderStorageContainer)this.field_147002_h).getTrader().getStoredMoney().getRawValue() > 0L) && ((ItemTraderStorageContainer)this.field_147002_h).hasPermission("collectCoins") && !((ItemTraderStorageContainer)this.field_147002_h).getTrader().getCoreSettings().hasBankAccount();
        this.buttonCollectMoney.field_230693_o_ = ((ItemTraderStorageContainer)this.field_147002_h).getTrader().getStoredMoney().getRawValue() > 0L;
        this.buttonOpenSettings.field_230694_p_ = ((ItemTraderStorageContainer)this.field_147002_h).hasPermission("editSettings");
        this.buttonStoreMoney.field_230694_p_ = ((ItemTraderStorageContainer)this.field_147002_h).HasCoinsToAdd() && ((ItemTraderStorageContainer)this.field_147002_h).hasPermission("storeCoins");
        this.buttonClearLog.field_230694_p_ = ((ItemShopLogger)((ItemTraderStorageContainer)this.field_147002_h).getTrader().getLogger()).logText.size() > 0 && ((ItemTraderStorageContainer)this.field_147002_h).hasPermission("clearLogs");
        this.buttonTradeRules.field_230694_p_ = ((ItemTraderStorageContainer)this.field_147002_h).hasPermission("editTradeRules");
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (!((ItemTraderStorageContainer)this.field_147002_h).hasPermission("editTrades")) {
            return super.func_231044_a_(mouseX, mouseY, button);
        }
        ItemStack heldItem = ((ItemTraderStorageContainer)this.field_147002_h).player.field_71071_by.func_70445_o();
        int tradeCount = ((ItemTraderStorageContainer)this.field_147002_h).getTrader().getTradeCount();
        for (int i = 0; i < tradeCount; ++i) {
            ItemTradeData trade = (ItemTradeData)((ItemTraderStorageContainer)this.field_147002_h).getTrader().getTrade(i);
            if (ItemTradeButton.isMouseOverSlot(0, this.field_147003_i + ItemTraderStorageUtil.getFakeTradeButtonPosX(tradeCount, i), this.field_147009_r + ItemTraderStorageUtil.getFakeTradeButtonPosY(tradeCount, i), (int)mouseX, (int)mouseY, ItemTraderStorageUtil.isFakeTradeButtonInverted(tradeCount, i))) {
                ItemStack currentSellItem = trade.getSellItem();
                if (heldItem.func_190926_b() && currentSellItem.func_190926_b()) {
                    ((ItemTraderStorageContainer)this.field_147002_h).openItemEditScreenForTrade(i);
                    return true;
                }
                if (heldItem.func_190926_b()) {
                    currentSellItem.func_190918_g(button == 0 ? currentSellItem.func_190916_E() : 1);
                    if (currentSellItem.func_190916_E() <= 0) {
                        currentSellItem = ItemStack.field_190927_a;
                    }
                    trade.setSellItem(currentSellItem);
                    ((ItemTraderStorageContainer)this.field_147002_h).getTrader().sendSetTradeItemMessage(i, currentSellItem, 0);
                    return true;
                }
                if (button == 1) {
                    if (InventoryUtil.ItemMatches(currentSellItem, heldItem)) {
                        if (currentSellItem.func_190916_E() < currentSellItem.func_77976_d()) {
                            currentSellItem.func_190917_f(1);
                        }
                    } else {
                        currentSellItem = heldItem.func_77946_l();
                        currentSellItem.func_190920_e(1);
                    }
                } else {
                    currentSellItem = heldItem.func_77946_l();
                }
                trade.setSellItem(currentSellItem);
                ((ItemTraderStorageContainer)this.field_147002_h).getTrader().sendSetTradeItemMessage(i, currentSellItem, 0);
                return true;
            }
            if (!((ItemTradeData)((ItemTraderStorageContainer)this.field_147002_h).getTrader().getTrade(i)).isBarter() || !ItemTradeButton.isMouseOverSlot(1, this.field_147003_i + ItemTraderStorageUtil.getFakeTradeButtonPosX(tradeCount, i), this.field_147009_r + ItemTraderStorageUtil.getFakeTradeButtonPosY(tradeCount, i), (int)mouseX, (int)mouseY, ItemTraderStorageUtil.isFakeTradeButtonInverted(tradeCount, i))) continue;
            ItemStack currentBarterItem = trade.getBarterItem();
            if (heldItem.func_190926_b() && currentBarterItem.func_190926_b()) {
                ((ItemTraderStorageContainer)this.field_147002_h).openItemEditScreenForTrade(i);
                return true;
            }
            if (heldItem.func_190926_b()) {
                currentBarterItem.func_190918_g(button == 0 ? currentBarterItem.func_190916_E() : 1);
                if (currentBarterItem.func_190916_E() <= 0) {
                    currentBarterItem = ItemStack.field_190927_a;
                }
                trade.setBarterItem(currentBarterItem);
                ((ItemTraderStorageContainer)this.field_147002_h).getTrader().sendSetTradeItemMessage(i, currentBarterItem, 1);
                return true;
            }
            if (button == 1) {
                if (InventoryUtil.ItemMatches(currentBarterItem, heldItem)) {
                    if (currentBarterItem.func_190916_E() < currentBarterItem.func_77976_d()) {
                        currentBarterItem.func_190917_f(1);
                    }
                } else {
                    currentBarterItem = heldItem.func_77946_l();
                    currentBarterItem.func_190920_e(1);
                }
            } else {
                currentBarterItem = heldItem.func_77946_l();
            }
            trade.setBarterItem(currentBarterItem);
            ((ItemTraderStorageContainer)this.field_147002_h).getTrader().sendSetTradeItemMessage(i, currentBarterItem, 1);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    private void PressTradesButton(Button button) {
        ((ItemTraderStorageContainer)this.field_147002_h).getTrader().sendOpenTraderMessage();
    }

    private void PressCollectionButton(Button button) {
        if (((ItemTraderStorageContainer)this.field_147002_h).hasPermission("collectCoins")) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCollectCoins());
        } else {
            Settings.PermissionWarning(((ItemTraderStorageContainer)this.field_147002_h).player, "collect stored coins", "collectCoins");
        }
    }

    private void PressStoreCoinsButton(Button button) {
        if (((ItemTraderStorageContainer)this.field_147002_h).hasPermission("storeCoins")) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageStoreCoins());
        } else {
            Settings.PermissionWarning(((ItemTraderStorageContainer)this.field_147002_h).player, "store coins", "storeCoins");
        }
    }

    private void PressTradePriceButton(Button button) {
        if (!((ItemTraderStorageContainer)this.field_147002_h).hasPermission("editTrades")) {
            return;
        }
        int tradeIndex = 0;
        if (this.tradePriceButtons.contains(button)) {
            tradeIndex = this.tradePriceButtons.indexOf(button);
        }
        this.field_230706_i_.func_147108_a((Screen)new TradeItemPriceScreen(((ItemTraderStorageContainer)this.field_147002_h)::getTrader, tradeIndex, this.field_213127_e.field_70458_d));
    }

    private void PressLogButton(Button button) {
        this.logWindow.field_230694_p_ = !this.logWindow.field_230694_p_;
    }

    private void PressClearLogButton(Button button) {
        ((ItemTraderStorageContainer)this.field_147002_h).getTrader().sendClearLogMessage();
    }

    private void PressTradeRulesButton(Button button) {
        Minecraft.func_71410_x().func_147108_a((Screen)new TradeRuleScreen(((ItemTraderStorageContainer)this.field_147002_h).getTrader().getRuleScreenHandler()));
    }

    private void PressSettingsButton(Button button) {
        ((ItemTraderStorageContainer)this.field_147002_h).player.func_71053_j();
        Minecraft.func_71410_x().func_147108_a((Screen)new TraderSettingsScreen((Supplier<ITrader>)((Supplier)((ItemTraderStorageContainer)this.field_147002_h)::getTrader), player -> ((ItemTraderStorageContainer)this.field_147002_h).getTrader().sendOpenStorageMessage()));
    }
}

