/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.containers.PaygateContainer;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.paygate.MessageActivatePaygate;
import io.github.lightman314.lightmanscurrency.network.message.paygate.MessageSetPaygateTicket;
import io.github.lightman314.lightmanscurrency.network.message.paygate.MessageUpdatePaygateData;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageCollectCoins;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class PaygateScreen
extends ContainerScreen<PaygateContainer>
implements CoinValueInput.ICoinValueInput {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/paygate.png");
    private static final int GUI_HEIGHT = 151;
    CoinValueInput priceInput;
    TextFieldWidget durationInput;
    private IconButton buttonCollectMoney;
    private IconButton buttonPay;
    private IconButton buttonSetTicket;

    public PaygateScreen(PaygateContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        this.field_147000_g = ((PaygateContainer)this.field_147002_h).isOwner() ? 220 : 151;
        this.field_146999_f = 176;
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        if (((PaygateContainer)this.field_147002_h).isOwner()) {
            this.func_238474_b_(matrix, startX, startY + ((PaygateContainer)this.field_147002_h).priceInputOffset, 0, 0, this.field_146999_f, this.field_147000_g - ((PaygateContainer)this.field_147002_h).priceInputOffset);
        } else {
            this.func_238474_b_(matrix, startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrix, this.field_230704_d_.getString(), 8.0f, 6.0f + (float)((PaygateContainer)this.field_147002_h).priceInputOffset, 0x404040);
        this.field_230712_o_.func_238421_b_(matrix, this.field_213127_e.func_145748_c_().getString(), 8.0f, (float)(this.field_147000_g - 94), 0x404040);
        this.field_230712_o_.func_238421_b_(matrix, new TranslationTextComponent("tooltip.lightmanscurrency.paygate.price", new Object[]{((PaygateContainer)this.field_147002_h).tileEntity.getPrice().getString()}).getString(), 8.0f, 16.0f + (float)((PaygateContainer)this.field_147002_h).priceInputOffset, 0);
        this.field_230712_o_.func_238421_b_(matrix, new TranslationTextComponent("tooltip.lightmanscurrency.paygate.duration", new Object[]{((PaygateContainer)this.field_147002_h).tileEntity.getDuration()}).getString(), 8.0f, 25.0f + (float)((PaygateContainer)this.field_147002_h).priceInputOffset, 0);
        this.field_230712_o_.func_238421_b_(matrix, new TranslationTextComponent("tooltip.lightmanscurrency.credit", new Object[]{MoneyUtil.getStringOfValue(((PaygateContainer)this.field_147002_h).GetCoinValue())}).getString(), 80.0f, (float)this.field_147000_g - 124.0f, 0x404040);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        if (((PaygateContainer)this.field_147002_h).isOwner()) {
            this.priceInput = new CoinValueInput(this.field_147009_r, (ITextComponent)new TranslationTextComponent("gui.lightmanscurrency.changeprice"), ((PaygateContainer)this.field_147002_h).tileEntity.getPrice(), this);
            this.field_230705_e_.add(this.priceInput);
            this.durationInput = new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 8, this.field_147009_r + 35 + ((PaygateContainer)this.field_147002_h).priceInputOffset, 30, 18, ITextComponent.func_244388_a((String)""));
            this.durationInput.func_146180_a(String.valueOf(((PaygateContainer)this.field_147002_h).tileEntity.getDuration()));
            this.durationInput.func_146203_f(3);
            this.field_230705_e_.add(this.durationInput);
            this.buttonCollectMoney = (IconButton)this.func_230480_a_((Widget)IconAndButtonUtil.collectCoinButtonAlt(this.field_147003_i - 20, this.field_147009_r + ((PaygateContainer)this.field_147002_h).priceInputOffset, this::PressCollectionButton, () -> ((PaygateContainer)this.field_147002_h).tileEntity.getStoredMoney().getString()));
            this.buttonCollectMoney.field_230693_o_ = false;
            this.buttonSetTicket = (IconButton)this.func_230480_a_((Widget)new IconButton(this.field_147003_i + 40, this.field_147009_r + 34 + ((PaygateContainer)this.field_147002_h).priceInputOffset, this::PressTicketButton, IconAndButtonUtil.ICON_TICKET, IconAndButtonUtil.TOOLTIP_PAIR_TICKET));
            this.buttonSetTicket.field_230694_p_ = false;
        }
        this.buttonPay = (IconButton)this.func_230480_a_((Widget)new IconButton(this.field_147003_i + 149, this.field_147009_r + 6 + ((PaygateContainer)this.field_147002_h).priceInputOffset, this::PressActivateButton, IconAndButtonUtil.ICON_PAYGATE_ACTIVATE, IconAndButtonUtil.TOOLTIP_PAYGATE_ACTIVATE));
        this.buttonPay.field_230693_o_ = false;
        this.func_231023_e_();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.priceInput != null) {
            this.priceInput.tick();
        }
        if (this.durationInput != null) {
            this.durationInput.func_146178_a();
            int duration = this.getDuration();
            if (duration != ((PaygateContainer)this.field_147002_h).tileEntity.getDuration()) {
                LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageUpdatePaygateData(((PaygateContainer)this.field_147002_h).tileEntity.func_174877_v(), this.priceInput.getCoinValue().copy(), duration));
                ((PaygateContainer)this.field_147002_h).tileEntity.setDuration(duration);
                if (this.durationInput.func_146179_b() != "") {
                    this.durationInput.func_146180_a(String.valueOf(((PaygateContainer)this.field_147002_h).tileEntity.getDuration()));
                }
            }
        }
        if (this.buttonCollectMoney != null) {
            boolean bl = this.buttonCollectMoney.field_230693_o_ = ((PaygateContainer)this.field_147002_h).tileEntity.getStoredMoney().getRawValue() > 0L;
        }
        if (this.buttonSetTicket != null) {
            this.buttonSetTicket.field_230694_p_ = ((PaygateContainer)this.field_147002_h).HasMasterTicket() && !((PaygateContainer)this.field_147002_h).tileEntity.validTicket(((PaygateContainer)this.field_147002_h).GetTicketID());
        }
        this.buttonPay.field_230693_o_ = ((PaygateContainer)this.field_147002_h).CanActivate();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        if (this.priceInput != null) {
            this.priceInput.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.durationInput != null) {
            this.durationInput.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        IconAndButtonUtil.renderButtonTooltips(matrixStack, mouseX, mouseY, this.field_230710_m_);
    }

    private void PressActivateButton(Button button) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageActivatePaygate());
    }

    private void PressCollectionButton(Button button) {
        if (((PaygateContainer)this.field_147002_h).isOwner()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCollectCoins());
        }
    }

    private void PressTicketButton(Button button) {
        if (((PaygateContainer)this.field_147002_h).isOwner()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSetPaygateTicket(((PaygateContainer)this.field_147002_h).tileEntity.func_174877_v(), ((PaygateContainer)this.field_147002_h).GetTicketID()));
        }
    }

    private int getDuration() {
        return MathUtil.clamp(TextInputUtil.getIntegerValue(this.durationInput), 1, 200);
    }

    @Override
    public <T extends Button> T addCustomButton(T button) {
        return (T)((Button)super.func_230480_a_(button));
    }

    @Override
    public <T extends IGuiEventListener> T addCustomListener(T listener) {
        return (T)super.func_230481_d_(listener);
    }

    @Override
    public int getWidth() {
        return this.field_230708_k_;
    }

    @Override
    public void OnCoinValueChanged(CoinValueInput input) {
        ((PaygateContainer)this.field_147002_h).tileEntity.setPrice(input.getCoinValue());
        int duration = this.getDuration();
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageUpdatePaygateData(((PaygateContainer)this.field_147002_h).tileEntity.func_174877_v(), this.priceInput.getCoinValue().copy(), duration));
    }

    @Override
    public FontRenderer getFont() {
        return this.field_230712_o_;
    }
}

