/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.client.gui.widget.BankAccountWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.containers.WalletContainer;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.wallet.MessageWalletConvertCoins;
import io.github.lightman314.lightmanscurrency.network.message.wallet.MessageWalletToggleAutoConvert;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class WalletScreen
extends ContainerScreen<WalletContainer>
implements BankAccountWidget.IBankAccountWidget {
    private final int BASEHEIGHT = 114;
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/wallet.png");
    IconButton buttonToggleAutoConvert;
    Button buttonConvert;
    boolean autoConvert = false;
    BankAccountWidget bankWidget;

    public WalletScreen(WalletContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        container.addListener(this::func_231160_c_);
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        int y;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        int yOffset = ((WalletContainer)this.field_147002_h).getVerticalOffset();
        this.func_238474_b_(matrix, startX - 28, startY + yOffset, 18, 132, 28, 28);
        this.func_238474_b_(matrix, startX, startY + yOffset, 0, 0, this.field_146999_f, 17);
        for (y = 0; y < ((WalletContainer)this.field_147002_h).getRowCount(); ++y) {
            this.func_238474_b_(matrix, startX, startY + 17 + y * 18 + yOffset, 0, 17, this.field_146999_f, 18);
        }
        this.func_238474_b_(matrix, startX, startY + 17 + ((WalletContainer)this.field_147002_h).getRowCount() * 18 + yOffset, 0, 35, this.field_146999_f, 97);
        y = 0;
        while (y * 9 < ((WalletContainer)this.field_147002_h).getSlotCount()) {
            for (int x = 0; x < 9 && x + y * 9 < ((WalletContainer)this.field_147002_h).getSlotCount(); ++x) {
                this.func_238474_b_(matrix, startX + 7 + x * 18, startY + 17 + y * 18 + yOffset, 0, 132, 18, 18);
            }
            ++y;
        }
        if (((WalletContainer)this.field_147002_h).hasBankAccess() && this.bankWidget != null) {
            int yOff;
            int thisHeight;
            this.bankWidget.renderCoinValueWidget(matrix, mouseX, mouseY, partialTicks);
            this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
            startX = this.field_230708_k_ / 2 - 70 - 10;
            startY = this.field_147009_r + 69;
            int width = 160;
            int height = 40;
            int xOff = 0;
            for (yOff = 0; yOff < height; yOff += thisHeight) {
                thisHeight = MathUtil.clamp(height - yOff, 0, 32);
                this.func_238474_b_(matrix, startX, startY + yOff, 0, 8, 7, thisHeight);
            }
            for (yOff = 0; yOff < height; yOff += thisHeight) {
                thisHeight = MathUtil.clamp(height - yOff, 0, 32);
                this.func_238474_b_(matrix, startX + width - 7, startY + yOff, 169, 8, 7, thisHeight);
            }
            while (xOff < width - 14) {
                int thisHeight2;
                int thisWidth = MathUtil.clamp(width - xOff - 14, 0, 18);
                for (yOff = 0; yOff < height; yOff += thisHeight2) {
                    thisHeight2 = MathUtil.clamp(height - yOff, 0, 32);
                    this.func_238474_b_(matrix, startX + 7 + xOff, startY + yOff, 7, 8, thisWidth, thisHeight2);
                }
                xOff += thisWidth;
            }
            this.bankWidget.renderInfo(matrix, -1);
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrix, ((WalletContainer)this.field_147002_h).getTitle().getString(), 8.0f, 6.0f + (float)((WalletContainer)this.field_147002_h).getVerticalOffset(), 0x404040);
        this.field_230712_o_.func_238421_b_(matrix, this.field_213127_e.func_145748_c_().getString(), 8.0f, (float)(this.field_147000_g - 94), 0x404040);
    }

    protected void func_231160_c_() {
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.buttonConvert = null;
        this.buttonToggleAutoConvert = null;
        this.bankWidget = null;
        int yOffset = ((WalletContainer)this.field_147002_h).getVerticalOffset();
        this.field_147000_g = 114 + ((WalletContainer)this.field_147002_h).getRowCount() * 18 + yOffset;
        this.field_146999_f = 176;
        super.func_231160_c_();
        if (((WalletContainer)this.field_147002_h).canConvert()) {
            this.buttonConvert = (Button)this.func_230480_a_((Widget)new IconButton(this.field_147003_i - 20, this.field_147009_r + 28 + yOffset, this::PressConvertButton, IconData.of(GUI_TEXTURE, this.field_146999_f, 0)));
            if (((WalletContainer)this.field_147002_h).canPickup()) {
                this.buttonToggleAutoConvert = (IconButton)this.func_230480_a_((Widget)new IconButton(this.field_147003_i - 20, this.field_147009_r + 48 + yOffset, this::PressAutoConvertToggleButton, IconData.of(GUI_TEXTURE, this.field_146999_f, 16)));
                this.updateToggleButton();
            }
        }
        if (((WalletContainer)this.field_147002_h).hasBankAccess()) {
            this.bankWidget = new BankAccountWidget(this.field_147009_r, this, -1);
            this.bankWidget.allowEmptyDeposits = false;
        }
    }

    public void func_231023_e_() {
        if (this.buttonToggleAutoConvert != null && ((WalletContainer)this.field_147002_h).getAutoConvert() != this.autoConvert) {
            this.updateToggleButton();
        }
        if (this.bankWidget != null) {
            this.bankWidget.tick();
        }
        super.func_231023_e_();
    }

    private void updateToggleButton() {
        this.autoConvert = ((WalletContainer)this.field_147002_h).getAutoConvert();
        this.buttonToggleAutoConvert.setIcon(IconData.of(GUI_TEXTURE, this.field_146999_f, this.autoConvert ? 16 : 32));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        if (this.buttonConvert != null && this.buttonConvert.func_231047_b_((double)mouseX, (double)mouseY)) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.wallet.convert"), mouseX, mouseY);
        } else if (this.buttonToggleAutoConvert != null && this.buttonToggleAutoConvert.func_231047_b_(mouseX, mouseY)) {
            if (this.autoConvert) {
                this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.wallet.autoconvert.disable"), mouseX, mouseY);
            } else {
                this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.wallet.autoconvert.enable"), mouseX, mouseY);
            }
        }
    }

    public void PressConvertButton(Button button) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageWalletConvertCoins());
    }

    public void PressAutoConvertToggleButton(Button button) {
        ((WalletContainer)this.field_147002_h).ToggleAutoConvert();
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageWalletToggleAutoConvert());
    }

    @Override
    public <T extends Button> T addCustomWidget(T widget) {
        return (T)((Button)this.func_230480_a_((Widget)widget));
    }

    @Override
    public <T extends IGuiEventListener> T addCustomListener(T widget) {
        return (T)this.func_230481_d_(widget);
    }

    @Override
    public FontRenderer getFont() {
        return this.field_230712_o_;
    }

    @Override
    public Screen getScreen() {
        return this;
    }

    @Override
    public int getWidth() {
        return this.field_230708_k_;
    }

    @Override
    public BankAccount getAccount() {
        return ((WalletContainer)this.field_147002_h).getAccount();
    }

    @Override
    public IInventory getCoinAccess() {
        return ((WalletContainer)this.field_147002_h).getCoinInput();
    }
}

