/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.containers.ATMContainer;
import io.github.lightman314.lightmanscurrency.containers.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageATMSetAccount;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SelectionTab
extends ATMTab {
    Button buttonPersonalAccount;
    TeamSelectWidget teamSelection;
    UUID selectedTeam = null;

    public SelectionTab(ATMScreen screen) {
        super(screen);
    }

    @Override
    public IconData getIcon() {
        return IconData.of((IItemProvider)Items.field_151121_aF);
    }

    @Override
    public ITextComponent getTooltip() {
        return new TranslationTextComponent("tooltip.lightmanscurrency.atm.selection");
    }

    @Override
    public void init() {
        SimpleSlot.SetInactive(this.screen.func_212873_a_());
        this.teamSelection = this.screen.addRenderableTabWidget(new TeamSelectWidget(this.screen.getGuiLeft() + 79, this.screen.getGuiTop() + 15, 5, TeamButton.Size.NARROW, this::getTeamList, this::selectedTeam, this::SelectTeam));
        this.teamSelection.init(this.screen::addRenderableTabWidget, this.screen.getFont());
        this.buttonPersonalAccount = this.screen.addRenderableTabWidget(new Button(this.screen.getGuiLeft() + 7, this.screen.getGuiTop() + 15, 70, 20, (ITextComponent)new TranslationTextComponent("gui.button.bank.playeraccount"), this::PressPersonalAccount));
        this.buttonPersonalAccount.field_230693_o_ = this.selectedTeam != null;
    }

    private List<Team> getTeamList() {
        ArrayList results = Lists.newArrayList();
        for (Team team : ClientTradingOffice.getTeamList()) {
            if (!team.hasBankAccount() || !team.canAccessBankAccount(((ATMContainer)this.screen.func_212873_a_()).getPlayer())) continue;
            results.add(team);
        }
        return results;
    }

    public Team selectedTeam() {
        if (this.selectedTeam != null) {
            return ClientTradingOffice.getTeam(this.selectedTeam);
        }
        return null;
    }

    public void SelectTeam(int teamIndex) {
        try {
            Team team = this.getTeamList().get(teamIndex);
            if (team.getID().equals(this.selectedTeam)) {
                return;
            }
            this.selectedTeam = team.getID();
            BankAccount.AccountReference accountSource = BankAccount.GenerateReference(true, team);
            ((ATMContainer)this.screen.func_212873_a_()).SetAccount(accountSource);
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageATMSetAccount(accountSource));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void PressPersonalAccount(Button button) {
        this.selectedTeam = null;
        BankAccount.AccountReference accountSource = BankAccount.GenerateReference(((ATMContainer)this.screen.func_212873_a_()).getPlayer());
        ((ATMContainer)this.screen.func_212873_a_()).SetAccount(accountSource);
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageATMSetAccount(accountSource));
    }

    @Override
    public void preRender(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ATMScreen.GUI_TEXTURE);
        this.screen.func_238474_b_(matrix, this.screen.getGuiLeft() + 7, this.screen.getGuiTop() + 97, 7, 79, 162, 18);
        this.screen.getFont().func_238421_b_(matrix, this.getTooltip().getString(), (float)this.screen.getGuiLeft() + 8.0f, (float)this.screen.getGuiTop() + 6.0f, 0x404040);
    }

    @Override
    public void postRender(MatrixStack matrix, int mouseX, int mouseY) {
    }

    @Override
    public void tick() {
        this.buttonPersonalAccount.field_230693_o_ = this.selectedTeam != null;
    }

    @Override
    public void onClose() {
        SimpleSlot.SetActive(this.screen.func_212873_a_());
    }
}

