/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.containers.ATMContainer;
import io.github.lightman314.lightmanscurrency.containers.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageBankTransferPlayer;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageBankTransferTeam;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;

public class TransferTab
extends ATMTab
implements CoinValueInput.ICoinValueInput {
    CoinValueInput amountWidget;
    TextFieldWidget playerInput;
    TeamSelectWidget teamSelection;
    IconButton buttonToggleMode;
    Button buttonTransfer;
    UUID selectedTeam = null;
    boolean playerMode = true;

    public TransferTab(ATMScreen screen) {
        super(screen);
    }

    @Override
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_STORE_COINS;
    }

    @Override
    public ITextComponent getTooltip() {
        return new TranslationTextComponent("tooltip.lightmanscurrency.atm.transfer");
    }

    @Override
    public void init() {
        SimpleSlot.SetInactive(this.screen.func_212873_a_());
        ((ATMContainer)this.screen.func_212873_a_()).setMessage((ITextComponent)new StringTextComponent(""));
        this.amountWidget = this.screen.addTabListener(new CoinValueInput(this.screen.getGuiTop() - 69, (ITextComponent)new TranslationTextComponent("gui.lightmanscurrency.bank.transfertip"), CoinValue.EMPTY, this));
        this.amountWidget.allowFreeToggle = false;
        this.buttonToggleMode = this.screen.addRenderableTabWidget(new IconButton(this.screen.getGuiLeft() + this.screen.getXSize() - 30, this.screen.getGuiTop() + 10, this::ToggleMode, this.playerMode ? IconData.of((IItemProvider)Items.field_196184_dx) : IconData.of(ItemRenderUtil.getAlexHead()), new IconAndButtonUtil.ToggleTooltip(() -> this.playerMode, (ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.atm.transfer.mode.team"), (ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.atm.transfer.mode.player"))));
        this.playerInput = this.screen.addRenderableTabWidget(new TextFieldWidget(this.screen.getFont(), this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 50, this.screen.getXSize() - 20, 20, (ITextComponent)new StringTextComponent("")));
        this.playerInput.field_230694_p_ = this.playerMode;
        this.teamSelection = this.screen.addRenderableTabWidget(new TeamSelectWidget(this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 30, 2, TeamButton.Size.NORMAL, this::getTeamList, this::selectedTeam, this::SelectTeam));
        this.teamSelection.init(this.screen::addRenderableTabWidget, this.screen.getFont());
        this.teamSelection.setVisible(!this.playerMode);
        this.buttonTransfer = this.screen.addRenderableTabWidget(new Button(this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 72, this.screen.getXSize() - 20, 20, (ITextComponent)new TranslationTextComponent(this.playerMode ? "gui.button.bank.transfer.player" : "gui.button.bank.transfer.team"), this::PressTransfer));
        this.buttonTransfer.field_230693_o_ = false;
    }

    private List<Team> getTeamList() {
        ArrayList results = Lists.newArrayList();
        BankAccount.AccountReference source = ((ATMContainer)this.screen.func_212873_a_()).getAccountSource();
        Team blockTeam = null;
        if (source != null && source.accountType == BankAccount.AccountType.Team) {
            blockTeam = ClientTradingOffice.getTeam(source.id);
        }
        for (Team team : ClientTradingOffice.getTeamList()) {
            if (!team.hasBankAccount() || team == blockTeam) continue;
            results.add(team);
        }
        return results;
    }

    public Team selectedTeam() {
        if (this.selectedTeam != null) {
            return ClientTradingOffice.getTeam(this.selectedTeam);
        }
        return null;
    }

    public void SelectTeam(int teamIndex) {
        try {
            Team team = this.getTeamList().get(teamIndex);
            if (team.getID().equals(this.selectedTeam)) {
                return;
            }
            this.selectedTeam = team.getID();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void PressTransfer(Button button) {
        if (this.playerMode) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageBankTransferPlayer(this.playerInput.func_146179_b(), this.amountWidget.getCoinValue()));
            this.playerInput.func_146180_a("");
            this.amountWidget.setCoinValue(CoinValue.EMPTY);
        } else if (this.selectedTeam != null) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageBankTransferTeam(this.selectedTeam, this.amountWidget.getCoinValue()));
            this.amountWidget.setCoinValue(CoinValue.EMPTY);
        }
    }

    private void ToggleMode(Button button) {
        this.playerMode = !this.playerMode;
        this.buttonTransfer.func_238482_a_((ITextComponent)new TranslationTextComponent(this.playerMode ? "gui.button.bank.transfer.player" : "gui.button.bank.transfer.team"));
        this.teamSelection.setVisible(!this.playerMode);
        this.playerInput.field_230694_p_ = this.playerMode;
        this.buttonToggleMode.setIcon(this.playerMode ? IconData.of((IItemProvider)Items.field_196184_dx) : IconData.of(ItemRenderUtil.getAlexHead()));
    }

    @Override
    public void preRender(MatrixStack pose, int mouseX, int mouseY, float partialTicks) {
        this.amountWidget.func_230430_a_(pose, mouseX, mouseY, partialTicks);
        this.screen.getFont().func_238421_b_(pose, this.getTooltip().getString(), (float)this.screen.getGuiLeft() + 8.0f, (float)this.screen.getGuiTop() + 6.0f, 0x404040);
        TranslationTextComponent balance = ((ATMContainer)this.screen.func_212873_a_()).getAccount() == null ? new TranslationTextComponent("gui.lightmanscurrency.bank.null") : new TranslationTextComponent("gui.lightmanscurrency.bank.balance", new Object[]{((ATMContainer)this.screen.func_212873_a_()).getAccount().getCoinStorage().getString("0")});
        this.screen.getFont().func_238421_b_(pose, balance.getString(), (float)this.screen.getGuiLeft() + 8.0f, (float)(this.screen.getGuiTop() + 18), 0x404040);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ATMScreen.GUI_TEXTURE);
        this.screen.func_238474_b_(pose, this.screen.getGuiLeft() + 7, this.screen.getGuiTop() + 97, 7, 79, 162, 18);
        List lines = this.screen.getFont().func_238420_b_().func_238362_b_((ITextProperties)((ATMContainer)this.screen.func_212873_a_()).getLastMessage(), this.screen.getXSize() - 15, Style.field_240709_b_);
        for (int i = 0; i < lines.size(); ++i) {
            FontRenderer fontRenderer = this.screen.getFont();
            String string = ((ITextProperties)lines.get(i)).getString();
            float f = this.screen.getGuiLeft() + 7;
            int n = this.screen.getGuiTop() + 97;
            this.screen.getFont().getClass();
            fontRenderer.func_238421_b_(pose, string, f, (float)(n + 9 * i), 0x404040);
        }
    }

    @Override
    public void postRender(MatrixStack pose, int mouseX, int mouseY) {
        IconAndButtonUtil.renderButtonTooltips(pose, mouseX, mouseY, Lists.newArrayList((Object[])new Widget[]{this.buttonToggleMode}));
    }

    @Override
    public void tick() {
        this.amountWidget.tick();
        if (this.playerMode) {
            this.playerInput.func_146178_a();
            this.buttonTransfer.field_230693_o_ = !this.playerInput.func_146179_b().isEmpty() && this.amountWidget.getCoinValue().isValid();
        } else {
            Team team = this.selectedTeam();
            this.buttonTransfer.field_230693_o_ = team != null && team.hasBankAccount() && this.amountWidget.getCoinValue().isValid();
        }
    }

    @Override
    public void onClose() {
        SimpleSlot.SetActive(this.screen.func_212873_a_());
    }

    @Override
    public <T extends Button> T addCustomButton(T button) {
        return this.screen.addRenderableTabWidget(button);
    }

    @Override
    public <T extends IGuiEventListener> T addCustomListener(T listener) {
        return this.screen.addTabListener(listener);
    }

    @Override
    public int getWidth() {
        return this.screen.field_230708_k_;
    }

    @Override
    public FontRenderer getFont() {
        return this.screen.getFont();
    }

    @Override
    public void OnCoinValueChanged(CoinValueInput input) {
    }

    @Override
    public boolean blockInventoryClosing() {
        return this.playerMode;
    }
}

