/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.settings.core;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import io.github.lightman314.lightmanscurrency.client.gui.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.trader.settings.CoreTraderSettings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AllyTab
extends SettingsTab {
    public static final AllyTab INSTANCE = new AllyTab();
    TextFieldWidget nameInput;
    Button buttonAddAlly;
    Button buttonRemoveAlly;
    ScrollTextDisplay display;
    int scroll = 0;

    private AllyTab() {
    }

    @Override
    public int getColor() {
        return -1;
    }

    @Override
    public IconData getIcon() {
        return IconData.of(new ItemStack((IItemProvider)Items.field_196184_dx));
    }

    @Override
    public ITextComponent getTooltip() {
        return new TranslationTextComponent("tooltip.lightmanscurrency.settings.ally");
    }

    @Override
    public ImmutableList<String> requiredPermissions() {
        return ImmutableList.of((Object)"addRemoveAllies");
    }

    @Override
    public void initTab() {
        TraderSettingsScreen screen = this.getScreen();
        this.nameInput = screen.addRenderableTabWidget(new TextFieldWidget(screen.getFont(), screen.guiLeft() + 20, screen.guiTop() + 10, 160, 20, (ITextComponent)new StringTextComponent("")));
        this.nameInput.func_146203_f(16);
        this.buttonAddAlly = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 20, screen.guiTop() + 35, 74, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.allies.add"), this::AddAlly));
        int n = screen.guiLeft();
        ((Object)((Object)screen)).getClass();
        this.buttonRemoveAlly = screen.addRenderableTabWidget(new Button(n + 200 - 93, screen.guiTop() + 35, 74, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.allies.remove"), this::RemoveAlly));
        this.display = screen.addRenderableTabWidget(new ScrollTextDisplay(screen.guiLeft() + 5, screen.guiTop() + 60, 190, 135, screen.getFont(), (Supplier<List<ITextComponent>>)((Supplier)this::getAllyList)));
        this.display.setColumnCount(2);
    }

    @Override
    public void preRender(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void postRender(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
    }

    private List<ITextComponent> getAllyList() {
        ArrayList list = Lists.newArrayList();
        this.getSetting(CoreTraderSettings.class).getAllies().forEach(ally -> list.add(new StringTextComponent(ally.lastKnownName())));
        return list;
    }

    @Override
    public void tick() {
        this.nameInput.func_146178_a();
        this.buttonRemoveAlly.field_230693_o_ = !this.nameInput.func_146179_b().isEmpty();
        this.buttonAddAlly.field_230693_o_ = this.buttonRemoveAlly.field_230693_o_;
    }

    @Override
    public void closeTab() {
    }

    private void AddAlly(Button button) {
        CoreTraderSettings settings = this.getSetting(CoreTraderSettings.class);
        String allyName = this.nameInput.func_146179_b();
        CompoundNBT updateInfo = settings.addAlly(this.getPlayer(), allyName);
        settings.sendToServer(updateInfo);
        this.nameInput.func_146180_a("");
    }

    private void RemoveAlly(Button button) {
        CoreTraderSettings settings = this.getSetting(CoreTraderSettings.class);
        String allyName = this.nameInput.func_146179_b();
        CompoundNBT updateInfo = settings.removeAlly(this.getPlayer(), allyName);
        settings.sendToServer(updateInfo);
        this.nameInput.func_146180_a("");
    }
}

