/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.settings.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import io.github.lightman314.lightmanscurrency.client.gui.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.CoreTraderSettings;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class MainTab
extends SettingsTab {
    public static final MainTab INSTANCE = new MainTab();
    TextFieldWidget nameInput;
    Button buttonSetName;
    Button buttonResetName;
    PlainButton buttonToggleBankLink;
    IconButton buttonToggleCreative;
    Button buttonAddTrade;
    Button buttonRemoveTrade;
    Button buttonSavePersistentTrader;

    private MainTab() {
    }

    @Override
    public ImmutableList<String> requiredPermissions() {
        return ImmutableList.of((Object)"editSettings");
    }

    @Override
    public void initTab() {
        TraderSettingsScreen screen = this.getScreen();
        CoreTraderSettings coreSettings = this.getSetting(CoreTraderSettings.class);
        this.nameInput = screen.addRenderableTabWidget(new TextFieldWidget(screen.getFont(), screen.guiLeft() + 20, screen.guiTop() + 25, 160, 20, (ITextComponent)new StringTextComponent("")));
        this.nameInput.func_146203_f(32);
        this.nameInput.func_146180_a(coreSettings.getCustomName());
        this.buttonSetName = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 20, screen.guiTop() + 50, 74, 20, (ITextComponent)new TranslationTextComponent("gui.lightmanscurrency.changename"), this::SetName));
        int n = screen.guiLeft();
        ((Object)((Object)screen)).getClass();
        this.buttonResetName = screen.addRenderableTabWidget(new Button(n + 200 - 93, screen.guiTop() + 50, 74, 20, (ITextComponent)new TranslationTextComponent("gui.lightmanscurrency.resetname"), this::ResetName));
        this.buttonToggleCreative = screen.addRenderableTabWidget(IconAndButtonUtil.creativeToggleButton(screen.guiLeft() + 176, screen.guiTop() + 4, this::ToggleCreative, () -> this.getScreen().getSetting(CoreTraderSettings.class).isCreative()));
        this.buttonAddTrade = screen.addRenderableTabWidget(new PlainButton(screen.guiLeft() + 166, screen.guiTop() + 4, 10, 10, this::AddTrade, TraderSettingsScreen.GUI_TEXTURE, 0, 200));
        this.buttonRemoveTrade = screen.addRenderableTabWidget(new PlainButton(screen.guiLeft() + 166, screen.guiTop() + 14, 10, 10, this::RemoveTrade, TraderSettingsScreen.GUI_TEXTURE, 0, 220));
        this.buttonToggleBankLink = screen.addRenderableTabWidget(new PlainButton(screen.guiLeft() + 20, screen.guiTop() + 100, 10, 10, this::ToggleBankLink, TraderSettingsScreen.GUI_TEXTURE, 10, coreSettings.isBankAccountLinked() ? 200 : 220));
        this.buttonToggleBankLink.field_230694_p_ = screen.hasPermission("bankLink");
        if (this.getScreen().getTrader() instanceof UniversalTraderData) {
            int n2 = screen.guiLeft() + 10;
            int n3 = screen.guiTop();
            ((Object)((Object)screen)).getClass();
            this.buttonSavePersistentTrader = screen.addRenderableTabWidget(new IconButton(n2, n3 + 200 - 30, this::SavePersistentTraderData, IconAndButtonUtil.ICON_PERSISTENT_DATA, IconAndButtonUtil.TOOLTIP_PERSISTENT_DATA));
            this.buttonSavePersistentTrader.field_230694_p_ = TradingOffice.isAdminPlayer(this.getPlayer());
        }
        this.tick();
    }

    @Override
    public void preRender(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        TraderSettingsScreen screen = this.getScreen();
        screen.getFont().func_238421_b_(matrix, new TranslationTextComponent("gui.lightmanscurrency.customname").getString(), (float)(screen.guiLeft() + 20), (float)(screen.guiTop() + 15), 0x404040);
        if (screen.hasPermission("bankLink")) {
            this.getFont().func_238421_b_(matrix, new TranslationTextComponent("gui.lightmanscurrency.settings.banklink").getString(), (float)(screen.guiLeft() + 30), (float)(screen.guiTop() + 101), 0x404040);
        }
    }

    @Override
    public void postRender(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        TraderSettingsScreen screen = this.getScreen();
        IconAndButtonUtil.renderButtonTooltips(matrix, mouseX, mouseY, Lists.newArrayList((Object[])new Widget[]{this.buttonToggleCreative, this.buttonSavePersistentTrader}));
        if (this.buttonAddTrade.func_231047_b_((double)mouseX, (double)mouseY)) {
            screen.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.trader.creative.addTrade"), mouseX, mouseY);
        } else if (this.buttonRemoveTrade.func_231047_b_((double)mouseX, (double)mouseY)) {
            screen.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.trader.creative.removeTrade"), mouseX, mouseY);
        }
    }

    @Override
    public void tick() {
        boolean canLinkAccount;
        boolean canChangeName = this.getScreen().hasPermission("changeName");
        this.nameInput.func_146184_c(canChangeName);
        this.nameInput.func_146178_a();
        CoreTraderSettings coreSettings = this.getSetting(CoreTraderSettings.class);
        this.buttonSetName.field_230693_o_ = !this.nameInput.func_146179_b().contentEquals(coreSettings.getCustomName());
        this.buttonSetName.field_230694_p_ = canChangeName;
        this.buttonResetName.field_230693_o_ = coreSettings.hasCustomName();
        this.buttonResetName.field_230694_p_ = canChangeName;
        this.buttonToggleCreative.field_230694_p_ = TradingOffice.isAdminPlayer(this.getScreen().getPlayer());
        if (this.buttonToggleCreative.field_230694_p_) {
            IconAndButtonUtil.updateCreativeToggleButton(this.buttonToggleCreative, coreSettings.isCreative());
            if (coreSettings.isCreative()) {
                ITrader trader = this.getScreen().getTrader();
                this.buttonAddTrade.field_230694_p_ = true;
                this.buttonAddTrade.field_230693_o_ = trader.getTradeCount() < trader.getTradeCountLimit();
                this.buttonRemoveTrade.field_230694_p_ = true;
                this.buttonRemoveTrade.field_230693_o_ = trader.getTradeCount() > 1;
            } else {
                this.buttonAddTrade.field_230694_p_ = false;
                this.buttonRemoveTrade.field_230694_p_ = false;
            }
        } else {
            this.buttonAddTrade.field_230694_p_ = false;
            this.buttonRemoveTrade.field_230694_p_ = false;
        }
        this.buttonToggleBankLink.field_230694_p_ = canLinkAccount = this.getScreen().hasPermission("bankLink");
        if (canLinkAccount) {
            this.buttonToggleBankLink.setResource(TraderSettingsScreen.GUI_TEXTURE, 10, coreSettings.isBankAccountLinked() ? 200 : 220);
            boolean bl = this.buttonToggleBankLink.field_230693_o_ = coreSettings.canLinkBankAccount() || coreSettings.isBankAccountLinked();
        }
        if (this.buttonSavePersistentTrader != null) {
            this.buttonSavePersistentTrader.field_230694_p_ = TradingOffice.isAdminPlayer(this.getPlayer());
        }
    }

    @Override
    public void closeTab() {
    }

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    public IconData getIcon() {
        return IconData.of(new ItemStack((IItemProvider)ModItems.TRADING_CORE));
    }

    @Override
    public ITextComponent getTooltip() {
        return new TranslationTextComponent("tooltip.lightmanscurrency.settings.name");
    }

    private void SetName(Button button) {
        CoreTraderSettings coreSettings = this.getSetting(CoreTraderSettings.class);
        String customName = coreSettings.getCustomName();
        if (!customName.contentEquals(this.nameInput.func_146179_b())) {
            CompoundNBT updateInfo = coreSettings.setCustomName(this.getPlayer(), this.nameInput.func_146179_b());
            coreSettings.sendToServer(updateInfo);
        }
    }

    private void ResetName(Button button) {
        this.nameInput.func_146180_a("");
        this.SetName(button);
    }

    private void ToggleCreative(Button button) {
        CoreTraderSettings coreSettings = this.getScreen().getSetting(CoreTraderSettings.class);
        CompoundNBT updateInfo = coreSettings.toggleCreative(this.getPlayer());
        coreSettings.sendToServer(updateInfo);
    }

    private void ToggleBankLink(Button button) {
        CoreTraderSettings coreSettings = this.getSetting(CoreTraderSettings.class);
        CompoundNBT updateInfo = coreSettings.toggleBankAccountLink(this.getPlayer());
        coreSettings.sendToServer(updateInfo);
    }

    private void AddTrade(Button button) {
        this.getScreen().getTrader().requestAddOrRemoveTrade(true);
    }

    private void RemoveTrade(Button button) {
        this.getScreen().getTrader().requestAddOrRemoveTrade(false);
    }

    private void SavePersistentTraderData(Button button) {
        try {
            ITrader t = this.getScreen().getTrader();
            if (t instanceof UniversalTraderData) {
                UniversalTraderData trader = (UniversalTraderData)t;
                JsonObject result = trader.saveToJson(new JsonObject());
                String resultString = FileUtil.GSON.toJson((JsonElement)result);
                LightmansCurrency.LogInfo("Copied persistent trader json to clipboard.\n" + resultString);
                this.getScreen().getMinecraft().field_195559_v.func_197960_a(resultString);
                TranslationTextComponent message = new TranslationTextComponent("lightmanscurrency.chat.persistenttrader");
                message.func_230530_a_(message.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, resultString)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("tooltip.lightmanscurrency.persistenttrader.copyagain", new Object[]{trader.getName()}))));
                this.getScreen().getMinecraft().field_71439_g.func_146105_b((ITextComponent)message, false);
            }
        }
        catch (Throwable e) {
            LightmansCurrency.LogError("Error saving trader to Json.", e);
        }
    }
}

