/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.team;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageEditTeam;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TeamMemberEditTab
extends TeamTab {
    public static final TeamMemberEditTab INSTANCE = new TeamMemberEditTab();
    ScrollTextDisplay memberDisplay;
    TextFieldWidget memberNameInput;
    Button buttonAddMember;
    Button buttonPromoteMember;
    Button buttonRemoveMember;

    private TeamMemberEditTab() {
    }

    @Override
    public IconData getIcon() {
        return IconData.of(ItemRenderUtil.getAlexHead());
    }

    @Override
    public ITextComponent getTooltip() {
        return new TranslationTextComponent("tooltip.lightmanscurrency.team.member_edit");
    }

    @Override
    public boolean allowViewing(PlayerEntity player, Team team) {
        return team != null;
    }

    @Override
    public void initTab() {
        TeamManagerScreen screen = this.getScreen();
        this.memberNameInput = screen.addRenderableTabWidget(new TextFieldWidget(this.getFont(), screen.guiLeft() + 11, screen.guiTop() + 9, 178, 20, (ITextComponent)new StringTextComponent("")));
        this.memberNameInput.func_146203_f(16);
        this.buttonAddMember = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 10, screen.guiTop() + 30, 60, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.team.member.add"), this::addMember));
        this.buttonPromoteMember = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 70, screen.guiTop() + 30, 60, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.team.member.promote"), this::addAdmin));
        this.buttonRemoveMember = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 130, screen.guiTop() + 30, 60, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.team.member.remove"), this::removeMember));
        this.buttonRemoveMember.field_230693_o_ = false;
        this.buttonPromoteMember.field_230693_o_ = false;
        this.buttonAddMember.field_230693_o_ = false;
        int n = screen.guiLeft() + 10;
        int n2 = screen.guiTop() + 55;
        ((Object)((Object)screen)).getClass();
        ((Object)((Object)screen)).getClass();
        this.memberDisplay = screen.addRenderableTabWidget(new ScrollTextDisplay(n, n2, 200 - 20, 200 - 65, this.getFont(), (Supplier<List<ITextComponent>>)((Supplier)this::getMemberList)));
        this.memberDisplay.setColumnCount(2);
    }

    private List<ITextComponent> getMemberList() {
        ArrayList list = Lists.newArrayList();
        Team team = this.getActiveTeam();
        if (team != null) {
            team.getAdmins().forEach(admin -> list.add(new StringTextComponent(admin.lastKnownName()).func_240699_a_(TextFormatting.DARK_GREEN)));
            team.getMembers().forEach(member -> list.add(new StringTextComponent(member.lastKnownName())));
        }
        return list;
    }

    @Override
    public void preRender(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void postRender(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void tick() {
        if (this.getActiveTeam().isAdmin(this.getPlayer())) {
            this.buttonRemoveMember.field_230693_o_ = !this.memberNameInput.func_146179_b().isEmpty();
            this.buttonPromoteMember.field_230693_o_ = this.buttonRemoveMember.field_230693_o_;
            this.buttonAddMember.field_230693_o_ = this.buttonRemoveMember.field_230693_o_;
        } else {
            this.buttonPromoteMember.field_230693_o_ = false;
            this.buttonAddMember.field_230693_o_ = false;
            this.buttonRemoveMember.field_230693_o_ = PlayerReference.of(this.getPlayer()).is(this.memberNameInput.func_146179_b());
        }
    }

    @Override
    public void closeTab() {
    }

    private void addMember(Button button) {
        if (this.memberNameInput.func_146179_b().isEmpty() || this.getActiveTeam() == null) {
            return;
        }
        Team team = this.getActiveTeam();
        team.changeAddMember(this.getPlayer(), this.memberNameInput.func_146179_b());
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageEditTeam(team.getID(), this.memberNameInput.func_146179_b(), "MEMBER"));
        this.memberNameInput.func_146180_a("");
    }

    private void addAdmin(Button button) {
        if (this.memberNameInput.func_146179_b().isEmpty() || this.getActiveTeam() == null) {
            return;
        }
        Team team = this.getActiveTeam();
        team.changeAddAdmin(this.getPlayer(), this.memberNameInput.func_146179_b());
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageEditTeam(team.getID(), this.memberNameInput.func_146179_b(), "ADMIN"));
        this.memberNameInput.func_146180_a("");
    }

    private void removeMember(Button button) {
        if (this.memberNameInput.func_146179_b().isEmpty() || this.getActiveTeam() == null) {
            return;
        }
        Team team = this.getActiveTeam();
        team.changeRemoveMember(this.getPlayer(), this.memberNameInput.func_146179_b());
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageEditTeam(team.getID(), this.memberNameInput.func_146179_b(), "REMOVE"));
        this.memberNameInput.func_146180_a("");
    }
}

