/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.team;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TeamMemberListTab
extends TeamTab {
    public static final TeamMemberListTab INSTANCE = new TeamMemberListTab();
    ScrollTextDisplay memberDisplay;

    private TeamMemberListTab() {
    }

    @Override
    public IconData getIcon() {
        return IconData.of((IItemProvider)Items.field_196184_dx);
    }

    @Override
    public ITextComponent getTooltip() {
        return new TranslationTextComponent("tooltip.lightmanscurrency.team.members");
    }

    @Override
    public boolean allowViewing(PlayerEntity player, Team team) {
        return team != null;
    }

    @Override
    public void initTab() {
        TeamManagerScreen screen = this.getScreen();
        int n = screen.guiLeft() + 10;
        int n2 = screen.guiTop() + 10;
        ((Object)((Object)screen)).getClass();
        ((Object)((Object)screen)).getClass();
        this.memberDisplay = screen.addRenderableTabWidget(new ScrollTextDisplay(n, n2, 200 - 20, 200 - 20, this.getFont(), (Supplier<List<ITextComponent>>)((Supplier)this::getMemberList)));
        this.memberDisplay.setColumnCount(2);
    }

    private List<ITextComponent> getMemberList() {
        ArrayList list = Lists.newArrayList();
        Team team = this.getActiveTeam();
        if (team != null) {
            list.add(new StringTextComponent(team.getOwner().lastKnownName()).func_240699_a_(TextFormatting.GREEN));
            team.getAdmins().forEach(admin -> list.add(new StringTextComponent(admin.lastKnownName()).func_240699_a_(TextFormatting.DARK_GREEN)));
            team.getMembers().forEach(member -> list.add(new StringTextComponent(member.lastKnownName())));
        }
        return list;
    }

    @Override
    public void preRender(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void postRender(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void tick() {
    }

    @Override
    public void closeTab() {
    }
}

