/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.team;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageRenameTeam;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TeamNameTab
extends TeamTab {
    public static final TeamNameTab INSTANCE = new TeamNameTab();
    TextFieldWidget nameInput;
    Button buttonChangeName;

    private TeamNameTab() {
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.changename"));
    }

    @Override
    public ITextComponent getTooltip() {
        return new TranslationTextComponent("tooltip.lightmanscurrency.team.name");
    }

    @Override
    public boolean allowViewing(PlayerEntity player, Team team) {
        return team != null && team.isAdmin(player);
    }

    @Override
    public void initTab() {
        TeamManagerScreen screen = this.getScreen();
        this.nameInput = screen.addRenderableTabWidget(new TextFieldWidget(this.getFont(), screen.guiLeft() + 20, screen.guiTop() + 20, 160, 20, (ITextComponent)new StringTextComponent("")));
        this.nameInput.func_146203_f(32);
        this.nameInput.func_146180_a(this.getActiveTeam().getName());
        this.buttonChangeName = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 20, screen.guiTop() + 45, 160, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.team.rename"), this::changeName));
        this.buttonChangeName.field_230693_o_ = false;
    }

    @Override
    public void preRender(MatrixStack pose, int mouseX, int mouseY, float partialTicks) {
        TeamManagerScreen screen = this.getScreen();
        String currentName = "NULL";
        if (this.getActiveTeam() != null) {
            currentName = this.getActiveTeam().getName();
        }
        this.getFont().func_238421_b_(pose, new TranslationTextComponent("gui.lightmanscurrency.team.name.current", new Object[]{currentName}).getString(), (float)(screen.guiLeft() + 20), (float)(screen.guiTop() + 10), 0x404040);
    }

    @Override
    public void postRender(MatrixStack pose, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void tick() {
        this.nameInput.func_146178_a();
        this.buttonChangeName.field_230693_o_ = !this.nameInput.func_146179_b().isEmpty() && !this.nameInput.func_146179_b().contentEquals(this.getActiveTeam().getName());
    }

    @Override
    public void closeTab() {
    }

    private void changeName(Button button) {
        if (this.nameInput.func_146179_b().isEmpty() || this.getActiveTeam() == null) {
            return;
        }
        this.getActiveTeam().changeName(this.getPlayer(), this.nameInput.func_146179_b());
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageRenameTeam(this.getActiveTeam().getID(), this.nameInput.func_146179_b()));
    }
}

