/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.team;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageDisbandTeam;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageEditTeam;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TeamOwnerTab
extends TeamTab {
    public static final TeamOwnerTab INSTANCE = new TeamOwnerTab();
    TextFieldWidget newOwnerName;
    Button buttonChangeOwner;
    Button buttonDisbandTeam;

    private TeamOwnerTab() {
    }

    @Override
    public IconData getIcon() {
        return IconData.of((IItemProvider)Items.field_151099_bA);
    }

    @Override
    public ITextComponent getTooltip() {
        return new TranslationTextComponent("tooltip.lightmanscurrency.team.owner");
    }

    @Override
    public boolean allowViewing(PlayerEntity player, Team team) {
        return team != null && team.isOwner(player);
    }

    @Override
    public void initTab() {
        if (this.getActiveTeam() == null) {
            this.getScreen().changeTab(0);
            return;
        }
        TeamManagerScreen screen = this.getScreen();
        this.newOwnerName = screen.addRenderableTabWidget(new TextFieldWidget(this.getFont(), screen.guiLeft() + 20, screen.guiTop() + 20, 160, 20, (ITextComponent)new StringTextComponent("")));
        this.newOwnerName.func_146203_f(16);
        this.buttonChangeOwner = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 20, screen.guiTop() + 45, 160, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.set_owner"), this::setNewOwner));
        this.buttonChangeOwner.field_230693_o_ = false;
        this.buttonDisbandTeam = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 20, screen.guiTop() + 160, 160, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.team.disband"), this::disbandTeam));
    }

    @Override
    public void preRender(MatrixStack pose, int mouseX, int mouseY, float partialTicks) {
        if (this.getActiveTeam() == null) {
            return;
        }
        TeamManagerScreen screen = this.getScreen();
        this.getFont().func_238421_b_(pose, new TranslationTextComponent("gui.button.lightmanscurrency.team.owner", new Object[]{this.getActiveTeam().getOwner().lastKnownName()}).getString(), (float)(screen.guiLeft() + 20), (float)(screen.guiTop() + 10), 0x404040);
    }

    @Override
    public void postRender(MatrixStack pose, int mouseX, int mouseY, float partialTicks) {
        if (this.buttonChangeOwner.func_231047_b_((double)mouseX, (double)mouseY) || this.buttonDisbandTeam.func_231047_b_((double)mouseX, (double)mouseY)) {
            this.getScreen().func_238652_a_(pose, (ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.warning").func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.YELLOW}), mouseX, mouseY);
        }
    }

    @Override
    public void tick() {
        this.newOwnerName.func_146178_a();
        this.buttonChangeOwner.field_230693_o_ = !this.newOwnerName.func_146179_b().isEmpty();
    }

    @Override
    public void closeTab() {
    }

    private void setNewOwner(Button button) {
        if (this.newOwnerName.func_146179_b().isEmpty() || this.getActiveTeam() == null) {
            return;
        }
        Team team = this.getActiveTeam();
        team.changeOwner(this.getPlayer(), this.newOwnerName.func_146179_b());
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageEditTeam(team.getID(), this.newOwnerName.func_146179_b(), "OWNER"));
        this.newOwnerName.func_146180_a("");
    }

    private void disbandTeam(Button button) {
        if (this.getActiveTeam() == null) {
            return;
        }
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageDisbandTeam(this.getActiveTeam().getID()));
    }
}

