/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.team;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageCreateTeam;
import java.util.List;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TeamSelectionTab
extends TeamTab {
    public static final TeamSelectionTab INSTANCE = new TeamSelectionTab();
    TeamSelectWidget teamSelection;
    List<Team> teamList = Lists.newArrayList();
    TextFieldWidget newTeamName;
    Button buttonCreateTeam;

    private TeamSelectionTab() {
    }

    @Override
    public IconData getIcon() {
        return IconData.of((IItemProvider)Items.field_151121_aF);
    }

    @Override
    public ITextComponent getTooltip() {
        return new TranslationTextComponent("tooltip.lightmanscurrency.team.selection");
    }

    @Override
    public boolean allowViewing(PlayerEntity player, Team team) {
        return true;
    }

    @Override
    public void initTab() {
        TeamManagerScreen screen = this.getScreen();
        this.refreshTeamList();
        this.teamSelection = screen.addRenderableTabWidget(new TeamSelectWidget(screen.guiLeft() + 10, screen.guiTop() + 20, 5, () -> this.teamList, () -> this.getActiveTeam(), this::selectTeamButton));
        this.teamSelection.init(screen::addRenderableTabWidget, this.getFont());
        this.newTeamName = screen.addRenderableTabWidget(new TextFieldWidget(this.getFont(), screen.guiLeft() + 20, screen.guiTop() + 140, 160, 20, (ITextComponent)new StringTextComponent("")));
        this.newTeamName.func_146203_f(32);
        this.buttonCreateTeam = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 120, screen.guiTop() + 165, 60, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.team.create"), this::createTeam));
        this.buttonCreateTeam.field_230693_o_ = false;
    }

    private Team getTeam(int teamIndex) {
        if (teamIndex < this.teamList.size()) {
            return this.teamList.get(teamIndex);
        }
        return null;
    }

    private void refreshTeamList() {
        this.teamList = Lists.newArrayList();
        List<Team> allTeams = ClientTradingOffice.getTeamList();
        allTeams.forEach(team -> {
            if (team.isMember(this.getPlayer())) {
                this.teamList.add((Team)team);
            }
        });
        this.teamList.sort(Team.sorterFor(this.getPlayer()));
    }

    @Override
    public void preRender(MatrixStack pose, int mouseX, int mouseY, float partialTicks) {
        TeamManagerScreen screen = this.getScreen();
        this.getFont().func_238421_b_(pose, new TranslationTextComponent("gui.lightmanscurrency.team.select").getString(), (float)(screen.guiLeft() + 20), (float)(screen.guiTop() + 10), 0x404040);
        this.getFont().func_238421_b_(pose, new TranslationTextComponent("gui.lightmanscurrency.team.create").getString(), (float)(screen.guiLeft() + 20), (float)(screen.guiTop() + 130), 0x404040);
    }

    @Override
    public void postRender(MatrixStack pose, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void tick() {
        this.refreshTeamList();
        this.buttonCreateTeam.field_230693_o_ = !this.newTeamName.func_146179_b().isEmpty();
    }

    @Override
    public void closeTab() {
    }

    private void selectTeamButton(int teamIndex) {
        Team team = this.getTeam(teamIndex);
        if (team != null) {
            if (this.getScreen().getActiveTeam() == team) {
                this.getScreen().setActiveTeam(null);
            } else {
                this.getScreen().setActiveTeam(team.getID());
            }
        }
    }

    private void createTeam(Button button) {
        if (this.newTeamName.func_146179_b().isEmpty()) {
            return;
        }
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCreateTeam(this.newTeamName.func_146179_b()));
        this.newTeamName.func_146180_a("");
    }
}

