/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageBankInteraction;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class BankAccountWidget
implements CoinValueInput.ICoinValueInput {
    public static final int MIN_WIDTH = 100;
    public static final int HEIGHT = 109;
    public static final int BUTTON_WIDTH = 70;
    private final IBankAccountWidget parent;
    private CoinValueInput amountSelection;
    Button buttonDeposit;
    Button buttonWithdraw;
    private final int y;
    private final int spacing;
    public boolean allowEmptyDeposits = true;

    public BankAccountWidget(int y, IBankAccountWidget parent) {
        this(y, parent, 0);
    }

    public BankAccountWidget(int y, IBankAccountWidget parent, int spacing) {
        this.parent = parent;
        this.y = y;
        this.spacing = spacing;
        this.amountSelection = this.parent.addCustomListener(new CoinValueInput(this.y, (ITextComponent)new TranslationTextComponent("gui.lightmanscurrency.bank.amounttip"), CoinValue.EMPTY, this));
        this.amountSelection.allowFreeToggle = false;
        int screenMiddle = this.parent.getScreen().field_230708_k_ / 2;
        this.buttonDeposit = this.parent.addCustomWidget(new Button(screenMiddle - 5 - 70, this.y + 69 + 5 + spacing, 70, 20, (ITextComponent)new TranslationTextComponent("gui.button.bank.deposit"), this::OnDeposit));
        this.buttonWithdraw = this.parent.addCustomWidget(new Button(screenMiddle + 5, this.y + 69 + 5 + spacing, 70, 20, (ITextComponent)new TranslationTextComponent("gui.button.bank.withdraw"), this::OnWithdraw));
        this.buttonWithdraw.field_230693_o_ = false;
        this.buttonDeposit.field_230693_o_ = false;
    }

    public void renderCoinValueWidget(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.amountSelection.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
    }

    public void renderInfo(MatrixStack matrix) {
        this.renderInfo(matrix, 0);
    }

    public void renderInfo(MatrixStack matrix, int yOffset) {
        int screenMiddle = this.parent.getScreen().field_230708_k_ / 2;
        FontRenderer font = this.parent.getFont();
        TranslationTextComponent balanceComponent = this.parent.getAccount() == null ? new TranslationTextComponent("gui.lightmanscurrency.bank.null") : new TranslationTextComponent("gui.lightmanscurrency.bank.balance", new Object[]{this.parent.getAccount().getCoinStorage().getString("0")});
        int offset = font.func_78256_a(balanceComponent.getString()) / 2;
        this.parent.getFont().func_238421_b_(matrix, balanceComponent.getString(), (float)(screenMiddle - offset), (float)(this.y + 69 + 30 + this.spacing + yOffset), 0x404040);
    }

    public void tick() {
        this.amountSelection.tick();
        if (this.parent.getAccount() == null) {
            this.buttonWithdraw.field_230693_o_ = false;
            this.buttonDeposit.field_230693_o_ = false;
        } else {
            this.buttonDeposit.field_230693_o_ = MoneyUtil.getValue(this.parent.getCoinAccess()) > 0L && (this.allowEmptyDeposits || this.amountSelection.getCoinValue().getRawValue() > 0L);
            this.buttonWithdraw.field_230693_o_ = this.amountSelection.getCoinValue().getRawValue() > 0L;
        }
    }

    private void OnDeposit(Button button) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageBankInteraction(true, this.amountSelection.getCoinValue()));
        this.amountSelection.setCoinValue(CoinValue.EMPTY);
    }

    private void OnWithdraw(Button button) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageBankInteraction(false, this.amountSelection.getCoinValue()));
        this.amountSelection.setCoinValue(CoinValue.EMPTY);
    }

    @Override
    public <T extends Button> T addCustomButton(T button) {
        return this.parent.addCustomWidget(button);
    }

    @Override
    public <T extends IGuiEventListener> T addCustomListener(T listener) {
        return this.parent.addCustomListener(listener);
    }

    @Override
    public FontRenderer getFont() {
        return this.parent.getFont();
    }

    @Override
    public void OnCoinValueChanged(CoinValueInput input) {
    }

    @Override
    public int getWidth() {
        return this.parent.getWidth();
    }

    public static interface IBankAccountWidget {
        public <T extends Button> T addCustomWidget(T var1);

        public <T extends IGuiEventListener> T addCustomListener(T var1);

        public FontRenderer getFont();

        public Screen getScreen();

        public int getWidth();

        public BankAccount getAccount();

        public IInventory getCoinAccess();
    }
}

