/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.money.CoinData;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class CoinValueInput
extends Widget {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/coinvalueinput.png");
    public static final int HEIGHT = 69;
    public static final int DISPLAY_WIDTH = 176;
    private final int leftOffset;
    private final ICoinValueInput parent;
    private final CoinValue.ValueType inputType;
    private CoinValue coinValue;
    Button toggleFree;
    private List<Button> increaseButtons;
    private List<Button> decreaseButtons;
    private ITextComponent title;
    String lastInput = "";
    TextFieldWidget valueInput;
    String prefix;
    String postfix;
    public boolean allowFreeToggle = true;

    public void setTitle(ITextComponent title) {
        this.title = title;
    }

    public CoinValueInput(int y, ITextComponent title, CoinValue startingValue, @Nonnull ICoinValueInput parent) {
        super(0, y, CoinValueInput.calculateWidth(), 69, (ITextComponent)new StringTextComponent(""));
        this.inputType = (CoinValue.ValueType)((Object)Config.SERVER.coinValueInputType.get());
        this.title = title;
        this.leftOffset = this.field_230688_j_ == parent.getWidth() ? 0 : (parent.getWidth() - this.field_230688_j_) / 2;
        this.parent = parent;
        this.coinValue = startingValue.copy();
        if (this.inputType == CoinValue.ValueType.VALUE) {
            this.setPrefixAndPostfix();
        }
        this.init();
    }

    private void setPrefixAndPostfix() {
        String format = (String)Config.SERVER.valueFormat.get();
        String[] splitFormat = format.replace("{value}", "`").split("`", 2);
        if (splitFormat.length < 2) {
            if (format.startsWith("{value}")) {
                this.prefix = "";
                this.postfix = splitFormat[0];
            } else {
                this.prefix = splitFormat[0];
                this.postfix = "";
            }
        } else {
            this.prefix = splitFormat[0];
            this.postfix = splitFormat[1];
        }
    }

    private void init() {
        this.toggleFree = this.parent.addCustomButton(new PlainButton(this.leftOffset + this.field_230688_j_ - 14, this.field_230691_m_ + 4, 10, 10, this::ToggleFree, GUI_TEXTURE, 40, 69));
        this.increaseButtons = new ArrayList<Button>();
        this.decreaseButtons = new ArrayList<Button>();
        if (this.inputType == CoinValue.ValueType.DEFAULT) {
            int buttonCount = MoneyUtil.getAllData("main").size();
            for (int x = 0; x < buttonCount; ++x) {
                this.increaseButtons.add(this.parent.addCustomButton(new PlainButton(this.leftOffset + 10 + x * 30, this.field_230691_m_ + 15, 20, 10, this::IncreaseButtonHit, GUI_TEXTURE, 0, 69)));
                PlainButton newButton = this.parent.addCustomButton(new PlainButton(this.leftOffset + 10 + x * 30, this.field_230691_m_ + 53, 20, 10, this::DecreaseButtonHit, GUI_TEXTURE, 20, 69));
                newButton.field_230693_o_ = false;
                this.decreaseButtons.add(newButton);
            }
        } else {
            int postfixWidth;
            int prefixWidth = this.parent.getFont().func_78256_a(this.prefix);
            if (prefixWidth > 0) {
                prefixWidth += 2;
            }
            if ((postfixWidth = this.parent.getFont().func_78256_a(this.prefix)) > 0) {
                postfixWidth += 2;
            }
            this.valueInput = this.parent.addCustomListener(new TextFieldWidget(this.parent.getFont(), this.leftOffset + 10 + prefixWidth, this.field_230691_m_ + 20, 156 - prefixWidth - postfixWidth, 20, (ITextComponent)new StringTextComponent("")));
        }
        this.tick();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.increaseButtons.forEach(button -> {
            button.field_230694_p_ = this.field_230694_p_;
        });
        this.decreaseButtons.forEach(button -> {
            button.field_230694_p_ = this.field_230694_p_;
        });
        boolean bl = this.toggleFree.field_230694_p_ = this.allowFreeToggle && this.field_230694_p_;
        if (!this.field_230694_p_) {
            return;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_TEXTURE);
        int startX = this.field_230690_l_ + this.leftOffset;
        int startY = this.field_230691_m_;
        List<CoinData> coinData = MoneyUtil.getAllData("main");
        int buttonCount = coinData.size();
        if (this.inputType == CoinValue.ValueType.DEFAULT) {
            int x;
            this.func_238474_b_(matrixStack, startX, startY, 0, 0, 10, 69);
            for (x = 0; x < buttonCount; ++x) {
                this.func_238474_b_(matrixStack, startX + 10 + x * 30, startY, 10, 0, 20, 69);
                if (x >= buttonCount - 1) continue;
                this.func_238474_b_(matrixStack, startX + 30 + x * 30, startY, 30, 0, 10, 69);
            }
            this.func_238474_b_(matrixStack, startX + 30 + (buttonCount - 1) * 30, startY, 40, 0, 10, 69);
            for (x = 0; x < buttonCount; ++x) {
                ItemRenderUtil.drawItemStack((AbstractGui)this, this.parent.getFont(), new ItemStack((IItemProvider)coinData.get((int)x).coinItem), startX + x * 30 + 12, startY + 26);
                String countString = String.valueOf(this.coinValue.getEntry(coinData.get((int)x).coinItem));
                int width = this.parent.getFont().func_78256_a(countString);
                this.parent.getFont().func_238421_b_(matrixStack, countString, (float)(startX + x * 30 + 20 - width / 2), (float)(startY + 43), 0x404040);
            }
        } else {
            int xPos;
            int xSize;
            this.func_238474_b_(matrixStack, startX, startY, 0, 0, 10, 69);
            for (xPos = startX + 10; xPos < startX + 176 - 10; xPos += xSize) {
                xSize = Math.min(30, startX + 176 - 10 - xPos);
                this.func_238474_b_(matrixStack, xPos, startY, 10, 0, xSize, 69);
            }
            this.func_238474_b_(matrixStack, xPos, startY, 40, 0, 10, 69);
            this.parent.getFont().func_238421_b_(matrixStack, this.prefix, (float)(startX + 10), (float)(startY + 26), 0xFFFFFF);
            int postfixWidth = this.parent.getFont().func_78256_a(this.postfix);
            this.parent.getFont().func_238421_b_(matrixStack, this.postfix, (float)(startX + 176 - 10 - postfixWidth), (float)(startY + 26), 0xFFFFFF);
            this.valueInput.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        this.parent.getFont().func_238421_b_(matrixStack, this.title.getString(), (float)startX + 8.0f, (float)startY + 5.0f, 0x404040);
        String value = this.coinValue.getString();
        int priceWidth = this.parent.getFont().func_78256_a(value);
        int freeButtonOffset = this.allowFreeToggle ? 15 : 5;
        this.parent.getFont().func_238421_b_(matrixStack, value, (float)(startX + this.field_230688_j_ - freeButtonOffset - priceWidth), (float)startY + 5.0f, 0x404040);
    }

    public void tick() {
        if (this.inputType == CoinValue.ValueType.DEFAULT) {
            int i;
            List<Item> coinItems = MoneyUtil.getAllCoins();
            for (i = 0; i < this.decreaseButtons.size(); ++i) {
                this.decreaseButtons.get((int)i).field_230693_o_ = i >= coinItems.size() ? false : this.coinValue.getEntry(coinItems.get(i)) > 0;
            }
            for (i = 0; i < this.increaseButtons.size(); ++i) {
                this.increaseButtons.get((int)i).field_230693_o_ = !this.coinValue.isFree();
            }
        } else if (this.valueInput != null) {
            this.valueInput.func_146178_a();
            boolean bl = this.valueInput.field_230693_o_ = !this.coinValue.isFree();
            if (!this.coinValue.isFree()) {
                TextInputUtil.whitelistFloat(this.valueInput);
                if (!this.lastInput.contentEquals(this.valueInput.func_146179_b())) {
                    this.lastInput = this.valueInput.func_146179_b();
                    this.coinValue = MoneyUtil.displayValueToCoinValue(this.getDisplayValue());
                    this.parent.OnCoinValueChanged(this);
                }
            } else {
                this.valueInput.func_146180_a("");
                this.lastInput = this.valueInput.func_146179_b();
            }
        }
    }

    public static int calculateWidth() {
        if (Config.SERVER.coinValueInputType.get() == CoinValue.ValueType.VALUE) {
            return 176;
        }
        int buttonCount = MoneyUtil.getAllData("main").size();
        return 20 + 20 * buttonCount + 10 * (buttonCount - 1);
    }

    private void IncreaseButtonHit(Button button) {
        if (!this.increaseButtons.contains(button)) {
            return;
        }
        int coinIndex = this.increaseButtons.indexOf(button);
        List<Item> coins = MoneyUtil.getAllCoins();
        if (coinIndex >= 0 && coinIndex < coins.size()) {
            Item coin = coins.get(coinIndex);
            int addAmount = 1;
            if (Screen.func_231173_s_()) {
                addAmount = this.getLargeIncreaseAmount(coin);
            }
            if (Screen.func_231172_r_()) {
                addAmount *= 10;
            }
            this.coinValue.addValue(coin, addAmount);
            this.parent.OnCoinValueChanged(this);
        } else {
            LightmansCurrency.LogError("Invalid index (" + coinIndex + ") found for the increasing button.");
        }
    }

    private void DecreaseButtonHit(Button button) {
        if (!this.decreaseButtons.contains(button)) {
            return;
        }
        int coinIndex = this.decreaseButtons.indexOf(button);
        List<Item> coins = MoneyUtil.getAllCoins();
        if (coinIndex >= 0 && coinIndex < coins.size()) {
            Item coin = coins.get(coinIndex);
            int removeAmount = 1;
            if (Screen.func_231173_s_()) {
                removeAmount = this.getLargeIncreaseAmount(coin);
            }
            if (Screen.func_231172_r_()) {
                removeAmount *= 10;
            }
            this.coinValue.removeValue(coin, removeAmount);
            this.parent.OnCoinValueChanged(this);
        } else {
            LightmansCurrency.LogError("Invalid index (" + coinIndex + ") found for the decreasing button.");
        }
    }

    private final int getLargeIncreaseAmount(Item coinItem) {
        Pair<Item, Integer> upwardConversion = MoneyUtil.getUpwardConversion(coinItem);
        if (upwardConversion != null) {
            return this.getLargeAmount(upwardConversion);
        }
        Pair<Item, Integer> downwardConversion = MoneyUtil.getDownwardConversion(coinItem);
        if (downwardConversion != null) {
            return this.getLargeAmount(downwardConversion);
        }
        return 10;
    }

    private final int getLargeAmount(Pair<Item, Integer> conversion) {
        if ((Integer)conversion.getSecond() >= 64) {
            return 16;
        }
        if ((Integer)conversion.getSecond() > 10) {
            return 10;
        }
        if ((Integer)conversion.getSecond() > 5) {
            return 5;
        }
        return 2;
    }

    private void ToggleFree(Button button) {
        this.coinValue.setFree(!this.coinValue.isFree());
        this.parent.OnCoinValueChanged(this);
    }

    public CoinValue getCoinValue() {
        return this.coinValue;
    }

    public double getDisplayValue() {
        if (this.valueInput != null) {
            return TextInputUtil.getDoubleValue(this.valueInput);
        }
        return this.coinValue.getDisplayValue();
    }

    public void setCoinValue(CoinValue newValue) {
        this.coinValue = newValue.copy();
        if (this.inputType == CoinValue.ValueType.VALUE) {
            this.valueInput.func_146180_a(Config.formatValueOnly(newValue.getDisplayValue()));
        }
    }

    public static interface ICoinValueInput {
        public <T extends Button> T addCustomButton(T var1);

        public <T extends IGuiEventListener> T addCustomListener(T var1);

        public int getWidth();

        public FontRenderer getFont();

        public void OnCoinValueChanged(CoinValueInput var1);
    }
}

