/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.trader.settings.directional.DirectionalSettings;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DirectionalSettingsWidget {
    public static final ResourceLocation BLOCK_SIDE_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/blocksides.png");
    private static final List<Direction> DIRECTIONS = Lists.newArrayList((Object[])new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST});
    private static final int SPACING = 20;
    private final Supplier<DirectionalSettings> settingSource;
    private final Consumer<Direction> onPress;
    List<PlainButton> directionButtons;

    public DirectionalSettingsWidget(int x, int y, Supplier<DirectionalSettings> settingSource, Consumer<Direction> onPress, Consumer<Button> addButton) {
        this.settingSource = settingSource;
        this.onPress = onPress;
        this.directionButtons = Lists.newArrayListWithCapacity((int)Direction.values().length);
        for (int i = 0; i < DIRECTIONS.size(); ++i) {
            Direction side = DIRECTIONS.get(i);
            boolean value = this.settingSource.get().get(side);
            PlainButton button = new PlainButton(x + this.getSidePosX(side), y + this.getSidePosY(side), 16, 16, this::onButtonPress, BLOCK_SIDE_TEXTURE, this.getSideU(side), value ? 32 : 0);
            button.field_230694_p_ = this.settingSource.get().allows(side);
            this.directionButtons.add(button);
            addButton.accept(button);
        }
    }

    public void renderTooltips(MatrixStack matrix, int mouseX, int mouseY, Screen screen) {
        for (Direction side : Direction.values()) {
            PlainButton button = this.getButton(side);
            if (!button.func_231047_b_(mouseX, mouseY)) continue;
            screen.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("gui.lightmanscurrency.settings.side." + side.toString().toLowerCase()), mouseX, mouseY);
        }
    }

    private int getSidePosX(Direction side) {
        switch (side) {
            case UP: 
            case SOUTH: 
            case DOWN: {
                return 20;
            }
            case EAST: 
            case NORTH: {
                return 40;
            }
        }
        return 0;
    }

    private int getSidePosY(Direction side) {
        switch (side) {
            case SOUTH: 
            case EAST: 
            case WEST: {
                return 20;
            }
            case DOWN: 
            case NORTH: {
                return 40;
            }
        }
        return 0;
    }

    private int getSideU(Direction side) {
        return side.func_176745_a() * 16;
    }

    public PlainButton getButton(Direction direction) {
        return this.directionButtons.get(direction.func_176745_a());
    }

    public void tick() {
        DirectionalSettings settings = this.settingSource.get();
        for (Direction side : Direction.values()) {
            PlainButton button = this.getButton(side);
            button.field_230694_p_ = settings.allows(side);
            button.setResource(BLOCK_SIDE_TEXTURE, this.getSideU(side), settings.get(side) ? 32 : 0);
        }
    }

    private void onButtonPress(Button button) {
        int index = this.directionButtons.indexOf(button);
        if (index < 0) {
            return;
        }
        this.onPress.accept(Direction.func_82600_a((int)index));
    }
}

