/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class ScrollTextDisplay
extends Widget {
    private FontRenderer font;
    private final Supplier<List<ITextComponent>> textSource;
    public boolean invertText = false;
    public int backgroundColor = -16777216;
    public int textColor = 0xFFFFFF;
    private int columnCount = 1;
    private int scroll = 0;

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = MathUtil.clamp(columnCount, 1, Integer.MAX_VALUE);
    }

    public ScrollTextDisplay(int x, int y, int width, int height, FontRenderer font, Supplier<List<ITextComponent>> textSource) {
        super(x, y, width, height, (ITextComponent)new StringTextComponent(""));
        this.font = font;
        this.textSource = textSource;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int rowHeight;
        if (!this.field_230694_p_) {
            return;
        }
        Screen.func_238467_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)this.backgroundColor);
        List text = (List)this.textSource.get();
        this.validateScroll(text.size());
        int i = this.getStartingIndex(text.size());
        int columnWidth = this.getColumnWidth();
        int bottom = this.field_230691_m_ + this.field_230689_k_;
        for (int yPos = this.field_230691_m_ + 2; yPos < bottom && i >= 0 && i < text.size(); yPos += rowHeight) {
            rowHeight = 0;
            for (int col = 0; col < this.columnCount && i >= 0 && i < text.size(); ++col) {
                int xPos = this.getXPos(col);
                ITextComponent thisText = (ITextComponent)text.get(i);
                int thisHeight = this.font.func_78267_b(thisText.getString(), columnWidth);
                if (yPos + thisHeight < bottom) {
                    this.font.func_238418_a_((ITextProperties)thisText, xPos, yPos, columnWidth, this.textColor);
                }
                if (thisHeight > rowHeight) {
                    rowHeight = thisHeight;
                }
                i = this.invertText ? i - 1 : i + 1;
            }
        }
    }

    private void validateScroll(int listSize) {
        if (this.scroll * this.columnCount >= listSize) {
            this.scroll = MathUtil.clamp(this.scroll, 0, listSize / this.columnCount - 1);
        }
    }

    private int getStartingIndex(int listSize) {
        return this.invertText ? listSize - 1 - this.scroll * this.columnCount : this.scroll * this.columnCount;
    }

    private int getColumnWidth() {
        return (this.field_230688_j_ - 4) / this.columnCount;
    }

    private int getXPos(int column) {
        int columnSpacing = this.field_230688_j_ / this.columnCount;
        return this.field_230690_l_ + 2 + column * columnSpacing;
    }

    private boolean canScrollDown() {
        return this.scroll < ((List)this.textSource.get()).size();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (!this.field_230694_p_) {
            return false;
        }
        if (delta < 0.0) {
            if (!this.canScrollDown()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }
}

