/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TeamSelectWidget
extends Widget {
    private final int rows;
    private final TeamButton.Size size;
    private final java.util.function.Supplier<List<Team>> teamSource;
    private final java.util.function.Supplier<Team> selectedTeam;
    private final Consumer<Integer> onPress;
    private List<TeamButton> teamButtons = Lists.newArrayList();
    private int scroll = 0;

    public void setVisible(boolean visible) {
        this.field_230694_p_ = visible;
        this.teamButtons.forEach(button -> {
            button.field_230694_p_ = visible;
        });
    }

    public TeamSelectWidget(int x, int y, int rows, java.util.function.Supplier<List<Team>> teamSource, java.util.function.Supplier<Team> selectedTeam, Consumer<Integer> onPress) {
        this(x, y, rows, TeamButton.Size.WIDE, teamSource, selectedTeam, onPress);
    }

    public TeamSelectWidget(int x, int y, int rows, TeamButton.Size size, java.util.function.Supplier<List<Team>> teamSource, java.util.function.Supplier<Team> selectedTeam, Consumer<Integer> onPress) {
        super(x, y, size.width, 20 * rows, (ITextComponent)new StringTextComponent(""));
        this.rows = rows;
        this.size = size;
        this.teamSource = teamSource;
        this.selectedTeam = selectedTeam;
        this.onPress = onPress;
    }

    public void init(Consumer<Button> addButton, FontRenderer font) {
        for (int i = 0; i < this.rows; ++i) {
            int index = i;
            TeamButton button = new TeamButton(this.field_230690_l_, this.field_230691_m_ + i * 20, this.size, this::onTeamSelect, font, (Supplier<Team>)((Supplier)() -> this.getTeam(index)), (Supplier<Boolean>)((Supplier)() -> this.isSelected(index)));
            this.teamButtons.add(button);
            addButton.accept(button);
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_230694_p_) {
            return;
        }
        TeamSelectWidget.func_238467_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)-16777216);
    }

    private Team getTeam(int index) {
        List<Team> teamList = this.teamSource.get();
        this.validateScroll(teamList.size());
        if ((index += this.scroll) >= 0 && index < teamList.size()) {
            return teamList.get(index);
        }
        return null;
    }

    private boolean isSelected(int index) {
        Team team = this.getTeam(index);
        if (team == null) {
            return false;
        }
        return team == this.selectedTeam.get();
    }

    private void validateScroll(int teamListSize) {
        this.scroll = MathUtil.clamp(this.scroll, 0, this.maxScroll(teamListSize));
    }

    private int maxScroll(int teamListSize) {
        return MathUtil.clamp(teamListSize - this.rows, 0, Integer.MAX_VALUE);
    }

    private boolean canScrollDown() {
        return this.scroll < this.maxScroll(this.teamSource.get().size());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (!this.field_230694_p_) {
            return false;
        }
        if (delta < 0.0) {
            if (!this.canScrollDown()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }

    private void onTeamSelect(Button button) {
        int index = this.teamButtons.indexOf(button);
        if (index < 0) {
            return;
        }
        this.onPress.accept(this.scroll + index);
    }

    protected boolean func_230987_a_(int button) {
        return false;
    }
}

