/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TimeWidget
extends Widget {
    public static final int WIDTH = 176;
    public static final int HEIGHT = 40;
    private TextFieldWidget hourInput;
    private TextFieldWidget minuteInput;
    private TextFieldWidget secondInput;
    Button setTimeButton;
    private TradeRule.GUIHandler handler;
    FontRenderer font;
    ITimeInput timeInput;
    ITextComponent noTimeText;
    long startingValue = 0L;

    public TimeWidget(int x, int y, FontRenderer font, long startingValue, TradeRule.GUIHandler handler, @Nullable ITimeInput timeInput, ITextComponent noTimeText) {
        super(x, y, 176, 40, (ITextComponent)new StringTextComponent(""));
        this.startingValue = startingValue;
        this.handler = handler;
        this.font = font;
        this.timeInput = timeInput;
        this.noTimeText = noTimeText;
        this.init();
    }

    protected void init() {
        TimeUtil.TimeData timeData = TimeUtil.separateDuration(this.startingValue);
        this.hourInput = this.handler.addListener(new TextFieldWidget(this.font, this.field_230690_l_ + 10, this.field_230691_m_ + 19, 30, 20, (ITextComponent)new StringTextComponent("")));
        this.hourInput.func_146203_f(3);
        this.hourInput.func_146180_a(Long.toString(timeData.hours));
        this.minuteInput = this.handler.addListener(new TextFieldWidget(this.font, this.field_230690_l_ + 80, this.field_230691_m_ + 19, 20, 20, (ITextComponent)new StringTextComponent("")));
        this.minuteInput.func_146203_f(2);
        this.minuteInput.func_146180_a(Long.toString(timeData.minutes));
        this.secondInput = this.handler.addListener(new TextFieldWidget(this.font, this.field_230690_l_ + 130, this.field_230691_m_ + 19, 20, 20, (ITextComponent)new StringTextComponent("")));
        this.secondInput.func_146203_f(2);
        this.secondInput.func_146180_a(Long.toString(timeData.seconds));
        this.setTimeButton = this.handler.addButton(new Button(this.field_230690_l_ + 80, this.field_230691_m_ - 2, 80, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.time_widget.settime"), this::PressSetTimeButton));
        this.setTimeButton.field_230694_p_ = this.timeInput != null;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        TimeUtil.TimeData time = this.getTime();
        if (time.miliseconds > 0L) {
            this.font.func_238421_b_(matrixStack, new TranslationTextComponent("gui.widget.lightmanscurrency.time_widget.info", new Object[]{time.hours, time.minutes, time.seconds}).getString(), (float)(this.field_230690_l_ + 10), (float)(this.field_230691_m_ + 2), 0xFFFFFF);
        } else {
            this.font.func_238421_b_(matrixStack, this.noTimeText.getString(), (float)(this.field_230690_l_ + 10), (float)(this.field_230691_m_ + 2), 0xFFFFFF);
        }
        this.getListeners().forEach(listener -> listener.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks));
        this.font.func_238421_b_(matrixStack, "h", (float)(this.field_230690_l_ + 62), (float)(this.field_230691_m_ + 25), 0xFFFFFF);
        this.font.func_238421_b_(matrixStack, "m", (float)(this.field_230690_l_ + 112), (float)(this.field_230691_m_ + 25), 0xFFFFFF);
        this.font.func_238421_b_(matrixStack, "s", (float)(this.field_230690_l_ + 162), (float)(this.field_230691_m_ + 25), 0xFFFFFF);
    }

    public void tick() {
        this.getListeners().forEach(listener -> listener.func_146178_a());
    }

    public List<Button> getButtons() {
        return ImmutableList.of((Object)this.setTimeButton);
    }

    public List<TextFieldWidget> getListeners() {
        return ImmutableList.of((Object)this.hourInput, (Object)this.minuteInput, (Object)this.secondInput);
    }

    public TimeUtil.TimeData getTime() {
        return new TimeUtil.TimeData(TimeWidget.inputValue(this.hourInput, false), TimeWidget.inputValue(this.minuteInput, true), TimeWidget.inputValue(this.secondInput, true));
    }

    private static long inputValue(TextFieldWidget textField, boolean clamp) {
        if (TimeWidget.isNumeric(textField.func_146179_b())) {
            return MathUtil.clamp(Long.parseLong(textField.func_146179_b()), 0L, 59L);
        }
        return 0L;
    }

    private static boolean isNumeric(String string) {
        if (string == null) {
            return false;
        }
        try {
            long l = Long.parseLong(string);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private void PressSetTimeButton(Button button) {
        if (this.timeInput != null) {
            this.timeInput.onTimeSet(this.getTime().miliseconds);
        }
    }

    public static interface ITimeInput {
        public void onTimeSet(long var1);
    }
}

