/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemTradeButton
extends Button {
    public static final ResourceLocation TRADE_TEXTURES = new ResourceLocation("lightmanscurrency", "textures/gui/container/traderbuttons.png");
    public static final ResourceLocation DEFAULT_BACKGROUND = new ResourceLocation("lightmanscurrency", "items/empty_item_slot");
    public static final Pair<ResourceLocation, ResourceLocation> BACKGROUND = Pair.of((Object)PlayerContainer.field_226615_c_, (Object)DEFAULT_BACKGROUND);
    public static final int WIDTH = 79;
    public static final int HEIGHT = 18;
    public static final float TEXTPOS1_X = 59.0f;
    public static final float TEXTPOS2_X = 20.0f;
    public static final float TEXTPOS_Y = 5.0f;
    public static final int SLOT_OFFSET1_X = 62;
    public static final int SLOT_OFFSET2_X = 1;
    public static final int SLOT_OFFSET_Y = 1;
    int tradeIndex;
    Supplier<IItemTrader> source;
    Supplier<Long> availableCoins;
    Supplier<IInventory> itemSlots;
    Screen screen;
    FontRenderer font;

    public ItemTradeButton(int x, int y, Button.IPressable pressable, int tradeIndex, Screen screen, FontRenderer font, Supplier<IItemTrader> source, Supplier<Long> availableCoins, Supplier<IInventory> itemSlots) {
        super(x, y, 79, 18, (ITextComponent)new StringTextComponent(""), pressable);
        this.tradeIndex = tradeIndex;
        this.screen = screen;
        this.font = font;
        this.source = source;
        this.availableCoins = availableCoins;
        this.itemSlots = itemSlots;
    }

    private ItemTradeData getTrade() {
        return (ItemTradeData)((IItemTrader)this.source.get()).getTrade(this.tradeIndex);
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.field_230693_o_ = ItemTradeButton.isActive(this.getTrade(), (IItemTrader)this.source.get());
        ItemTradeButton.renderItemTradeButton(matrixStack, this.screen, this.font, this.field_230690_l_, this.field_230691_m_, this.tradeIndex, (IItemTrader)this.source.get(), false, this.field_230692_n_, false, (Long)this.availableCoins.get(), (IInventory)this.itemSlots.get());
    }

    public static void renderItemTradeButton(MatrixStack matrixStack, Screen screen, FontRenderer font, int x, int y, int tradeIndex, IItemTrader trader, boolean inverted) {
        ItemTradeButton.renderItemTradeButton(matrixStack, screen, font, x, y, tradeIndex, trader, inverted, false, true, 0L, (IInventory)new Inventory(1));
    }

    private static void renderItemTradeButton(MatrixStack matrixStack, Screen screen, FontRenderer font, int x, int y, int tradeIndex, IItemTrader trader, boolean inverted, boolean hovered, boolean forceActive, long availableCoins, IInventory itemSlots) {
        boolean hasStock;
        boolean isValid;
        boolean active;
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        ItemTradeData trade = (ItemTradeData)trader.getTrade(tradeIndex);
        minecraft.func_110434_K().func_110577_a(TRADE_TEXTURES);
        boolean bl = active = forceActive ? true : ItemTradeButton.isActive(trade, trader);
        if (active) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        int offset = ItemTradeButton.getRenderYOffset(trade.getTradeType());
        if (hovered) {
            offset += 18;
        }
        screen.func_238474_b_(matrixStack, x, y, inverted ? 79 : 0, offset, 79, 18);
        boolean hasPermission = forceActive;
        boolean hasDiscount = false;
        boolean bl2 = isValid = forceActive ? true : trade.isValid();
        boolean bl3 = forceActive ? true : (hasStock = trade.hasStock(trader) || trader.getCoreSettings().isCreative());
        boolean hasSpace = forceActive ? true : trade.hasSpace(trader) || trader.getCoreSettings().isCreative();
        boolean canAfford = forceActive;
        CoinValue cost = trade.getCost();
        if (!forceActive) {
            TradeEvent.TradeCostEvent event = trader.runTradeCostEvent((PlayerEntity)player, tradeIndex);
            cost = event.getCostResult();
            hasDiscount = event.getCostMultiplier() != 1.0;
            hasPermission = !trader.runPreTradeEvent((PlayerEntity)player, tradeIndex).isCanceled();
            canAfford = ItemTradeButton.canAfford(trade, availableCoins, itemSlots);
        }
        if (trade.isBarter()) {
            int xPos = x + (inverted ? 62 : 1);
            if (trade.getBarterItem().func_190926_b() && forceActive) {
                xPos = x + (inverted ? 62 : 1);
                ItemRenderUtil.drawSlotBackground(matrixStack, xPos, y + 1, BACKGROUND);
            } else if (!trade.getBarterItem().func_190926_b()) {
                ItemRenderUtil.drawItemStack((AbstractGui)screen, font, trade.getBarterItem(), xPos, y + 1);
            }
            String text = ItemTradeButton.getTradeText(CoinValue.EMPTY, false, isValid, hasStock, hasSpace, hasPermission);
            int textColor = ItemTradeButton.getTradeTextColor(trade.isValid(), canAfford, hasStock, hasPermission, false);
            if (text == "" && !canAfford) {
                text = "X";
                textColor = 0xFF0000;
            }
            int textLength = font.func_78256_a(text);
            font.func_238421_b_(matrixStack, text, (float)(x + 39 - textLength / 2), (float)y + 5.0f, textColor);
        } else {
            String tradeText = ItemTradeButton.getTradeText(cost, trade.getCost().isFree(), isValid, hasStock, hasSpace, hasPermission);
            int tradeColor = ItemTradeButton.getTradeTextColor(trade.isValid(), canAfford, hasStock, hasPermission, hasDiscount);
            if (inverted) {
                font.func_238421_b_(matrixStack, tradeText, (float)x + 20.0f, (float)y + 5.0f, tradeColor);
            } else {
                int stringLength = font.func_78256_a(tradeText);
                font.func_238421_b_(matrixStack, tradeText, (float)x + 59.0f - (float)stringLength, (float)y + 5.0f, tradeColor);
            }
        }
        int xPos = x + (inverted ? 1 : 62);
        ItemStack sellItem = trade.getSellItem();
        if (sellItem.func_190926_b() && forceActive) {
            Pair<ResourceLocation, ResourceLocation> background = trade.getRestriction().getEmptySlotBG();
            if (background == null) {
                background = BACKGROUND;
            }
            if (background != null) {
                ItemRenderUtil.drawSlotBackground(matrixStack, xPos, y + 1, background);
            }
        } else if (!trade.getSellItem().func_190926_b()) {
            ItemRenderUtil.drawItemStack((AbstractGui)screen, font, trade.getSellItem(), xPos, y + 1);
        }
    }

    public void tryRenderTooltip(MatrixStack matrixStack, Screen screen, IItemTrader trader, boolean inverted, int mouseX, int mouseY) {
        if (this.field_230692_n_) {
            ItemTradeButton.tryRenderTooltip(matrixStack, screen, this.tradeIndex, trader, this.field_230690_l_, this.field_230691_m_, inverted, mouseX, mouseY);
        }
    }

    public static int tryRenderTooltip(MatrixStack matrixStack, Screen screen, int tradeIndex, IItemTrader trader, int x, int y, boolean inverted, int mouseX, int mouseY) {
        switch (((ItemTradeData)trader.getTrade(tradeIndex)).getTradeType()) {
            case BARTER: {
                if (!ItemTradeButton.isMouseOverSlot(1, x, y, mouseX, mouseY, inverted)) break;
                List<ITextComponent> tooltip = ItemTradeButton.getTooltipForItem(screen, tradeIndex, 1, trader);
                if (tooltip != null) {
                    screen.func_243308_b(matrixStack, tooltip, mouseX, mouseY);
                    return 2;
                }
                return -2;
            }
        }
        if (ItemTradeButton.isMouseOverSlot(0, x, y, mouseX, mouseY, inverted)) {
            List<ITextComponent> tooltip = ItemTradeButton.getTooltipForItem(screen, tradeIndex, 0, trader);
            if (tooltip != null) {
                screen.func_243308_b(matrixStack, tooltip, mouseX, mouseY);
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public static boolean isMouseOverSlot(int slotIndex, int x, int y, int mouseX, int mouseY, boolean inverted) {
        int minX = x + (slotIndex == 1 ? 1 : 62);
        if (inverted) {
            minX = x + (slotIndex == 1 ? 62 : 1);
        }
        return mouseX >= minX && mouseX <= minX + 16 && mouseY >= y + 1 && mouseY <= y + 18 - 1;
    }

    public static List<ITextComponent> getTooltipForItem(Screen screen, int tradeIndex, int slot, IItemTrader trader) {
        ItemStack itemStack;
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        ItemTradeData trade = (ItemTradeData)trader.getTrade(tradeIndex);
        ItemStack itemStack2 = itemStack = slot == 1 ? trade.getBarterItem() : trade.getSellItem();
        if (itemStack.func_190926_b()) {
            return null;
        }
        List tooltips = screen.func_231151_a_(itemStack);
        ITextComponent originalName = null;
        if (!trade.getCustomName().isEmpty() && (trade.isSale() || trade.isBarter() && slot != 1)) {
            originalName = (ITextComponent)tooltips.get(0);
            tooltips.set(0, new StringTextComponent("\u00a76" + trade.getCustomName()));
        }
        if (slot != 1) {
            tooltips.add(new TranslationTextComponent("tooltip.lightmanscurrency.trader.info"));
            if (originalName != null) {
                tooltips.add(new TranslationTextComponent("tooltip.lightmanscurrency.trader.originalname", new Object[]{originalName}));
            }
            tooltips.add(new TranslationTextComponent("tooltip.lightmanscurrency.trader.stock", new Object[]{trader.getCoreSettings().isCreative() ? new TranslationTextComponent("tooltip.lightmanscurrency.trader.stock.infinite") : new StringTextComponent("\u00a76" + trade.stockCount(trader))}));
            TradeEvent.PreTradeEvent pte = trader.runPreTradeEvent((PlayerEntity)player, tradeIndex);
            if (pte.isCanceled()) {
                pte.getDenialReasons().forEach(reason -> tooltips.add(reason));
            }
        }
        return tooltips;
    }

    public static String getTradeText(CoinValue cost, boolean isFree, boolean isValid, boolean hasStock, boolean hasSpace, boolean hasPermission) {
        if (isValid && !hasPermission) {
            return new TranslationTextComponent("tooltip.lightmanscurrency.denied").getString();
        }
        if (isValid && !hasStock) {
            return new TranslationTextComponent("tooltip.lightmanscurrency.outofstock").getString();
        }
        if (isValid && !hasSpace) {
            return new TranslationTextComponent("tooltip.lightmanscurrency.outofspace").getString();
        }
        if (isValid && cost.isValid()) {
            return cost.getString();
        }
        return "";
    }

    public static int getTradeTextColor(boolean isValid, boolean canAfford, boolean hasStock, boolean hasPermission, boolean hasDiscount) {
        if (isValid && !hasStock || !canAfford || !hasPermission) {
            return 0xFF0000;
        }
        if (hasDiscount) {
            return 65280;
        }
        return 0xFFFFFF;
    }

    public static int getRenderYOffset(ItemTradeData.ItemTradeType tradeDirection) {
        if (tradeDirection == ItemTradeData.ItemTradeType.PURCHASE) {
            return 36;
        }
        if (tradeDirection == ItemTradeData.ItemTradeType.BARTER) {
            return 72;
        }
        return 0;
    }

    protected static boolean canAfford(ItemTradeData trade, long availableCoins, IInventory itemSlots) {
        if (trade.isSale()) {
            if (trade.getCost().isFree()) {
                return true;
            }
            return availableCoins >= trade.getCost().getRawValue();
        }
        if (trade.isPurchase()) {
            return InventoryUtil.GetItemCount(itemSlots, trade.getSellItem()) >= trade.getSellItem().func_190916_E();
        }
        if (trade.isBarter()) {
            return InventoryUtil.GetItemCount(itemSlots, trade.getBarterItem()) >= trade.getBarterItem().func_190916_E();
        }
        return true;
    }

    public static boolean isActive(ItemTradeData trade, IItemTrader trader) {
        if (trade.isValid()) {
            return trader.getCoreSettings().isCreative() || trade.hasStock(trader);
        }
        return false;
    }
}

