/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TabButton
extends Button {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/tradersettings.png");
    public static final int SIZE = 25;
    public final ITab tab;
    private final FontRenderer font;
    private int rotation = 0;

    public TabButton(Button.IPressable pressable, FontRenderer font, ITab tab) {
        super(0, 0, 25, 25, (ITextComponent)new StringTextComponent(""), pressable);
        this.font = font;
        this.tab = tab;
    }

    public void reposition(int x, int y, int rotation) {
        this.field_230690_l_ = x;
        this.field_230691_m_ = y;
        this.rotation = MathUtil.clamp(rotation, 0, 3);
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_TEXTURE);
        float r = (float)(this.tab.getColor() >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.tab.getColor() >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.tab.getColor() & 0xFF) / 255.0f;
        float activeColor = this.field_230693_o_ ? 1.0f : 0.5f;
        RenderSystem.color3f((float)(r * activeColor), (float)(g * activeColor), (float)(b * activeColor));
        int xOffset = this.rotation < 2 ? 0 : this.field_230688_j_;
        int yOffset = (this.rotation % 2 == 0 ? 0 : 2 * this.field_230689_k_) + (this.field_230693_o_ ? 0 : this.field_230689_k_);
        this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, 200 + xOffset, yOffset, this.field_230688_j_, this.field_230689_k_);
        RenderSystem.color3f((float)activeColor, (float)activeColor, (float)activeColor);
        this.tab.getIcon().render(matrixStack, (Widget)this, this.font, this.field_230690_l_ + 4, this.field_230691_m_ + 4);
    }

    public static interface ITab {
        @Nonnull
        public IconData getIcon();

        public int getColor();

        public ITextComponent getTooltip();
    }
}

