/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TeamButton
extends Button {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/teambutton.png");
    public static final int HEIGHT = 20;
    public static final int TEXT_COLOR = 0xFFFFFF;
    private final FontRenderer font;
    private final Size size;
    private final Supplier<Team> teamSource;
    private final Supplier<Boolean> selectedSource;

    public Team getTeam() {
        return (Team)this.teamSource.get();
    }

    public TeamButton(int x, int y, Size size, Button.IPressable press, FontRenderer font, @Nonnull Supplier<Team> teamSource, @Nonnull Supplier<Boolean> selectedSource) {
        super(x, y, size.width, 20, (ITextComponent)new StringTextComponent(""), press);
        this.font = font;
        this.size = size;
        this.teamSource = teamSource;
        this.selectedSource = selectedSource;
    }

    public void func_230430_a_(MatrixStack pose, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_230694_p_ || this.getTeam() == null) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_238474_b_(pose, this.field_230690_l_, this.field_230691_m_, 0, ((Boolean)this.selectedSource.get() != false ? 20 : 0) + this.size.guiPos, this.size.width, 20);
        this.font.func_238421_b_(pose, this.fitString(this.getTeam().getName()), (float)(this.field_230690_l_ + 2), (float)(this.field_230691_m_ + 2), 0xFFFFFF);
        this.font.func_238421_b_(pose, this.fitString(new TranslationTextComponent("gui.button.lightmanscurrency.team.owner", new Object[]{this.getTeam().getOwner().lastKnownName()}).getString()), (float)(this.field_230690_l_ + 2), (float)(this.field_230691_m_ + 10), 0xFFFFFF);
    }

    private String fitString(String string) {
        if (this.font.func_78256_a(string) <= this.field_230688_j_ - 4) {
            return string;
        }
        while (this.font.func_78256_a(string + "...") > this.field_230688_j_ - 4) {
            string = string.substring(0, string.length() - 1);
        }
        return string + "...";
    }

    public static enum Size {
        WIDE(180, 0),
        NORMAL(156, 1),
        NARROW(90, 2);

        public final int width;
        public final int guiPos;

        private Size(int width, int guiPos) {
            this.width = width;
            this.guiPos = guiPos * 20 * 2;
        }
    }
}

