/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.tileentity.ItemTraderTileEntity;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class ItemTraderTileEntityRenderer
extends TileEntityRenderer<ItemTraderTileEntity> {
    public static int positionLimit() {
        switch ((Config.Client.TraderRenderType)((Object)Config.CLIENT.traderRenderType.get())) {
            case PARTIAL: {
                return 1;
            }
            case NONE: {
                return 0;
            }
        }
        return Integer.MAX_VALUE;
    }

    public ItemTraderTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(ItemTraderTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int i, int i1) {
        for (int tradeSlot = 0; tradeSlot < tileEntity.getTradeCount() && tradeSlot < tileEntity.maxRenderIndex(); ++tradeSlot) {
            ItemTradeData trade = tileEntity.getTrade(tradeSlot);
            if (trade.getSellItem().func_190926_b()) continue;
            ItemStack stack = trade.getSellItem();
            boolean isBlock = stack.func_77973_b() instanceof BlockItem;
            if (isBlock && ((List)Config.CLIENT.renderBlocksAsItems.get()).contains(stack.func_77973_b().getRegistryName().toString())) {
                isBlock = false;
            }
            List<Vector3f> positions = tileEntity.GetStackRenderPos(tradeSlot, isBlock);
            List<Quaternion> rotation = tileEntity.GetStackRenderRot(tradeSlot, partialTicks, isBlock);
            Vector3f scale = tileEntity.GetStackRenderScale(tradeSlot, isBlock);
            for (int pos = 0; pos < positions.size() && pos < tileEntity.getTradeStock(tradeSlot) && pos < ItemTraderTileEntityRenderer.positionLimit(); ++pos) {
                matrixStack.func_227860_a_();
                Vector3f position = positions.get(pos);
                matrixStack.func_227861_a_((double)position.func_195899_a(), (double)position.func_195900_b(), (double)position.func_195902_c());
                for (Quaternion rot : rotation) {
                    matrixStack.func_227863_a_(rot);
                }
                matrixStack.func_227862_a_(scale.func_195899_a(), scale.func_195900_b(), scale.func_195902_c());
                Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, i, i1, matrixStack, renderTypeBuffer);
                matrixStack.func_227865_b_();
            }
        }
    }
}

