/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.client.gui.widget.TextFieldWidget;

public class TextInputUtil {
    private static final String INTEGER_WHITELIST = "0123456789";
    private static final String FLOAT_WHITELIST = "0123456789.";

    public static boolean isInteger(TextFieldWidget textInput) {
        if (textInput == null) {
            return false;
        }
        return TextInputUtil.isInteger(textInput.func_146179_b());
    }

    public static boolean isInteger(String text) {
        if (text == null) {
            return false;
        }
        try {
            int n = Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static int getIntegerValue(TextFieldWidget textInput) {
        return TextInputUtil.getIntegerValue(textInput, 0);
    }

    public static int getIntegerValue(TextFieldWidget textInput, int defaultValue) {
        if (TextInputUtil.isInteger(textInput)) {
            return Integer.parseInt(textInput.func_146179_b());
        }
        return defaultValue;
    }

    public static boolean isLong(TextFieldWidget textInput) {
        return TextInputUtil.isLong(textInput.func_146179_b());
    }

    public static boolean isLong(String text) {
        if (text == null) {
            return false;
        }
        try {
            long l = Long.parseLong(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static long getLongValue(TextFieldWidget textInput) {
        return TextInputUtil.getLongValue(textInput, 0);
    }

    public static long getLongValue(TextFieldWidget textInput, int defaultValue) {
        if (TextInputUtil.isLong(textInput)) {
            return Long.parseLong(textInput.func_146179_b());
        }
        return defaultValue;
    }

    public static boolean isFloat(TextFieldWidget textInput) {
        return TextInputUtil.isFloat(textInput.func_146179_b());
    }

    public static boolean isFloat(String text) {
        if (text == null) {
            return false;
        }
        try {
            float f = Float.parseFloat(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static float getFloatValue(TextFieldWidget textInput) {
        return TextInputUtil.getFloatValue(textInput, 0.0f);
    }

    public static float getFloatValue(TextFieldWidget textInput, float defaultValue) {
        if (TextInputUtil.isFloat(textInput)) {
            return Float.parseFloat(textInput.func_146179_b());
        }
        return defaultValue;
    }

    public static boolean isDouble(TextFieldWidget textInput) {
        return TextInputUtil.isDouble(textInput.func_146179_b());
    }

    public static boolean isDouble(String text) {
        if (text == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static double getDoubleValue(TextFieldWidget textInput) {
        return TextInputUtil.getDoubleValue(textInput, 0.0);
    }

    public static double getDoubleValue(TextFieldWidget textInput, double defaultValue) {
        if (TextInputUtil.isDouble(textInput)) {
            return Double.parseDouble(textInput.func_146179_b());
        }
        return defaultValue;
    }

    public static void whitelistInteger(TextFieldWidget textInput) {
        TextInputUtil.whitelistText(textInput, INTEGER_WHITELIST);
    }

    public static void whitelistInteger(TextFieldWidget textInput, long minValue, long maxValue) {
        long currentValue;
        TextInputUtil.whitelistText(textInput, INTEGER_WHITELIST);
        if (textInput.func_146179_b().length() > 0 && ((currentValue = TextInputUtil.getLongValue(textInput)) < minValue || currentValue > maxValue)) {
            currentValue = MathUtil.clamp(currentValue, minValue, maxValue);
            textInput.func_146180_a(Long.toString(currentValue));
        }
    }

    public static void whitelistFloat(TextFieldWidget textInput) {
        TextInputUtil.whitelistText(textInput, FLOAT_WHITELIST);
    }

    public static void whitelistText(TextFieldWidget textInput, String allowedChars) {
        StringBuilder newText = new StringBuilder(textInput.func_146179_b());
        for (int i = 0; i < newText.length(); ++i) {
            boolean allowed = false;
            for (int x = 0; x < allowedChars.length() && !allowed; ++x) {
                if (allowedChars.charAt(x) != newText.charAt(i)) continue;
                allowed = true;
            }
            if (allowed) continue;
            newText.deleteCharAt(i);
        }
        textInput.func_146180_a(newText.toString());
    }
}

