/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.MessageArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class CommandLCAdmin {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder lcAdminCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"lcadmin").requires(commandSource -> commandSource.func_197034_c(2))).then(Commands.func_197057_a((String)"help").executes(CommandLCAdmin::help))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"toggleadmin").requires(commandSource -> commandSource.func_197022_f() instanceof ServerPlayerEntity)).executes(CommandLCAdmin::toggleAdmin))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"universaldata").then(Commands.func_197057_a((String)"list").executes(CommandLCAdmin::listUniversalData))).then(Commands.func_197057_a((String)"search").then(Commands.func_197056_a((String)"searchText", (ArgumentType)MessageArgument.func_197123_a()).executes(CommandLCAdmin::searchUniversalData)))).then(Commands.func_197057_a((String)"delete").then(Commands.func_197056_a((String)"dataID", (ArgumentType)MessageArgument.func_197123_a()).executes(CommandLCAdmin::deleteUniversalData))));
        dispatcher.register(lcAdminCommand);
    }

    static int help(CommandContext<CommandSource> commandContext) throws CommandSyntaxException {
        CommandSource source = (CommandSource)commandContext.getSource();
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.help.help", new Object[]{"/lcadmin help -> "}), false);
        if (source.func_197022_f() instanceof ServerPlayerEntity) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.toggleadmin.help", new Object[]{"/lcadmin toggleadmin -> "}), false);
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.list.help", new Object[]{"/lcadmin universaldata list -> "}), false);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.delete.help", new Object[]{"/lcadmin universaldata delete <traderID> "}), false);
        return 1;
    }

    static int toggleAdmin(CommandContext<CommandSource> commandContext) throws CommandSyntaxException {
        CommandSource source = (CommandSource)commandContext.getSource();
        ServerPlayerEntity sourcePlayer = source.func_197035_h();
        TradingOffice.toggleAdminPlayer((PlayerEntity)sourcePlayer);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.toggleadmin", new Object[]{new TranslationTextComponent("command.lightmanscurrency.lcadmin.toggleadmin." + (TradingOffice.isAdminPlayer((PlayerEntity)sourcePlayer) ? "enabled" : "disabled"))}), true);
        return 1;
    }

    static int listUniversalData(CommandContext<CommandSource> commandContext) throws CommandSyntaxException {
        CommandSource source = (CommandSource)commandContext.getSource();
        List<UniversalTraderData> allTraders = TradingOffice.getTraders();
        if (allTraders.size() > 0) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.list.title"), true);
            for (int i = 0; i < allTraders.size(); ++i) {
                UniversalTraderData thisTrader = allTraders.get(i);
                if (i > 0) {
                    source.func_197030_a((ITextComponent)new StringTextComponent(""), true);
                }
                CommandLCAdmin.sendTraderDataFeedback(thisTrader, source);
            }
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.list.none"), true);
        }
        return 1;
    }

    static int searchUniversalData(CommandContext<CommandSource> commandContext) throws CommandSyntaxException {
        CommandSource source = (CommandSource)commandContext.getSource();
        String searchText = MessageArgument.func_197124_a(commandContext, (String)"searchText").getString();
        List<UniversalTraderData> allTraders = TradingOffice.getTraders(searchText);
        if (allTraders.size() > 0) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.list.title"), true);
            for (int i = 0; i < allTraders.size(); ++i) {
                UniversalTraderData thisTrader = allTraders.get(i);
                if (i > 0) {
                    source.func_197030_a((ITextComponent)new StringTextComponent(""), true);
                }
                CommandLCAdmin.sendTraderDataFeedback(thisTrader, source);
            }
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.list.search.none"), true);
        }
        return 1;
    }

    private static void sendTraderDataFeedback(UniversalTraderData thisTrader, CommandSource source) {
        String traderID = thisTrader.getTraderID().toString();
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.list.traderid", new Object[]{new StringTextComponent(traderID).func_240703_c_(Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, traderID)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.list.traderid.copytooltip"))))}), true);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.list.type", new Object[]{thisTrader.getTraderType()}), true);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.list.owner", new Object[]{thisTrader.getCoreSettings().getOwner().lastKnownName(), thisTrader.getCoreSettings().getOwner().id.toString()}), true);
        String dimension = thisTrader.getWorld().func_240901_a_().toString();
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.list.dimension", new Object[]{dimension}), true);
        BlockPos pos = thisTrader.getPos();
        String position = pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p();
        String teleportPosition = pos.func_177958_n() + " " + (pos.func_177956_o() + 1) + " " + pos.func_177952_p();
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.list.position", new Object[]{new StringTextComponent(position).func_240703_c_(Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/execute in " + dimension + " run tp @s " + teleportPosition)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.list.position.teleporttooltip"))))}), true);
        if (thisTrader.getCoreSettings().hasCustomName()) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.list.name", new Object[]{thisTrader.getName()}), true);
        }
    }

    static int deleteUniversalData(CommandContext<CommandSource> commandContext) throws CommandSyntaxException {
        CommandSource source = (CommandSource)commandContext.getSource();
        String traderID = MessageArgument.func_197124_a(commandContext, (String)"dataID").getString();
        if (traderID == "") {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.delete.noid"));
            return 0;
        }
        List<UniversalTraderData> allTraders = TradingOffice.getTraders();
        for (int i = 0; i < allTraders.size(); ++i) {
            if (!allTraders.get(i).getTraderID().toString().equals(traderID)) continue;
            TradingOffice.removeTrader(allTraders.get(i).getTraderID());
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.delete.success", new Object[]{traderID}), true);
            return 1;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lightmanscurrency.lcadmin.universaldata.delete.notfound"), true);
        return 0;
    }
}

