/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blocks.ITraderBlock;
import io.github.lightman314.lightmanscurrency.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.common.capability.CurrencyCapabilities;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.containers.WalletContainer;
import io.github.lightman314.lightmanscurrency.events.WalletDropEvent;
import io.github.lightman314.lightmanscurrency.gamerule.ModGameRules;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.money.CoinData;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.wallet.MessagePlayPickupSound;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.SPacketSyncWallet;
import io.github.lightman314.lightmanscurrency.tileentity.IOwnableTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.PaygateTileEntity;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber
public class EventHandler {
    @SubscribeEvent
    public static void pickupItem(EntityItemPickupEvent event) {
        WalletItem walletItem;
        WalletContainer container;
        ItemStack pickupItem = event.getItem().func_92059_d();
        CoinData coinData = MoneyUtil.getData(pickupItem.func_77973_b());
        if (coinData == null || coinData.isHidden) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack coinStack = event.getItem().func_92059_d();
        WalletContainer activeContainer = null;
        if (player.field_71070_bA instanceof WalletContainer && (container = (WalletContainer)player.field_71070_bA).canPickup()) {
            activeContainer = container;
        }
        boolean cancelEvent = false;
        ItemStack wallet = LightmansCurrency.getWalletStack(player);
        if (!wallet.func_190926_b() && WalletItem.CanPickup(walletItem = (WalletItem)wallet.func_77973_b())) {
            cancelEvent = true;
            coinStack = activeContainer != null && activeContainer.getWalletIndex() < 0 ? activeContainer.PickupCoins(coinStack) : WalletItem.PickupCoin(wallet, coinStack);
        }
        if (event.isCancelable() && cancelEvent) {
            event.getItem().func_92058_a(ItemStack.field_190927_a);
            if (!coinStack.func_190926_b() && !player.field_71071_by.func_70441_a(coinStack)) {
                ItemEntity itemEntity = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), coinStack);
                itemEntity.func_174867_a(40);
                player.field_70170_p.func_217376_c((Entity)itemEntity);
            }
            if (!player.field_70170_p.field_72995_K) {
                LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(player), (Object)new MessagePlayPickupSound());
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        PaygateTileEntity paygateEntity;
        TileEntity tileEntity;
        IWorld world = event.getWorld();
        BlockState state = world.func_180495_p(event.getPos());
        if (state.func_177230_c() instanceof ITraderBlock) {
            IOwnableTileEntity traderEntity;
            ITraderBlock block = (ITraderBlock)state.func_177230_c();
            TileEntity tileEntity2 = block.getTileEntity(state, world, event.getPos());
            if (tileEntity2 instanceof IOwnableTileEntity && !(traderEntity = (IOwnableTileEntity)tileEntity2).canBreak(event.getPlayer())) {
                event.setCanceled(true);
            }
        } else if (state.func_177230_c() instanceof PaygateBlock && (tileEntity = world.func_175625_s(event.getPos())) instanceof PaygateTileEntity && !(paygateEntity = (PaygateTileEntity)tileEntity).canBreak(event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void attachEntitiesCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(CurrencyCapabilities.ID_WALLET, WalletCapability.createProvider((PlayerEntity)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        WalletCapability.getWalletHandler((Entity)event.getPlayer()).ifPresent(walletHandler -> LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(event.getPlayer()), (Object)new SPacketSyncWallet(event.getPlayer().func_145782_y(), walletHandler.getWallet())));
    }

    @SubscribeEvent
    public static void playerStartTracking(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        PlayerEntity player = event.getPlayer();
        if (!player.field_70170_p.field_72995_K) {
            WalletCapability.getWalletHandler(target).ifPresent(walletHandler -> LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(player), (Object)new SPacketSyncWallet(target.func_145782_y(), walletHandler.getWallet())));
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        PlayerEntity player = event.getPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        PlayerEntity oldPlayer = event.getOriginal();
        oldPlayer.revive();
        LazyOptional<IWalletHandler> oldHandler = WalletCapability.getWalletHandler((Entity)oldPlayer);
        LazyOptional<IWalletHandler> newHandler = WalletCapability.getWalletHandler((Entity)player);
        oldHandler.ifPresent(oldWallet -> newHandler.ifPresent(newWallet -> newWallet.setWallet(oldWallet.getWallet())));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void playerDrops(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity.field_70170_p.field_72995_K) {
            return;
        }
        if (!livingEntity.func_175149_v()) {
            WalletCapability.getWalletHandler((Entity)livingEntity).ifPresent(walletHandler -> {
                ItemStack walletStack = walletHandler.getWallet();
                if (walletStack.func_190926_b()) {
                    return;
                }
                Collection<Object> walletDrops = Lists.newArrayList();
                if (livingEntity instanceof PlayerEntity) {
                    int coinDropPercent;
                    boolean keepInventory = livingEntity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c);
                    GameRules.BooleanValue keepWalletVal = ModGameRules.getCustomValue(livingEntity.field_70170_p, ModGameRules.KEEP_WALLET);
                    GameRules.IntegerValue coinDropPercentVal = ModGameRules.getCustomValue(livingEntity.field_70170_p, ModGameRules.COIN_DROP_PERCENT);
                    boolean keepWallet = keepWalletVal != null && keepWalletVal.func_223572_a() || keepInventory;
                    int n = coinDropPercent = coinDropPercentVal == null ? 0 : coinDropPercentVal.func_223560_a();
                    if (keepWallet && coinDropPercent <= 0) {
                        return;
                    }
                    if (keepWallet) {
                        List<ItemEntity> d = EventHandler.getWalletDrops(livingEntity, walletStack, coinDropPercent);
                        walletDrops.addAll(d);
                        WalletDropEvent e = new WalletDropEvent((PlayerEntity)livingEntity, (IWalletHandler)walletHandler, event.getSource(), (Collection<ItemEntity>)walletDrops, keepWallet, coinDropPercent);
                        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
                            return;
                        }
                        walletDrops = e.getDrops();
                    } else {
                        walletDrops.add(EventHandler.getDrop(livingEntity, walletStack));
                        walletHandler.setWallet(ItemStack.field_190927_a);
                        WalletDropEvent e = new WalletDropEvent((PlayerEntity)livingEntity, (IWalletHandler)walletHandler, event.getSource(), (Collection<ItemEntity>)walletDrops, keepWallet, coinDropPercent);
                        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
                            return;
                        }
                        walletDrops = e.getDrops();
                    }
                } else {
                    walletDrops.add(EventHandler.getDrop(livingEntity, walletStack));
                    walletHandler.setWallet(ItemStack.field_190927_a);
                }
                event.getDrops().addAll(walletDrops);
            });
        }
    }

    private static ItemEntity getDrop(LivingEntity entity, ItemStack stack) {
        return new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack);
    }

    private static List<ItemEntity> getWalletDrops(LivingEntity entity, ItemStack walletStack, int coinDropPercent) {
        double coinPercentage = MathUtil.clamp((double)coinDropPercent / 100.0, 0.0, 1.0);
        NonNullList<ItemStack> walletList = WalletItem.getWalletInventory(walletStack);
        long walletContents = new CoinValue(walletList).getRawValue();
        long droppedAmount = (long)((double)walletContents * coinPercentage);
        if (droppedAmount < 1L) {
            return Lists.newArrayList();
        }
        Inventory walletInventory = InventoryUtil.buildInventory(walletList);
        ArrayList drops = Lists.newArrayList();
        long extra = MoneyUtil.takeObjectsOfValue(droppedAmount, (IInventory)walletInventory, true);
        if (extra < 0L) {
            List<ItemStack> extraCoins = MoneyUtil.getCoinsOfValue(-extra);
            for (int i = 0; i < extraCoins.size(); ++i) {
                ItemStack coinStack = InventoryUtil.TryPutItemStack((IInventory)walletInventory, extraCoins.get(i));
                if (coinStack.func_190926_b()) continue;
                drops.add(EventHandler.getDrop(entity, coinStack));
            }
        }
        WalletItem.putWalletInventory(walletStack, InventoryUtil.buildList((IInventory)walletInventory));
        drops.addAll(EventHandler.getCoinDrops(entity, droppedAmount));
        return drops;
    }

    private static Collection<ItemEntity> getCoinDrops(LivingEntity entity, long coinValue) {
        ArrayList drops = Lists.newArrayList();
        List<ItemStack> coinsOfValue = MoneyUtil.getCoinsOfValue(coinValue);
        for (int i = 0; i < coinsOfValue.size(); ++i) {
            ItemStack coinStack = coinsOfValue.get(i);
            for (int count = 0; count < coinStack.func_190916_E(); ++count) {
                ItemStack coin = coinStack.func_77946_l();
                coin.func_190920_e(1);
                drops.add(EventHandler.getDrop(entity, coin));
            }
        }
        return drops;
    }

    @SubscribeEvent
    public static void entityTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity.field_70170_p.field_72995_K) {
            return;
        }
        WalletCapability.getWalletHandler((Entity)livingEntity).ifPresent(walletHandler -> {
            if (walletHandler.isDirty()) {
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> livingEntity), (Object)new SPacketSyncWallet(livingEntity.func_145782_y(), walletHandler.getWallet()));
                walletHandler.clean();
            }
        });
    }
}

