/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common;

import io.github.lightman314.lightmanscurrency.trader.IItemTrader;

public class ItemTraderUtil {
    public static final int TRADEBUTTON_VERT_SPACER = 4;
    public static final int TRADEBUTTON_VERTICALITY = 22;
    public static final int TRADEBUTTON_HORIZ_SPACER = 6;
    public static final int TRADEBUTTON_HORIZONTAL = 85;

    public static int getWidth(IItemTrader trader) {
        return Math.max(176, ItemTraderUtil.getTradeDisplayWidth(trader));
    }

    public static int getTradeDisplayWidth(IItemTrader trader) {
        return 12 + ItemTraderUtil.getTradeDisplayColumnCount(trader) * 85 - 6;
    }

    public static int getTradeDisplayHeight(IItemTrader trader) {
        return 17 + ItemTraderUtil.getTradeDisplayRowCount(trader) * 22 + 7;
    }

    public static int getTradeDisplayOffset(IItemTrader trader) {
        if (ItemTraderUtil.getTradeDisplayWidth(trader) > 176) {
            return 0;
        }
        return (176 - ItemTraderUtil.getTradeDisplayWidth(trader)) / 2;
    }

    public static int getInventoryDisplayOffset(IItemTrader trader) {
        if (ItemTraderUtil.getTradeDisplayWidth(trader) <= 176) {
            return 0;
        }
        return (ItemTraderUtil.getTradeDisplayWidth(trader) - 176) / 2;
    }

    public static int getTradeDisplayColumnCount(IItemTrader trader) {
        if (trader.getTradeCount() <= 6) {
            return 2;
        }
        return 4;
    }

    public static int getTradeDisplayRowCount(IItemTrader trader) {
        return (trader.getTradeCount() - 1) / ItemTraderUtil.getTradeDisplayColumnCount(trader) + 1;
    }

    public static int getColumnOf(IItemTrader trader, int validSlotIndex) {
        return validSlotIndex % ItemTraderUtil.getTradeDisplayColumnCount(trader);
    }

    public static int getRowOf(IItemTrader trader, int validSlotIndex) {
        return validSlotIndex / ItemTraderUtil.getTradeDisplayColumnCount(trader);
    }

    public static int getButtonPosX(IItemTrader trader, int validSlotIndex) {
        float offset = 0.0f;
        if (ItemTraderUtil.getRowOf(trader, validSlotIndex) == ItemTraderUtil.getTradeDisplayRowCount(trader) - 1 && trader.getTradeCount() % ItemTraderUtil.getTradeDisplayColumnCount(trader) != 0) {
            offset = 0.5f * (float)ItemTraderUtil.getTradeDisplayColumnCount(trader) - 0.5f * (float)(trader.getTradeCount() % ItemTraderUtil.getTradeDisplayColumnCount(trader));
        }
        return (int)((float)(6 + ItemTraderUtil.getTradeDisplayOffset(trader)) + ((float)(validSlotIndex % ItemTraderUtil.getTradeDisplayColumnCount(trader)) + offset) * 85.0f);
    }

    public static int getButtonPosY(IItemTrader trader, int validSlotIndex) {
        return 17 + ItemTraderUtil.getRowOf(trader, validSlotIndex) * 22;
    }

    @Deprecated
    public static int getSlotPosX(IItemTrader trader, int validSlotIndex) {
        return ItemTraderUtil.getButtonPosX(trader, validSlotIndex) + 62;
    }

    @Deprecated
    public static int getSlotPosY(IItemTrader trader, int validSlotIndex) {
        return ItemTraderUtil.getButtonPosY(trader, validSlotIndex) + 1;
    }
}

