/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.capability;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.capability.CurrencyCapabilities;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class WalletCapability {
    public static void register() {
        CapabilityManager.INSTANCE.register(IWalletHandler.class, (Capability.IStorage)new Capability.IStorage<IWalletHandler>(){

            public INBT writeNBT(Capability<IWalletHandler> capability, IWalletHandler instance, Direction side) {
                return instance.save();
            }

            public void readNBT(Capability<IWalletHandler> capability, IWalletHandler instance, Direction side, INBT nbt) {
                if (nbt instanceof CompoundNBT) {
                    instance.load((CompoundNBT)nbt);
                }
            }
        }, WalletHandler::new);
    }

    public static LazyOptional<IWalletHandler> getWalletHandler(@Nonnull Entity entity) {
        return entity.getCapability(CurrencyCapabilities.WALLET);
    }

    public static ICapabilityProvider createProvider(PlayerEntity playerEntity) {
        return new Provider(playerEntity);
    }

    public static class Provider
    implements ICapabilitySerializable<INBT> {
        final LazyOptional<IWalletHandler> optional;
        final IWalletHandler handler;

        Provider(PlayerEntity playerEntity) {
            this.handler = new WalletHandler((LivingEntity)playerEntity);
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction facing) {
            return CurrencyCapabilities.WALLET.orEmpty(capability, this.optional);
        }

        public INBT serializeNBT() {
            return CurrencyCapabilities.WALLET.writeNBT((Object)this.handler, null);
        }

        public void deserializeNBT(INBT nbt) {
            CurrencyCapabilities.WALLET.readNBT((Object)this.handler, null, nbt);
        }
    }

    public static class WalletHandler
    implements IWalletHandler {
        final LivingEntity entity;
        ItemStack backupWallet;
        final Inventory walletInventory;

        public WalletHandler() {
            this(null);
        }

        public WalletHandler(LivingEntity entity) {
            this.entity = entity;
            this.backupWallet = ItemStack.field_190927_a;
            this.walletInventory = new Inventory(1);
        }

        @Override
        public IInventory getInventory() {
            return this.walletInventory;
        }

        @Override
        public ItemStack getWallet() {
            return this.walletInventory.func_70301_a(0);
        }

        @Override
        public void setWallet(ItemStack walletStack) {
            this.walletInventory.func_70299_a(0, walletStack);
            if (!(walletStack.func_77973_b() instanceof WalletItem)) {
                LightmansCurrency.LogWarning("Equipped a non-wallet to the players wallet slot.");
            }
        }

        @Override
        public LivingEntity getEntity() {
            return this.entity;
        }

        @Override
        public boolean isDirty() {
            return !InventoryUtil.ItemMatches(this.backupWallet, this.getWallet()) || this.backupWallet.func_190916_E() != this.getWallet().func_190916_E();
        }

        @Override
        public void clean() {
            this.backupWallet = this.getWallet().func_77946_l();
        }

        @Override
        public CompoundNBT save() {
            CompoundNBT compound = new CompoundNBT();
            CompoundNBT walletItem = this.getWallet().func_77955_b(new CompoundNBT());
            compound.func_218657_a("Wallet", (INBT)walletItem);
            return compound;
        }

        @Override
        public void load(CompoundNBT compound) {
            ItemStack wallet = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Wallet"));
            this.setWallet(wallet);
            this.clean();
        }
    }
}

